/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools.parser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import jp.fourthline.mabiicco.midi.InstType;
import jp.fourthline.mabiicco.midi.MabiDLS;
import jp.fourthline.mmlTools.MMLEvent;
import jp.fourthline.mmlTools.MMLEventList;
import jp.fourthline.mmlTools.MMLExceptionList;
import jp.fourthline.mmlTools.MMLScore;
import jp.fourthline.mmlTools.MMLTrack;
import jp.fourthline.mmlTools.MMLVerifyException;
import jp.fourthline.mmlTools.Marker;
import jp.fourthline.mmlTools.parser.AbstractMMLParser;
import jp.fourthline.mmlTools.parser.Extension3mleTrack;
import jp.fourthline.mmlTools.parser.MMLParseException;
import jp.fourthline.mmlTools.parser.SectionContents;
import jp.fourthline.mmlTools.parser.TextParser;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;

public final class MMLFile
extends AbstractMMLParser {
    private final MMLScore score = new MMLScore();
    private String encoding = "Shift_JIS";
    private short resolution = (short)96;
    private final TextParser parser = new TextParser().pattern("Title=", string -> this.score.setTitle((String)string)).pattern("Source=", string -> this.score.setAuthor((String)string)).pattern("Encoding=", string -> {
        this.encoding = string;
    });
    private final LinkedList<String> mmlParts = new LinkedList();
    private List<Extension3mleTrack> trackList = null;
    private static final Pattern CRLF_PATTERN = Pattern.compile("\r\n");
    private static final Pattern CR_PATTERN = Pattern.compile("\r");
    private static final Pattern END_LINE_PATTERN = Pattern.compile("//.*\n");
    private static final Pattern COMMENT_PATTERN = Pattern.compile("/\\*/?([^/]|[^*]/)*\\*/");
    private static final Pattern SPACE_PATTERN = Pattern.compile("[ \t\n]");

    @Override
    public MMLScore parse(InputStream inputStream) throws MMLParseException {
        List<SectionContents> list = SectionContents.makeSectionContentsByInputStream(inputStream, this.encoding);
        if (list.isEmpty()) {
            throw new MMLParseException("no contents");
        }
        this.parseSection(list);
        if (this.trackList == null || this.trackList.size() == 0) {
            throw new MMLParseException("no track");
        }
        this.createTrack();
        try {
            this.setStartPosition();
        }
        catch (MMLExceptionList | MMLVerifyException exception) {
            throw new MMLParseException(exception.getLocalizedMessage());
        }
        return this.score;
    }

    public static String toMMLText(String string) {
        String string2 = string;
        string2 = CRLF_PATTERN.matcher(string2).replaceAll("\n");
        string2 = CR_PATTERN.matcher(string2).replaceAll("\n");
        string2 = END_LINE_PATTERN.matcher(string2 + "\n").replaceAll("\n");
        string2 = COMMENT_PATTERN.matcher(string2).replaceAll("");
        string2 = SPACE_PATTERN.matcher(string2).replaceAll("");
        return string2;
    }

    private void parseSection(List<SectionContents> list) throws MMLParseException {
        for (SectionContents sectionContents : list) {
            if (sectionContents.getName().equals("[3MLE EXTENSION]")) {
                this.trackList = this.parse3mleExtension(sectionContents.getContents());
                continue;
            }
            if (sectionContents.getName().matches("\\[Channel[0-9]*\\]")) {
                String string = sectionContents.getContents();
                this.mmlParts.add(MMLFile.toMMLText(string));
                continue;
            }
            if (!sectionContents.getName().equals("[Settings]")) continue;
            this.parseSettings(sectionContents.getContents());
        }
    }

    private void createTrack() {
        for (Extension3mleTrack extension3mleTrack : this.trackList) {
            int n = extension3mleTrack.getInstrument() - 1;
            if (MabiDLS.getInstance().getInstByProgram(n) == null) {
                n = 0;
            }
            String[] stringArray = new String[]{"", "", ""};
            for (int i = 0; i < extension3mleTrack.getTrackCount(); ++i) {
                stringArray[i] = this.mmlParts.pop();
            }
            InstType instType = MabiDLS.getInstance().getInstByProgram(n).getType();
            MMLTrack mMLTrack = instType == InstType.VOICE || instType == InstType.CHORUS ? new MMLTrack().setMML("", "", "", stringArray[0]) : new MMLTrack().setMML(stringArray[0], stringArray[1], stringArray[2], "");
            this.score.addTrack(mMLTrack);
            mMLTrack.setProgram(n);
            mMLTrack.setPanpot(extension3mleTrack.getPanpot());
            mMLTrack.setTrackName(extension3mleTrack.getTrackName());
        }
    }

    private void setStartPosition() throws MMLExceptionList, MMLVerifyException {
        if (this.score.getMarkerList().size() == 0) {
            return;
        }
        for (int i = 0; i < this.trackList.size(); ++i) {
            Extension3mleTrack extension3mleTrack = this.trackList.get(i);
            MMLTrack mMLTrack = this.score.getTrack(i);
            int n = extension3mleTrack.getStartMarker();
            if (n > 0) {
                Marker marker = this.score.getMarkerList().get(n - 1);
                int n2 = marker.getTickOffset();
                for (MMLEventList mMLEventList : mMLTrack.getMMLEventList()) {
                    MMLEvent.insertTick(mMLEventList.getMMLNoteEventList(), 0, n2);
                }
                mMLTrack.setStartDelta(n2);
                mMLTrack.setStartSongDelta(n2);
            }
            mMLTrack.generate();
        }
    }

    private void parseSettings(String string) {
        this.parser.parse(string);
    }

    private List<Extension3mleTrack> parse3mleExtension(String string) throws MMLParseException {
        StringBuilder stringBuilder = new StringBuilder();
        long l = 0L;
        for (String string2 : string.split("\n")) {
            if (string2.startsWith("d=")) {
                stringBuilder.append(string2.substring(2));
                continue;
            }
            if (!string2.startsWith("c=")) continue;
            l = Long.parseLong(string2.substring(2));
        }
        byte[] byArray = MMLFile.decode(stringBuilder.toString(), l);
        return this.parseData(byArray);
    }

    private static byte[] decode(String string, long l) throws MMLParseException {
        CRC32 cRC32 = new CRC32();
        cRC32.update(string.getBytes());
        if (l != cRC32.getValue()) {
            throw new MMLParseException("invalid c=" + l + " <> " + cRC32.getValue());
        }
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] byArray = decoder.decode(string);
        int n = ByteBuffer.wrap(byArray, 0, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
        byte[] byArray2 = new byte[n];
        try (BZip2CompressorInputStream bZip2CompressorInputStream = new BZip2CompressorInputStream((InputStream)new ByteArrayInputStream(byArray, 12, byArray.length - 12));){
            bZip2CompressorInputStream.read(byArray2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        for (int i = 0; i < n; ++i) {
            System.out.printf("%02x ", byArray2[i]);
        }
        System.out.println();
        return byArray2;
    }

    private List<Extension3mleTrack> parseData(byte[] byArray) {
        LinkedList<Extension3mleTrack> linkedList = new LinkedList<Extension3mleTrack>();
        linkedList.add(new Extension3mleTrack(-1, -1, -1, null, 0));
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        int n = 0;
        int n2 = 0;
        while ((n = byteArrayInputStream.read()) != -1) {
            if (n2 == 18 && n == 16) {
                this.parseHeader(byteArrayInputStream);
            } else if (n2 == 2 && n == 28) {
                this.parseTrack(linkedList, byteArrayInputStream);
            } else if (n2 == 9 && n > 0 && n < 32) {
                this.parseMarker(byteArrayInputStream);
            }
            n2 = n;
        }
        linkedList.removeFirst();
        return linkedList;
    }

    private void parseHeader(ByteArrayInputStream byteArrayInputStream) {
        byteArrayInputStream.skip(24L);
        this.resolution = this.readLEShortValue(byteArrayInputStream);
        System.out.println("resolution: " + this.resolution);
        byteArrayInputStream.skip(11L);
        int n = this.readLEIntValue(byteArrayInputStream);
        byteArrayInputStream.skip(n);
    }

    private void parseTrack(LinkedList<Extension3mleTrack> linkedList, ByteArrayInputStream byteArrayInputStream) {
        byteArrayInputStream.skip(3L);
        int n = byteArrayInputStream.read();
        byteArrayInputStream.skip(1L);
        int n2 = byteArrayInputStream.read();
        byteArrayInputStream.skip(5L);
        int n3 = byteArrayInputStream.read();
        byteArrayInputStream.skip(7L);
        int n4 = byteArrayInputStream.read();
        byteArrayInputStream.skip(3L);
        int n5 = byteArrayInputStream.read();
        byteArrayInputStream.skip(13L);
        String string = this.readString(byteArrayInputStream);
        System.out.println(n + " " + n4 + " " + string);
        Extension3mleTrack extension3mleTrack = linkedList.getLast();
        if (extension3mleTrack.getGroup() != n5 || extension3mleTrack.getInstrument() != n4 || extension3mleTrack.getPanpot() != n2 || extension3mleTrack.isLimit()) {
            linkedList.add(new Extension3mleTrack(n4, n5, n2, string, n3));
        } else {
            extension3mleTrack.addTrack();
        }
    }

    private int convertTick(int n) {
        if (this.resolution == 96) {
            return n;
        }
        return n * 96 / this.resolution;
    }

    private int readLEIntValue(InputStream inputStream) {
        byte[] byArray = new byte[4];
        try {
            inputStream.read(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    private short readLEShortValue(InputStream inputStream) {
        byte[] byArray = new byte[2];
        try {
            inputStream.read(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getShort();
    }

    private void parseMarker(ByteArrayInputStream byteArrayInputStream) {
        List<Marker> list = this.score.getMarkerList();
        byteArrayInputStream.skip(7L);
        int n = this.convertTick(this.readLEIntValue(byteArrayInputStream));
        byteArrayInputStream.skip(4L);
        String string = this.readString(byteArrayInputStream);
        System.out.println("Marker " + string + "=" + n);
        if (list != null) {
            list.add(new Marker(string, n));
        }
    }

    private String readString(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            while ((n = inputStream.read()) != 0) {
                byteArrayOutputStream.write(n);
            }
            return byteArrayOutputStream.toString(this.encoding);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "";
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string = "c=3902331007\nd=4wAAAJvYl0oBAAAAQlpoOTFBWSZTWReDTXYAAEH/i/7U0AQCAHgAQAAEAGwIEABAAECAAAoABKAAcivUCaZGmRiAyNqDEgnqRpkPTUZGh5S6QfOGHRg+AfSJE3ebNDxInstECT3owI1yYiuIY5IwTCLAQz1oZyAogJFOhVYmv39cWsLxsbh0MkELhClECHm5wCBjLYz8XckU4UJAXg012A==";
            string = "c=1269420526\nd=4wAAADQf0IYBAAAAQlpoOTFBWSZTWeWlqEkAAEL/i/7U0AQCAHgAQAAEADwIEEBAAECAAAoABKAAdBkp6IAAGgBtQZFB6IBoAANIlymxq3am6cmZmRF5lIvQDYpBCCcc\nd=lAGcFJEEGKGSQKoC366GV40QB5S5BBKDD35hGIZ0TE03VMVBYo53pYu61QliAs034u5IpwoSHLS1CSA=\n";
            string = "c=1888284627\nd=4wAAAHCCN2ABAAAAQlpoOTFBWSZTWSTXaLYAAEL/j/7U0AQCAHgAQAAEADwIEABAAEAAQIAACgAEoAByI9VNNGgAAyAbUEiSjyQaPSGEAbUsroXKl92irNLbSjcSRgw0\nd=TqwNzBHXtAGNYSMmYNRBKQSp7yxVJmLCafNmb3rP7+sa6ltkSJVfWpKgpI1vop3tOwFERjnfi7kinChIEmu0WwA=\n";
            MMLFile mMLFile = new MMLFile();
            List<Extension3mleTrack> list = mMLFile.parse3mleExtension(string);
            for (Extension3mleTrack extension3mleTrack : list) {
                System.out.println(extension3mleTrack);
            }
        }
        catch (MMLParseException mMLParseException) {
            mMLParseException.printStackTrace();
        }
    }
}

