/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools.optimizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jp.fourthline.mmlTools.core.MMLTokenizer;
import jp.fourthline.mmlTools.optimizer.MMLStringOptimizer;

public class OxLxOptimizer
implements MMLStringOptimizer.Optimizer {
    private final OptimizerMap map = this.createOptimizerMap();
    private final Map<String, StringBuilder> newBuilderMap = new HashMap<String, StringBuilder>();
    private final ArrayList<String> deleteKey = new ArrayList();
    private String section = "4";
    private int octave = 4;
    private int octD = 0;
    private int tokenStack = 0;

    protected OptimizerMap createOptimizerMap() {
        return new OptimizerMap();
    }

    public OxLxOptimizer() {
        this.map.clear();
        this.map.put("4", new StringBuilder());
    }

    @Override
    public String getMinString() {
        StringBuilder stringBuilder = null;
        int n = Integer.MAX_VALUE;
        for (StringBuilder stringBuilder2 : this.map.values()) {
            int n2 = stringBuilder2.length();
            if (n2 >= n) continue;
            stringBuilder = stringBuilder2;
            n = n2;
        }
        return stringBuilder == null ? "" : stringBuilder.toString();
    }

    private void printMap() {
        if (MMLStringOptimizer.getDebug()) {
            System.out.println(" --- ");
            this.map.forEach((string, stringBuilder) -> System.out.println(string + ": " + stringBuilder.toString()));
        }
    }

    private void addString(String string) {
        this.map.values().stream().forEach(stringBuilder -> stringBuilder.append(string));
    }

    private void addString(String string, int n) {
        this.map.values().stream().forEach(stringBuilder -> {
            int n2 = stringBuilder.length();
            stringBuilder.insert(n2 - n, string);
        });
    }

    protected static StringBuilder newStringBuilder(Map<String, StringBuilder> map, String string, String string2) {
        StringBuilder stringBuilder = map.get(string);
        if (stringBuilder != null) {
            stringBuilder.setLength(0);
            stringBuilder.append(string2);
        } else {
            stringBuilder = new StringBuilder(string2);
        }
        return stringBuilder;
    }

    protected StringBuilder newBuilder(StringBuilder stringBuilder, String string, String string2, int n) {
        int n2 = stringBuilder.length();
        stringBuilder.insert(n2 - n, "l" + string);
        stringBuilder.append(string2);
        return stringBuilder;
    }

    private void updateBuilder(String string, StringBuilder stringBuilder, String string2, String string3, String string4, int n) {
        stringBuilder.append(string3);
        if (!string.equals(string4)) {
            if (string4.equals(string + ".")) {
                stringBuilder.append(".");
            } else {
                stringBuilder.append(string4);
            }
            this.newBuilderMap.put(string4, this.newBuilder(OxLxOptimizer.newStringBuilder(this.newBuilderMap, string4, string2), string4, string3, n));
            if (string4.endsWith(".")) {
                String string5 = string4.substring(0, string4.length() - 1);
                this.newBuilderMap.put(string5, this.newBuilder(OxLxOptimizer.newStringBuilder(this.newBuilderMap, string5, string2), string5, string3 + ".", n));
            }
            this.extendPatternBuilder(this.newBuilderMap, string2, string3, string4, n);
        }
    }

    protected void extendPatternBuilder(Map<String, StringBuilder> map, String string, String string2, String string3, int n) {
    }

    private void addNoteText(String string, String string2, int n) {
        this.newBuilderMap.clear();
        String string3 = this.getMinString();
        this.map.forEach((string4, stringBuilder) -> this.updateBuilder((String)string4, (StringBuilder)stringBuilder, string3, string, string2, n));
        this.newBuilderMap.forEach(this.map::updateMapMinLength);
        FlexDotPattern.updateFlexDot(this.map, string, string2);
    }

    private void cleanMap() {
        int n = this.getMinString().length();
        this.deleteKey.clear();
        this.map.forEach((string, stringBuilder) -> {
            if (stringBuilder.length() > n + string.length() + 1) {
                this.deleteKey.add((String)string);
            }
        });
        this.deleteKey.stream().forEach(string -> this.map.remove(string));
    }

    public void resetOctave() {
        this.octave = 4;
        this.octD = 0;
    }

    private void doPattern(String string, String string2, int n) {
        this.insertOxPattern(n);
        this.insertLxPattern(string, string2, n);
    }

    private void insertLxPattern(String string, String object, int n) {
        if (((String)object).equals("")) {
            object = this.section;
        } else if (((String)object).equals(".")) {
            object = this.section + ".";
        }
        this.addNoteText(string, (String)object, n);
        this.fixPattern(this.map);
    }

    protected void fixPattern(OptimizerMap optimizerMap) {
    }

    public static String getOctaveString(int n, int n2) {
        int n3 = n - n2;
        if (Math.abs(n3) > 2) {
            return "o" + n2;
        }
        String string = "<<";
        if (n3 < 0) {
            string = ">>";
        }
        return string.substring(0, Math.abs(n3));
    }

    private void insertOxPattern(int n) {
        if (this.octD != 0) {
            int n2 = this.octave + this.octD;
            this.addString(OxLxOptimizer.getOctaveString(this.octave, n2), n);
            this.octave = n2;
            this.octD = 0;
        }
    }

    private boolean doToken(char c, String string) {
        if (c == 'o') {
            this.octD = Integer.parseInt(string) - this.octave;
        } else if (c == '>') {
            ++this.octD;
        } else if (c == '<') {
            --this.octD;
        } else if (c == 'l') {
            this.section = string;
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void nextToken(String string) {
        char c = Character.toLowerCase(string.charAt(0));
        String[] stringArray = MMLTokenizer.noteNames(string);
        if (MMLTokenizer.isNote(c)) {
            this.doPattern(stringArray[0], stringArray[1], this.tokenStack);
            this.tokenStack = 0;
            this.cleanMap();
        } else {
            boolean bl = this.doToken(c, stringArray[1]);
            if (!bl) {
                this.addString(string);
            }
            if (c == '&') {
                this.tokenStack += string.length();
            }
        }
        this.printMap();
    }

    public static class OptimizerMap
    extends HashMap<String, StringBuilder> {
        private static final long serialVersionUID = -7335134548044714344L;

        protected void updateMapMinLength(String string, StringBuilder stringBuilder) {
            StringBuilder stringBuilder2 = (StringBuilder)this.get(string);
            if (stringBuilder2 == null || stringBuilder.length() < stringBuilder2.length()) {
                this.put(string, stringBuilder);
            }
        }
    }

    private static final class FlexDotPattern {
        private static final FlexDotPattern[] flexList = new FlexDotPattern[]{new FlexDotPattern(64), new FlexDotPattern(32), new FlexDotPattern(16), new FlexDotPattern(8), new FlexDotPattern(4)};
        private final String lCur;
        private final String lNext;
        private final String lPrev;

        private FlexDotPattern(int n) {
            this.lCur = n / 2 + ".";
            this.lNext = Integer.toString(n);
            this.lPrev = Integer.toString(n / 4);
        }

        private void updatePattern(OptimizerMap optimizerMap, String string2, String string3) {
            Object object = string2;
            if (!string2.equalsIgnoreCase("r")) {
                object = "&" + string2;
            }
            HashMap<String, StringBuilder> hashMap = new HashMap<String, StringBuilder>();
            String string4 = string2 + this.lPrev + (String)object + this.lCur;
            for (String string5 : optimizerMap.keySet()) {
                String string6;
                if (!string5.equals(this.lNext) || !(string6 = ((StringBuilder)optimizerMap.get(string5)).toString()).endsWith(string4)) continue;
                String string7 = string6.substring(0, string6.length() - string4.length());
                String string8 = this.lPrev + ".";
                String string9 = string7 + string2 + (String)object + string8;
                String string10 = string7 + string2 + "l" + string8 + (String)object;
                String string11 = string7 + string2 + "l" + this.lPrev + (String)object + ".";
                hashMap.put(string5, OxLxOptimizer.newStringBuilder(hashMap, string5, string9));
                hashMap.put(string8, OxLxOptimizer.newStringBuilder(hashMap, string8, string10));
                hashMap.put(this.lPrev, OxLxOptimizer.newStringBuilder(hashMap, this.lPrev, string11));
            }
            hashMap.forEach((string, stringBuilder) -> optimizerMap.updateMapMinLength((String)string, (StringBuilder)stringBuilder));
        }

        private static void updateFlexDot(OptimizerMap optimizerMap, String string, String string2) {
            for (FlexDotPattern flexDotPattern : flexList) {
                if (!string2.equals(flexDotPattern.lCur)) continue;
                flexDotPattern.updatePattern(optimizerMap, string, string2);
                break;
            }
        }
    }
}

