/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools.optimizer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import jp.fourthline.mmlTools.core.MMLException;
import jp.fourthline.mmlTools.core.MMLTicks;
import jp.fourthline.mmlTools.core.MMLTokenizer;
import jp.fourthline.mmlTools.optimizer.CacheMap;
import jp.fourthline.mmlTools.optimizer.MMLStringOptimizer;
import jp.fourthline.mmlTools.optimizer.OxLxFixedOptimizer;
import jp.fourthline.mmlTools.optimizer.OxLxOptimizer;

public final class OxLxFixedAltOptimizer
extends OxLxFixedOptimizer {
    private final OxLxOptimizer.OptimizerMap altPatternMap = new OxLxOptimizer.OptimizerMap();
    private static final List<OxLxFixedOptimizer.FixPattern> pattern = List.of(new OxLxFixedOptimizer.FixPattern("64", "42", "."), new OxLxFixedOptimizer.FixPattern("32", "21", "."), new OxLxFixedOptimizer.FixPattern("24", "r12", "rr"), new OxLxFixedOptimizer.FixPattern("32", "r16", "rr"), new OxLxFixedOptimizer.FixPattern("48", "r24", "rr"), new OxLxFixedOptimizer.FixPattern("64", "r32", "rr"), new OxLxFixedOptimizer.FixPattern("24", "r12.", "rrr"), new OxLxFixedOptimizer.FixPattern("32", "r16.", "rrr"), new OxLxFixedOptimizer.FixPattern("48", "r24.", "rrr"), new OxLxFixedOptimizer.FixPattern("64", "r32.", "rrr"), new OxLxFixedOptimizer.FixPattern("4", "r3r9r16", "rr5r17"));

    public OxLxFixedAltOptimizer(boolean bl) {
        super(bl);
    }

    @Override
    protected void fixPattern(OxLxOptimizer.OptimizerMap optimizerMap) {
        this.altPatternMap.clear();
        optimizerMap.forEach((string, stringBuilder) -> this.tickAltPattern(this.altPatternMap, (String)string, (StringBuilder)stringBuilder));
        this.altPatternMap.forEach(optimizerMap::updateMapMinLength);
        optimizerMap.forEach((string, stringBuilder) -> pattern.stream().forEach(fixPattern -> fixPattern.patternApply((String)string, (StringBuilder)stringBuilder)));
        super.fixPattern(optimizerMap);
    }

    private void tickAltPattern(OxLxOptimizer.OptimizerMap optimizerMap, String string, StringBuilder stringBuilder) {
        int n;
        int n2 = n = stringBuilder.length();
        while (!MMLTokenizer.isNote(stringBuilder.charAt(--n2))) {
        }
        if (n2 == 0) {
            return;
        }
        String[] stringArray = MMLTokenizer.noteNames(stringBuilder.substring(n2, n));
        int n3 = n2 - 1;
        if (stringArray[0].equals("r")) {
            ++n3;
        } else if (stringBuilder.charAt(n3) != '&') {
            return;
        }
        int n4 = n3;
        while (n4 > 0 && !MMLTokenizer.isNote(stringBuilder.charAt(--n4))) {
        }
        String[] stringArray2 = MMLTokenizer.noteNames(stringBuilder.substring(n4, n3));
        if (!stringArray2[0].equals(stringArray[0])) {
            return;
        }
        if (stringArray2[0].equals("n") || stringArray[0].equals("n")) {
            return;
        }
        String string2 = !stringArray2[0].equals("r") ? "&" : "";
        try {
            List<AltPattern> list = AltPattern.getAltList(stringArray2[1], stringArray[1], string);
            if (list != null) {
                String string3 = stringBuilder.substring(0, n4);
                Optional<String> optional = list.stream().filter(altPattern -> altPattern.getLStr().isEmpty()).map(altPattern -> stringArray2[0] + (String)(altPattern.getNeedDot() ? "." + string2 : string2) + stringArray[0] + altPattern.getAltPattern()).min(Comparator.naturalOrder());
                if (optional.isPresent()) {
                    stringBuilder.delete(n4, n);
                    stringBuilder.append(optional.get());
                }
                for (AltPattern altPattern2 : list) {
                    String string4 = altPattern2.getAltPattern();
                    Optional<String> optional2 = altPattern2.getLStr();
                    if (optional2.isPresent()) {
                        optimizerMap.updateMapMinLength(optional2.get(), new StringBuilder(string3 + "l" + optional2.get() + stringArray2[0] + string4 + string2 + stringArray[0]));
                        continue;
                    }
                    if (!altPattern2.getNeedDot()) {
                        if (string4.endsWith(".")) {
                            String string5 = string4.substring(0, string4.length() - 1);
                            optimizerMap.updateMapMinLength(string5, new StringBuilder(string3 + stringArray2[0] + (String)(!string.equals(string5) ? "l" + string5 : "") + string2 + stringArray[0] + "."));
                        }
                        optimizerMap.updateMapMinLength(string4, new StringBuilder(string3 + stringArray2[0] + "l" + string4 + string2 + stringArray[0]));
                        continue;
                    }
                    optimizerMap.updateMapMinLength(string4, new StringBuilder(string3 + stringArray2[0] + "." + (String)(!string.equals(string4) ? "l" + string4 : "") + string2 + stringArray[0]));
                }
            }
        }
        catch (MMLException mMLException) {
            mMLException.printStackTrace();
        }
    }

    private static class AltPattern {
        private static final Map<String, List<AltPattern>> altCache = Collections.synchronizedMap(new CacheMap(128));
        private final String altPattern;
        private final boolean needDot;
        private final Optional<String> lStr;

        private AltPattern(String string, boolean bl) {
            this(string, bl, Optional.empty());
        }

        private AltPattern(String string, boolean bl, Optional<String> optional) {
            this.altPattern = string;
            this.needDot = bl;
            this.lStr = optional;
        }

        public String getAltPattern() {
            return this.altPattern;
        }

        public boolean getNeedDot() {
            return this.needDot;
        }

        public Optional<String> getLStr() {
            return this.lStr;
        }

        public static List<AltPattern> getAltList(String string, String string2, String string3) throws MMLException {
            List<List<String>> list;
            if (!MMLTokenizer.isLenOnly(string) || !MMLTokenizer.isLenOnly(string2)) {
                return null;
            }
            String string4 = string + "&" + string2 + ":" + string3;
            List<AltPattern> list2 = altCache.get(string4);
            if (list2 != null) {
                return list2;
            }
            int n = MMLTicks.getTick(string) + MMLTicks.getTick(string2);
            Optional<List<List<String>>> optional = MMLTicks.getAlt(n);
            ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
            if (optional.isPresent()) {
                list = optional.get();
                int n2 = 0;
                for (int i = 0; i < list.size(); ++i) {
                    String string5;
                    boolean bl = false;
                    for (n2 = 0; n2 < list.get(i).size(); ++n2) {
                        string5 = list.get(i).get(n2 == 0 ? 1 : 0);
                        if (string3.equals(list.get(i).get(n2))) {
                            arrayList.add((List<String>)((Object)new AltPattern(string5, false)));
                            bl = true;
                            continue;
                        }
                        if (!(string3 + ".").equals(list.get(i).get(n2)) || string5.endsWith(".")) continue;
                        arrayList.add((List<String>)((Object)new AltPattern(string5, true)));
                        bl = true;
                    }
                    if (bl) continue;
                    string5 = list.get(i).get(0);
                    String string6 = list.get(i).get(1);
                    if (!(string6 + ".").equals(string5)) continue;
                    arrayList.add((List<String>)((Object)new AltPattern(".", false, Optional.of(string6))));
                    arrayList.add((List<String>)((Object)new AltPattern(string6, false, Optional.of(string5))));
                }
            }
            list = arrayList.size() > 0 ? arrayList : null;
            altCache.put(string4, list);
            return list;
        }

        static {
            MMLStringOptimizer.addCacheList(altCache);
        }
    }

    public static class PatternOptimizer
    implements MMLStringOptimizer.Optimizer {
        private static final List<OxLxFixedOptimizer.FixPattern> pattern = List.of(new OxLxFixedOptimizer.FixPattern("*", "r1.r2", "r1r1"));
        private final StringBuilder sb = new StringBuilder();

        @Override
        public void nextToken(String string) {
            this.sb.append(string);
            pattern.stream().forEach(fixPattern -> fixPattern.patternApply("", this.sb));
        }

        @Override
        public String getMinString() {
            return this.sb.toString();
        }
    }
}

