/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools.core;

import java.util.List;
import java.util.Optional;
import jp.fourthline.mmlTools.core.MMLException;
import jp.fourthline.mmlTools.core.MMLTickTable;
import jp.fourthline.mmlTools.core.TuningBase;

public class MMLTicks {
    private static final MMLTickTable tickTable = MMLTickTable.getInstance();
    private static Integer minimum = null;
    private final String noteName;
    int tick;
    boolean needTie;

    public static int getTick(String string) throws MMLException {
        int n;
        String string2 = string;
        while (!tickTable.getTable().containsKey(string2) && (n = string2.length()) != 0) {
            char c = string2.charAt(n - 1);
            if (!Character.isDigit(c)) {
                string2 = string2.substring(0, n - 1);
                continue;
            }
            throw MMLException.createUndefinedTickException(string);
        }
        return tickTable.getTable().get(string2);
    }

    public static Optional<List<List<String>>> getAlt(int n) {
        MMLTickTable.MMLPattern mMLPattern = tickTable.getInvTable().get(n);
        return mMLPattern == null ? Optional.empty() : Optional.of(mMLPattern.alt);
    }

    public static int minimumTick() {
        if (minimum != null) {
            return minimum;
        }
        Integer n = null;
        for (Integer n2 : tickTable.getTable().values()) {
            if (n != null && n2 >= n) continue;
            n = n2;
        }
        minimum = n;
        return minimum;
    }

    public MMLTicks(String string, int n) {
        this(string, n, true);
    }

    public MMLTicks(String string, int n, boolean bl) {
        this.noteName = string;
        this.tick = n;
        this.needTie = bl;
    }

    protected String mmlNotePart(String string) {
        return this.mmlNotePart(List.of(string));
    }

    private String mmlNotePart(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        list.forEach(string -> {
            if (this.needTie) {
                stringBuilder.append('&');
            }
            stringBuilder.append(this.noteName).append((String)string);
        });
        return stringBuilder.toString();
    }

    protected String makeMMLText(StringBuilder stringBuilder, int n) throws MMLException {
        if (n > 0) {
            for (int i = 1; i <= 64; i *= 2) {
                int n2 = MMLTicks.getTick("" + i);
                if (tickTable.getInvTable().containsKey(n)) {
                    stringBuilder.append(this.mmlNotePart(MMLTicks.tickTable.getInvTable().get((int)n).primary));
                    n = 0;
                    break;
                }
                while (n >= n2) {
                    stringBuilder.append(this.mmlNotePart("" + i));
                    n -= n2;
                }
            }
            if (n > 0) {
                throw MMLException.createUndefinedTickException(n, this.tick);
            }
        }
        if (this.needTie) {
            if (stringBuilder.length() > 0) {
                return stringBuilder.substring(1);
            }
            return "";
        }
        return stringBuilder.toString();
    }

    public String toMMLText() throws MMLException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = MMLTicks.getTick("1.");
        int n3 = MMLTicks.getTick("1");
        for (n = this.tick; n > n3 * 2; n -= n2) {
            stringBuilder.append(this.mmlNotePart("1."));
        }
        return this.makeMMLText(stringBuilder, n);
    }

    public String toMMLTextByBase(TuningBase tuningBase) throws MMLException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = MMLTicks.minimumTick();
        int n3 = tuningBase.getTick();
        for (n = this.tick; n >= n3 + n2; n -= n3) {
            stringBuilder.append(this.mmlNotePart(tuningBase.getBase()));
        }
        return this.makeMMLText(stringBuilder, n);
    }
}

