/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jp.fourthline.mmlTools.BarLineType;
import jp.fourthline.mmlTools.MMLEvent;
import jp.fourthline.mmlTools.MMLEventList;
import jp.fourthline.mmlTools.MMLExceptionList;
import jp.fourthline.mmlTools.MMLNoteEvent;
import jp.fourthline.mmlTools.MMLScoreSerializer;
import jp.fourthline.mmlTools.MMLTempoConverter;
import jp.fourthline.mmlTools.MMLTempoEvent;
import jp.fourthline.mmlTools.MMLTrack;
import jp.fourthline.mmlTools.MMLVerifyException;
import jp.fourthline.mmlTools.Marker;
import jp.fourthline.mmlTools.Measure;
import jp.fourthline.mmlTools.TimeSignature;
import jp.fourthline.mmlTools.core.MMLException;
import jp.fourthline.mmlTools.core.MMLTicks;
import jp.fourthline.mmlTools.parser.MMSFile;

public final class MMLScore
implements Cloneable {
    private final LinkedList<MMLTrack> trackList = new LinkedList();
    private final List<MMLTempoEvent> globalTempoList = new ArrayList<MMLTempoEvent>();
    private final List<Marker> markerList = new ArrayList<Marker>();
    private final List<TimeSignature> timeSignatureList = new ArrayList<TimeSignature>();
    private final Map<Integer, BarLineType> barLineTypeMap = new LinkedHashMap<Integer, BarLineType>();
    public static final int MAX_TRACK = 24;
    private static boolean fix64Tempo = false;
    private String title = "";
    private String author = "";
    private int numTime = 4;
    private int baseTime = 4;
    private final Vector<MMLVerifyException> verifyErrStack = new Vector();
    private final Vector<MMLExceptionList.Entry> mmlErrStack = new Vector();
    public static final int MAX_USER_VIEW_MEASURE = 200;
    private int userViewMeasure;

    public static void setMMLFix64(boolean bl) {
        fix64Tempo = bl;
    }

    public synchronized int addTrack(MMLTrack mMLTrack) {
        int n;
        if (this.trackList.size() >= 24) {
            return -1;
        }
        if (this.trackList.size() > 0) {
            n = this.trackList.getFirst().getCommonStartOffset();
            mMLTrack.setStartOffset(n, this.globalTempoList);
        }
        this.trackList.add(mMLTrack);
        n = this.trackList.size() - 1;
        MMLTempoEvent.mergeTempoList(mMLTrack.getGlobalTempoList(), this.globalTempoList);
        mMLTrack.setGlobalTempoList(this.globalTempoList);
        return n;
    }

    public synchronized void removeTrack(int n) {
        this.trackList.remove(n);
    }

    public synchronized void moveTrack(int n, int n2) {
        MMLTrack mMLTrack = this.getTrack(n);
        this.removeTrack(n);
        this.trackList.add(n2, mMLTrack);
    }

    public int getTrackCount() {
        return this.trackList.size();
    }

    public synchronized List<MMLTrack> getTrackList() {
        return this.trackList;
    }

    public MMLTrack getTrack(int n) {
        if (n >= 0 && n < this.trackList.size()) {
            return this.trackList.get(n);
        }
        return null;
    }

    public void setTrack(int n, MMLTrack mMLTrack) {
        this.trackList.set(n, mMLTrack);
        int n2 = this.trackList.getFirst().getCommonStartOffset();
        mMLTrack.setStartOffset(n2, this.globalTempoList);
        MMLTempoEvent.mergeTempoList(mMLTrack.getGlobalTempoList(), this.globalTempoList);
        mMLTrack.setGlobalTempoList(this.globalTempoList);
    }

    public int getTempoOnTick(long l) {
        return MMLTempoEvent.searchOnTick(this.globalTempoList, l);
    }

    public List<MMLTempoEvent> getTempoEventList() {
        return this.globalTempoList;
    }

    public List<Marker> getMarkerList() {
        return this.markerList;
    }

    public List<TimeSignature> getTimeSignatureList() {
        return this.timeSignatureList;
    }

    public Map<Integer, BarLineType> getBarLineTypeMap() {
        return this.barLineTypeMap;
    }

    public void setBarLineType(int n, BarLineType barLineType) {
        if (barLineType == null || barLineType == BarLineType.NORMAL) {
            this.barLineTypeMap.remove(n);
        } else {
            this.barLineTypeMap.put(n, barLineType);
        }
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setAuthor(String string) {
        this.author = string;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setBaseTime(String string) {
        String[] stringArray = string.split("/");
        this.numTime = Integer.parseInt(stringArray[0]);
        this.baseTime = Integer.parseInt(stringArray[1]);
        TimeSignature.recalcTimeSignatureList(this);
    }

    public String getBaseTime() {
        return this.numTime + "/" + this.baseTime;
    }

    public void setBaseOnly(int n) {
        this.baseTime = n;
        TimeSignature.recalcTimeSignatureList(this);
    }

    public int getTimeCountOnly() {
        return this.numTime;
    }

    public void setTimeCountOnly(int n) {
        this.numTime = n;
        TimeSignature.recalcTimeSignatureList(this);
    }

    public int getMeasureTick() {
        return this.getTimeCountOnly() * this.getBeatTick();
    }

    public int getBeatTick() {
        try {
            return MMLTicks.getTick(String.valueOf(this.baseTime));
        }
        catch (MMLException mMLException) {
            throw new AssertionError();
        }
    }

    public void setUserViewMeasure(int n) {
        if (n > 200) {
            n = 200;
        }
        this.userViewMeasure = n;
    }

    public int getUserViewMeasure() {
        return this.userViewMeasure;
    }

    public void addTicks(int n, boolean bl) {
        Measure measure = new Measure(this, n);
        int n2 = measure.getBeatTick();
        if (bl) {
            n2 *= measure.getNumTime();
        }
        for (MMLTrack mMLTrack : this.getTrackList()) {
            for (MMLEventList mMLEventList : mMLTrack.getMMLEventList()) {
                MMLEvent.insertTick(mMLEventList.getMMLNoteEventList(), n, n2);
            }
        }
        MMLEvent.insertTick(this.globalTempoList, n, n2);
        MMLEvent.insertTick(this.markerList, n, n2);
        if (bl) {
            int n3 = Measure.tickToMeasure(this, n);
            TimeSignature.addMeasure(this, n3);
            MMLEvent.updateMapByAddMeasure(this.barLineTypeMap, n3);
        }
    }

    public void removeTicks(int n, boolean bl) {
        Measure measure = new Measure(this, n);
        int n2 = measure.getBeatTick();
        if (bl) {
            n2 *= measure.getNumTime();
        }
        for (MMLTrack mMLTrack : this.getTrackList()) {
            for (MMLEventList mMLEventList : mMLTrack.getMMLEventList()) {
                MMLEvent.removeTick(mMLEventList.getMMLNoteEventList(), n, n2);
            }
        }
        MMLEvent.removeTick(this.globalTempoList, n, n2);
        MMLEvent.removeTick(this.markerList, n, n2);
        if (bl) {
            int n3 = Measure.tickToMeasure(this, n);
            TimeSignature.removeMeasure(this, n3);
            MMLEvent.updateMapByRemoveMeasure(this.barLineTypeMap, n3);
        }
    }

    public int getTotalTickLength() {
        long l = 0L;
        for (MMLTrack mMLTrack : this.trackList) {
            long l2 = mMLTrack.getMaxTickLength();
            if (l >= l2) continue;
            l = l2;
        }
        return (int)l;
    }

    private int maxTickMMLEvent(int n, List<? extends MMLEvent> list) {
        int n2 = n;
        if (list != null) {
            for (MMLEvent mMLEvent : list) {
                int n3 = mMLEvent.getTickOffset();
                if (n2 >= n3) continue;
                n2 = n3;
            }
        }
        return n2;
    }

    public int getTotalTickLengthWithAll() {
        return this.maxTickMMLEvent(this.maxTickMMLEvent(this.getTotalTickLength(), this.globalTempoList), this.markerList);
    }

    public long getTotalTime() {
        int n = this.getTotalTickLength();
        return Math.round(MMLTempoConverter.getTimeOnTickOffset(this.globalTempoList, n));
    }

    public byte[] getObjectState() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        new MMLScoreSerializer(this).writeToOutputStream(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void putObjectState(byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            new MMLScoreSerializer(this).parse(byteArrayInputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public List<MMLNoteEvent[]> getNoteListOnTickOffset(long l) {
        ArrayList<MMLNoteEvent[]> arrayList = new ArrayList<MMLNoteEvent[]>();
        for (MMLTrack mMLTrack : this.getTrackList()) {
            int n = 0;
            MMLNoteEvent[] mMLNoteEventArray = new MMLNoteEvent[4];
            for (MMLEventList mMLEventList : mMLTrack.getMMLEventList()) {
                mMLNoteEventArray[n++] = mMLEventList.searchOnTickOffset(l);
            }
            arrayList.add(mMLNoteEventArray);
        }
        return arrayList;
    }

    public MMLScore toGeneratedScore(boolean bl) {
        try {
            MMLScore mMLScore = new MMLScore();
            mMLScore.putObjectState(this.getObjectState());
            mMLScore.generateAll();
            if (bl || Arrays.equals(this.getObjectState(), mMLScore.getObjectState())) {
                return mMLScore;
            }
        }
        catch (MMLExceptionList | MMLVerifyException exception) {
            // empty catch block
        }
        return this;
    }

    public MMLScore generateAll() throws MMLExceptionList, MMLVerifyException {
        this.verifyErrStack.clear();
        this.mmlErrStack.clear();
        this.trackList.parallelStream().forEach(mMLTrack -> {
            try {
                mMLTrack.setFix64(fix64Tempo);
                mMLTrack.generate();
            }
            catch (MMLVerifyException mMLVerifyException) {
                this.verifyErrStack.add(mMLVerifyException);
            }
            catch (MMLExceptionList mMLExceptionList) {
                this.mmlErrStack.addAll(mMLExceptionList.getErr());
            }
        });
        if (!this.verifyErrStack.isEmpty()) {
            throw this.verifyErrStack.firstElement();
        }
        if (!this.mmlErrStack.isEmpty()) {
            throw new MMLExceptionList(this.mmlErrStack);
        }
        return this;
    }

    public boolean setStartOffsetAll(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n % 6 != 0) {
            throw new IllegalArgumentException();
        }
        if (this.trackList.isEmpty()) {
            return false;
        }
        MMLTrack mMLTrack2 = this.trackList.getFirst();
        int n2 = mMLTrack2.getCommonStartOffset();
        for (MMLTrack object : this.trackList) {
            if (object.getCommonStartOffset() != n2) {
                throw new IllegalStateException();
            }
            if (n + object.getStartDelta() >= 0 && n + object.getStartSongDelta() >= 0) continue;
            return false;
        }
        int n3 = n - n2;
        for (MMLTempoEvent mMLTempoEvent2 : this.globalTempoList) {
            if (mMLTempoEvent2.getTickOffset() + n3 >= 0) continue;
            return false;
        }
        for (Marker marker2 : this.markerList) {
            if (marker2.getTickOffset() + n3 >= 0) continue;
            return false;
        }
        this.trackList.forEach(mMLTrack -> mMLTrack.setStartOffset(n, this.globalTempoList));
        this.globalTempoList.forEach(mMLTempoEvent -> mMLTempoEvent.setTickOffset(mMLTempoEvent.getTickOffset() + n3));
        this.markerList.forEach(marker -> marker.setTickOffset(marker.getTickOffset() + n3));
        return true;
    }

    public String getBarTextTick(int n) {
        return new Measure(this, n).toString();
    }

    public void addTimeSignature(TimeSignature timeSignature2) {
        int n = timeSignature2.getMeasureOffset();
        this.timeSignatureList.removeIf(timeSignature -> timeSignature.getMeasureOffset() == n);
        this.timeSignatureList.add(timeSignature2);
        TimeSignature.recalcTimeSignatureList(this);
    }

    public void removeTimeSignature(TimeSignature timeSignature) {
        this.timeSignatureList.remove(timeSignature);
        TimeSignature.recalcTimeSignatureList(this);
    }

    public List<MMLVerifyException> getVerifyErr() {
        return this.verifyErrStack;
    }

    public List<MMLExceptionList.Entry> getMMLErr() {
        return this.mmlErrStack;
    }

    public MMLScore clone() {
        byte[] byArray = this.getObjectState();
        MMLScore mMLScore = new MMLScore();
        mMLScore.putObjectState(byArray);
        return mMLScore;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(" --- parse sample.mms ---");
            MMSFile mMSFile = new MMSFile();
            MMLScore mMLScore = mMSFile.parse(new FileInputStream("sample.mms"));
            new MMLScoreSerializer(mMLScore).writeToOutputStream(System.out);
            System.out.println(" --- parse sample-version1.mmi ---");
            mMLScore = new MMLScore();
            new MMLScoreSerializer(mMLScore).parse(new FileInputStream("sample-version1.mmi"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

