/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.fourthline.mmlTools.core.IllegalTickOffsetException;
import jp.fourthline.mmlTools.core.MMLException;

public abstract class MMLEvent
implements Serializable {
    private static final long serialVersionUID = -6142467143073639266L;
    public static final int MAX_TICK = 3840000;
    private int tickOffset;

    protected MMLEvent(int n) {
        if (n <= -3840000 || n >= 3840000) {
            throw new IllegalTickOffsetException(n);
        }
        this.tickOffset = n;
    }

    public void setTickOffset(int n) {
        if (n < 0 || n >= 3840000) {
            throw new IllegalTickOffsetException(n);
        }
        this.tickOffset = n;
    }

    public int getTickOffset() {
        return this.tickOffset;
    }

    public abstract String toString();

    public abstract String toMMLString() throws MMLException;

    public static void insertTick(List<? extends MMLEvent> list, int n, int n2) {
        for (MMLEvent mMLEvent : list) {
            int n3 = mMLEvent.getTickOffset();
            if (n3 < n) continue;
            mMLEvent.setTickOffset(n3 + n2);
        }
    }

    public static void removeTick(List<? extends MMLEvent> list, int n, int n2) {
        ArrayList<MMLEvent> arrayList = new ArrayList<MMLEvent>();
        for (MMLEvent mMLEvent : list) {
            int n3 = mMLEvent.getTickOffset();
            if (n3 < n) continue;
            if (n3 < n + n2) {
                arrayList.add(mMLEvent);
                continue;
            }
            mMLEvent.setTickOffset(n3 - n2);
        }
        for (MMLEvent mMLEvent : arrayList) {
            list.remove(mMLEvent);
        }
    }

    public static <T> void updateMapByAddMeasure(Map<Integer, T> map, int n) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        map.forEach((n2, object) -> {
            if (n2 >= n) {
                linkedHashMap.put(n2 + 1, object);
            } else {
                linkedHashMap.put(n2, object);
            }
        });
        map.clear();
        map.putAll(linkedHashMap);
    }

    public static <T> void updateMapByRemoveMeasure(Map<Integer, T> map, int n) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        map.forEach((n2, object) -> {
            if (n2 > n) {
                linkedHashMap.put(n2 - 1, object);
            } else if (n2 < n) {
                linkedHashMap.put(n2, object);
            }
        });
        map.clear();
        map.putAll(linkedHashMap);
    }

    public boolean equals(Object object) {
        if (object instanceof MMLEvent) {
            MMLEvent mMLEvent = (MMLEvent)object;
            return this.tickOffset == mMLEvent.tickOffset;
        }
        return false;
    }
}

