/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui.mml;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mmlTools.parser.IMMLFileParser;
import jp.fourthline.mmlTools.parser.MidiFile;

public final class ParsePropertiesDialog
extends JPanel {
    private static final long serialVersionUID = -6502564484362288491L;
    private final Frame parentFrame;
    private final List<JCheckBox> checkBoxList = new ArrayList<JCheckBox>();
    private final boolean noOption;
    private final IMMLFileParser parser;
    private final Map<String, JComboBox<?>> comboMap = new HashMap();

    public ParsePropertiesDialog(Frame frame, IMMLFileParser iMMLFileParser) {
        this.parentFrame = frame;
        this.parser = iMMLFileParser;
        boolean bl = this.noOption = iMMLFileParser.getParseProperties() == null && iMMLFileParser.getParseAttributes() == null;
        if (!this.noOption) {
            this.initializePanel();
        }
    }

    private void initializePanel() {
        Object object;
        Object object2;
        String[] stringArray;
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 0));
        this.setLayout(new BorderLayout());
        if (this.parser.getParseProperties() != null) {
            for (String object3 : this.parser.getParseProperties().keySet()) {
                stringArray = new JCheckBox(AppResource.appText(object3), (boolean)this.parser.getParseProperties().get(object3));
                jPanel.add((Component)stringArray);
                this.checkBoxList.add((JCheckBox)stringArray);
            }
        }
        if (this.parser.getParseAttributes() != null) {
            for (String string2 : this.parser.getParseAttributes().keySet()) {
                stringArray = (String[])this.parser.getParseAttributes().get(string2).stream().map(string -> AppResource.appText(string)).toArray(String[]::new);
                object2 = new JComboBox<String>(stringArray);
                ((Component)object2).setFocusable(false);
                JLabel jLabel = new JLabel(AppResource.appText(string2));
                object = new JPanel(new FlowLayout(0));
                ((Container)object).add(jLabel);
                ((Container)object).add((Component)object2);
                jPanel.add((Component)object);
                jPanel.add(new JPanel());
                this.comboMap.put(string2, (JComboBox<?>)object2);
            }
        }
        if (this.parser.getTrackSelectMap() != null) {
            Serializable serializable;
            Vector vector = new Vector();
            vector.add("");
            vector.add("#");
            vector.add("Track");
            Vector vector2 = new Vector();
            int n = 0;
            for (Integer n2 : this.parser.getTrackSelectMap().keySet()) {
                object = this.parser.getTrackSelectMap().get(n2);
                serializable = new Vector<Object>();
                ((Vector)serializable).add(((IMMLFileParser.TrackSelect)object).isEnabled());
                ((Vector)serializable).add(++n);
                ((Vector)serializable).add(((IMMLFileParser.TrackSelect)object).toString());
                vector2.add(serializable);
            }
            object2 = new JTable(new DefaultTableModel(vector2, vector){
                private static final long serialVersionUID = -530181826789266153L;

                @Override
                public Class<?> getColumnClass(int n) {
                    return this.getValueAt(0, n).getClass();
                }

                @Override
                public void setValueAt(Object object, int n, int n2) {
                    super.setValueAt(object, n, n2);
                    if (n2 == 0) {
                        Object object2 = ParsePropertiesDialog.this.parser.getTrackSelectMap().keySet().toArray()[n];
                        ParsePropertiesDialog.this.parser.getTrackSelectMap().get(object2).setEnable(object.equals(Boolean.TRUE));
                    }
                }
            });
            ((JTable)object2).getColumnModel().getColumn(0).setPreferredWidth(0);
            ((JTable)object2).getColumnModel().getColumn(1).setPreferredWidth(0);
            ((JTable)object2).getColumnModel().getColumn(2).setPreferredWidth(200);
            ((JTable)object2).setRowSelectionAllowed(false);
            ((JTable)object2).getTableHeader().setReorderingAllowed(false);
            ((Component)object2).setFocusable(false);
            JScrollPane jScrollPane = new JScrollPane((Component)object2);
            jScrollPane.setPreferredSize(new Dimension(300, 240));
            object = new JPanel(new BorderLayout());
            ((Container)object).add((Component)jScrollPane, "Center");
            serializable = new JPanel();
            JButton jButton = new JButton(AppResource.appText("menu.selectAll"));
            jButton.addActionListener(arg_0 -> this.lambda$initializePanel$2((JTable)object2, arg_0));
            ((Container)serializable).add(jButton);
            JButton jButton2 = new JButton(AppResource.appText("menu.selectClear"));
            jButton2.addActionListener(arg_0 -> this.lambda$initializePanel$3((JTable)object2, arg_0));
            ((Container)serializable).add(jButton2);
            ((Container)object).add((Component)serializable, "North");
            this.add((Component)object, "East");
        }
        this.add((Component)jPanel, "Center");
    }

    private void apply() {
        String[] stringArray = this.parser.getParseProperties().keySet().toArray(new String[0]);
        for (int i = 0; i < this.parser.getParseProperties().size(); ++i) {
            this.parser.getParseProperties().put(stringArray[i], this.checkBoxList.get(i).isSelected());
        }
        this.comboMap.entrySet().forEach(entry -> {
            String string = (String)entry.getKey();
            String[] stringArray = (String[])this.parser.getParseAttributes().get(string).toArray(String[]::new);
            String string2 = stringArray[((JComboBox)entry.getValue()).getSelectedIndex()];
            this.parser.setParseAttribute(string, string2);
        });
    }

    public boolean showDialog() {
        int n;
        if (this.noOption) {
            return true;
        }
        Object object = this.parser.getName();
        if (!((String)object).isEmpty()) {
            object = (String)object + " ";
        }
        if ((n = JOptionPane.showConfirmDialog(this.parentFrame, this, (String)(object = (String)object + AppResource.appText("parse.dialogTitle")), 2, -1)) == 0) {
            this.apply();
            return true;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        new ParsePropertiesDialog(null, new MidiFile()).showDialog();
    }

    private /* synthetic */ void lambda$initializePanel$3(JTable jTable, ActionEvent actionEvent) {
        int n = jTable.getModel().getRowCount();
        for (int i = 0; i < n; ++i) {
            jTable.getModel().setValueAt(false, i, 0);
        }
        this.repaint();
    }

    private /* synthetic */ void lambda$initializePanel$2(JTable jTable, ActionEvent actionEvent) {
        int n = jTable.getModel().getRowCount();
        for (int i = 0; i < n; ++i) {
            jTable.getModel().setValueAt(true, i, 0);
        }
        this.repaint();
    }
}

