/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui.mml;

import java.awt.Dimension;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.IFileState;
import jp.fourthline.mmlTools.MMLScore;
import jp.fourthline.mmlTools.TimeSignature;

public final class MMLScorePropertyPanel
extends JPanel {
    private static final long serialVersionUID = -3976816581383137814L;
    private final JTextField titleField = new JTextField();
    private final JTextField authorField = new JTextField();
    private final JComboBox<String> timeCount = new JComboBox<String>(TimeSignature.TIME_COUNT_LIST);
    private final JComboBox<String> timeBase = new JComboBox<String>(TimeSignature.TIME_BASE_LIST);
    private final Dimension prefSize = new Dimension(300, 170);

    public MMLScorePropertyPanel() {
        this.initializePanel();
    }

    private void initializePanel() {
        this.setBounds(100, 100, 300, 170);
        this.setLayout(null);
        JLabel jLabel = new JLabel(AppResource.appText("score_property.name"));
        jLabel.setBounds(12, 40, 90, 14);
        this.add(jLabel);
        JLabel jLabel2 = new JLabel(AppResource.appText("score_property.author"));
        jLabel2.setBounds(12, 73, 90, 14);
        this.add(jLabel2);
        JLabel jLabel3 = new JLabel(AppResource.appText("score_property.measure"));
        jLabel3.setBounds(12, 105, 90, 14);
        this.add(jLabel3);
        JLabel jLabel4 = new JLabel("/");
        jLabel4.setBounds(198, 105, 15, 14);
        this.add(jLabel4);
        this.titleField.setBounds(125, 37, 152, 19);
        this.add(this.titleField);
        this.titleField.setColumns(10);
        this.authorField.setColumns(10);
        this.authorField.setBounds(125, 70, 152, 19);
        this.timeCount.setBounds(125, 102, 63, 19);
        this.timeBase.setBounds(214, 102, 63, 19);
        this.timeBase.setMaximumRowCount(4);
        this.add(this.timeCount);
        this.add(this.timeBase);
        this.add(this.authorField);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    private void initialComboBox(String string) {
        this.timeCount.setSelectedItem("4");
        this.timeBase.setSelectedItem("4");
        try {
            String[] stringArray = string.split("/");
            this.timeCount.setSelectedItem(stringArray[0]);
            this.timeBase.setSelectedItem(stringArray[1]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void showDialog(JFrame jFrame, MMLScore mMLScore, IFileState iFileState) {
        this.titleField.setText(mMLScore.getTitle());
        this.authorField.setText(mMLScore.getAuthor());
        this.initialComboBox(mMLScore.getBaseTime());
        int n = JOptionPane.showConfirmDialog(jFrame, this, AppResource.appText("score_property"), 2, -1);
        if (n == 0) {
            mMLScore.setTitle(this.titleField.getText());
            mMLScore.setAuthor(this.authorField.getText());
            String string = this.timeCount.getSelectedItem() + "/" + this.timeBase.getSelectedItem();
            mMLScore.setBaseTime(string);
            iFileState.saveState();
        }
    }
}

