/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.ui.IMMLManager;
import jp.fourthline.mabiicco.ui.UIUtils;
import jp.fourthline.mabiicco.ui.editor.NumberSpinner;
import jp.fourthline.mabiicco.ui.table.TrackListTable;
import jp.fourthline.mmlTools.MMLNoteEvent;
import jp.fourthline.mmlTools.MMLTrack;

public final class MultiTracksVelocityChangeEditor
extends JPanel {
    private static final long serialVersionUID = 426213296832443395L;
    private TrackListTable table;
    private final JDialog dialog;
    private JButton applyButton;
    private JSpinner spinner;
    private final IMMLManager mmlManager;
    private final Frame parentFrame;
    private final Dimension prefSize = new Dimension(460, 300);

    public MultiTracksVelocityChangeEditor(Frame frame, IMMLManager iMMLManager) {
        this.dialog = new JDialog(frame, AppResource.appText("edit.tracks.velocity"), true);
        this.mmlManager = iMMLManager;
        this.parentFrame = frame;
        this.initializePanel();
    }

    public void showDialog() {
        this.dialog.getContentPane().add(this);
        this.dialog.pack();
        this.dialog.setResizable(false);
        this.dialog.setLocationRelativeTo(this.parentFrame);
        this.dialog.setVisible(true);
    }

    private void initializePanel() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.add(new JLabel(AppResource.appText("note.properties.incdecr")));
        this.spinner = NumberSpinner.createSpinner(0, -15, 15, 1);
        this.spinner.setFocusable(false);
        this.spinner.addChangeListener(changeEvent -> this.updateButtonStatus());
        jPanel3.add(this.spinner);
        this.applyButton = new JButton(AppResource.appText("edit.apply"));
        this.applyButton.setMargin(new Insets(5, 10, 5, 10));
        jPanel.add(this.applyButton);
        this.applyButton.addActionListener(actionEvent -> {
            this.apply();
            this.dialog.setVisible(false);
        });
        JButton jButton = new JButton(AppResource.appText("mml.output.closeButton"));
        jButton.setMargin(new Insets(5, 10, 5, 10));
        jPanel.add(jButton);
        jButton.setFocusable(false);
        jButton.addActionListener(actionEvent -> this.dialog.setVisible(false));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBounds(12, 10, 422, 169);
        jPanel2.add((Component)jScrollPane, "Center");
        JPanel jPanel4 = new JPanel();
        JButton jButton2 = new JButton(AppResource.appText("menu.selectAll"));
        jButton2.addActionListener(actionEvent -> {
            this.table.setInitialCheck(this.table.getCheckList().length);
            this.updateButtonStatus();
            this.repaint();
        });
        jPanel4.add(jButton2);
        jPanel2.add((Component)jPanel4, "North");
        this.table = new TrackListTable(this.mmlManager.getMMLScore().getTrackList(), true);
        this.table.addPropertyChangeListener(propertyChangeEvent -> this.updateButtonStatus());
        jScrollPane.setViewportView(this.table);
        this.table.setDefaultEditor(Object.class, null);
        UIUtils.dialogCloseAction(this.dialog);
        this.add((Component)jPanel, "South");
        this.add((Component)jPanel3, "North");
        this.add((Component)jPanel2, "Center");
    }

    @Override
    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    private void updateButtonStatus() {
        boolean bl;
        boolean bl2 = bl = this.table.getCheckCount() != 0;
        if (this.spinner.getValue().equals(0)) {
            bl = false;
        }
        this.applyButton.setEnabled(bl);
    }

    public void apply() {
        int n = (Integer)this.spinner.getValue();
        List<MMLTrack> list = this.mmlManager.getMMLScore().getTrackList();
        boolean[] blArray = this.table.getCheckList();
        for (int i = 0; i < list.size(); ++i) {
            if (!blArray[i]) continue;
            list.get(i).getMMLEventList().forEach(mMLEventList -> {
                for (MMLNoteEvent mMLNoteEvent : mMLEventList.getMMLNoteEventList()) {
                    mMLNoteEvent.setVelocity(mMLNoteEvent.getVelocity() + n);
                }
            });
        }
        this.mmlManager.updateActivePart(true);
    }
}

