/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.ui.MMLTrackView;
import jp.fourthline.mabiicco.ui.mml.MMLOutputPanel;
import jp.fourthline.mmlTools.MMLEventList;
import jp.fourthline.mmlTools.MMLExceptionList;
import jp.fourthline.mmlTools.MMLScore;
import jp.fourthline.mmlTools.MMLTrack;
import jp.fourthline.mmlTools.MMLVerifyException;
import jp.fourthline.mmlTools.Measure;
import jp.fourthline.mmlTools.logger.LogMessage;

public final class MMLErrView {
    private final Vector<Vector<Object>> dataList;
    private final Vector<String> column = new Vector();

    public MMLErrView(MMLScore mMLScore) {
        this.dataList = this.makeList(mMLScore);
        this.column.add(AppResource.appText("#"));
        this.column.add(AppResource.appText("track"));
        this.column.add(AppResource.appText("part"));
        this.column.add(AppResource.appText("mml.err.position"));
        this.column.add(AppResource.appText("mml.err.type"));
        this.column.add(AppResource.appText("mml.err.value"));
    }

    Vector<Vector<Object>> getDataList() {
        return this.dataList;
    }

    private Vector<Vector<Object>> makeList(MMLScore mMLScore) {
        List<MMLVerifyException> list = mMLScore.getVerifyErr();
        List<MMLExceptionList.Entry> list2 = mMLScore.getMMLErr();
        return mMLScore.getTrackList().stream().flatMap(mMLTrack -> new DataAttr(mMLScore, (MMLTrack)mMLTrack).makeDataRelationTrack(Type.ERROR, list).makeDataRelationPart(Type.ERROR, list2).makeDataRelationPart(Type.WARN, mMLTrack.getLogger().getEntryList()).toStream()).collect(Collectors.toCollection(Vector::new));
    }

    public void showMMLErrList(Frame frame) {
        JTable jTable = new JTable(new DefaultTableModel(this.dataList, this.column){
            private static final long serialVersionUID = 5392169416298424707L;

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        });
        jTable.getColumnModel().getColumn(0).setMinWidth(20);
        jTable.getColumnModel().getColumn(0).setMaxWidth(20);
        jTable.getColumnModel().getColumn(1).setMinWidth(100);
        jTable.getColumnModel().getColumn(1).setMaxWidth(100);
        jTable.getColumnModel().getColumn(2).setMinWidth(80);
        jTable.getColumnModel().getColumn(2).setMaxWidth(80);
        jTable.getColumnModel().getColumn(3).setMinWidth(80);
        jTable.getColumnModel().getColumn(3).setMaxWidth(80);
        jTable.getColumnModel().getColumn(4).setMinWidth(60);
        jTable.getColumnModel().getColumn(4).setMaxWidth(60);
        jTable.getColumnModel().getColumn(5).setCellRenderer(new TooltipRenderer());
        jTable.getTableHeader().setResizingAllowed(false);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.getTableHeader().setRequestFocusEnabled(false);
        jTable.setFocusable(false);
        jTable.setRowSelectionAllowed(false);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setPreferredSize(new Dimension(640, 400));
        String string = AppResource.appText("menu.mmlErrList");
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(new JLabel("" + this.dataList.size()));
        JButton jButton = new JButton(AppResource.getImageIcon("/img/list.png"));
        jButton.setToolTipText(AppResource.appText("mml.output.tableListInfoButton"));
        jButton.setMargin(new Insets(5, 10, 5, 10));
        jButton.setFocusable(false);
        jPanel.add(jButton);
        jButton.addActionListener(actionEvent -> this.tableListOutput(frame));
        jButton.setEnabled(this.dataList.size() > 0);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.add((Component)jPanel, "South");
        JOptionPane.showMessageDialog(frame, jPanel2, string, -1);
    }

    private void vectorToString(StringBuilder stringBuilder, Vector<?> vector) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append('\t');
            }
            stringBuilder.append(vector.get(i).toString().replaceAll("[\\n\\r]", ""));
        }
        stringBuilder.append('\n');
    }

    private void tableListOutput(Frame frame) {
        StringBuilder stringBuilder = new StringBuilder();
        this.vectorToString(stringBuilder, this.column);
        for (Vector<Object> vector : this.dataList) {
            this.vectorToString(stringBuilder, vector);
        }
        MMLOutputPanel.copyToClipboard(frame, stringBuilder.toString(), AppResource.appText("mml.output.table_list_done"));
    }

    private static class TooltipRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 6013889934698748903L;

        private TooltipRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object != null) {
                String string = object.toString();
                this.setToolTipText(string);
            } else {
                this.setToolTipText(null);
            }
            return this;
        }
    }

    private static final class DataAttr {
        private final MMLScore score;
        private final MMLTrack track;
        private Stream<Vector<Object>> stream = Stream.empty();

        private DataAttr(MMLScore mMLScore, MMLTrack mMLTrack) {
            this.score = mMLScore;
            this.track = mMLTrack;
        }

        private Stream<Vector<Object>> toStream() {
            return this.stream;
        }

        private int getTrackIndex() {
            return this.score.getTrackList().indexOf(this.track);
        }

        private DataAttr makeDataRelationTrack(Type type, List<? extends LogMessage.TrackMessage> list) {
            this.stream = Stream.concat(this.stream, list.stream().filter(trackMessage -> this.track == trackMessage.getTrack()).map(trackMessage -> this.makeData(type, (LogMessage)trackMessage)));
            return this;
        }

        private DataAttr makeDataRelationPart(Type type, List<? extends LogMessage.PartMessage> list2) {
            Map<MMLEventList, List<LogMessage.PartMessage>> map = list2.stream().collect(Collectors.groupingBy(LogMessage.PartMessage::getRelationPart));
            this.stream = Stream.concat(this.stream, this.track.getMMLEventList().stream().map(map::get).filter(list -> list != null).flatMap(Collection::stream).map(partMessage -> this.makeData(type, (LogMessage.PartMessage)partMessage)));
            return this;
        }

        private Vector<Object> makeData(Type type, LogMessage.PartMessage partMessage) {
            return this.makeData(type, this.track.getMMLEventList().indexOf(partMessage.getRelationPart()), partMessage.getTickOffset(), partMessage.getLocalizedMessage());
        }

        private Vector<Object> makeData(Type type, LogMessage logMessage) {
            return this.makeData(type, -1, -1, logMessage.getLocalizedMessage());
        }

        private Vector<Object> makeData(Type type, int n, int n2, String string) {
            Vector<Object> vector = new Vector<Object>();
            vector.add(this.getTrackIndex() + 1);
            vector.add(this.track.getTrackName());
            if (n >= 0) {
                vector.add(MMLTrackView.MMLPART_NAME[n]);
            } else {
                vector.add("-");
            }
            if (n2 >= 0) {
                vector.add(new Measure(this.score, n2).toString());
            } else {
                vector.add("-");
            }
            vector.add(type.text);
            vector.add(string);
            return vector;
        }
    }

    private static enum Type {
        ERROR,
        WARN;

        private final String text = AppResource.appText("mml.err.type." + this.name().toLowerCase());
    }
}

