/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JPanel;
import jp.fourthline.mabiicco.MabiIccoProperties;
import jp.fourthline.mabiicco.midi.IPlayNote;
import jp.fourthline.mabiicco.midi.InstClass;
import jp.fourthline.mabiicco.midi.MMLMidiTrack;
import jp.fourthline.mabiicco.midi.MabiDLS;
import jp.fourthline.mabiicco.midi.SoundEnv;
import jp.fourthline.mabiicco.ui.IMMLManager;
import jp.fourthline.mabiicco.ui.PianoRollView;
import jp.fourthline.mabiicco.ui.UIUtils;
import jp.fourthline.mabiicco.ui.color.ColorSet;
import jp.fourthline.mmlTools.MMLNoteEvent;

public final class KeyboardView
extends JPanel
implements IPlayNote {
    private static final long serialVersionUID = -3850112420986284800L;
    public static final int HEADER_WIDTH = 60;
    private int[] playNote = null;
    private int playTrackIndex = 0;
    private int playPartIndex = 0;
    private final int DEFAULT_VELOCITY = 11;
    private final IMMLManager mmlManager;
    private final PianoRollView pianoRollView;
    private InstClass relativeInst = null;
    private final int octDelta;
    private final Color borderColor = new Color(0.3f, 0.3f, 0.3f);
    private final Color octaveBorderColor = new Color(0.3f, 0.3f, 0.6f);
    private final ColorSet whiteKeyColor = ColorSet.create(Color.WHITE, Color.LIGHT_GRAY);
    private final ColorSet blackKeyColor = ColorSet.create(Color.BLACK);
    private final ColorSet backgroundColor = ColorSet.create(Color.LIGHT_GRAY, Color.DARK_GRAY);

    public KeyboardView(IMMLManager iMMLManager, final PianoRollView pianoRollView) {
        this.mmlManager = iMMLManager;
        this.pianoRollView = pianoRollView;
        this.updateHeight();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = pianoRollView.convertY2Note(mouseEvent.getY());
                KeyboardView.this.playNote(n, 11);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                KeyboardView.this.offNote();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                int n = pianoRollView.convertY2Note(mouseEvent.getY());
                KeyboardView.this.playNote(n, 11);
            }
        });
        this.octDelta = ((SoundEnv)MabiIccoProperties.getInstance().soundEnv.get()).pianoRollOctDelta();
    }

    public void updateHeight() {
        this.setPreferredSize(new Dimension(60, this.pianoRollView.getTotalHeight()));
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int n = this.pianoRollView.getTotalHeight();
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        UIUtils.setRenderingHint(graphics2D);
        graphics2D.setColor(this.whiteKeyColor.get());
        graphics2D.fillRect(0, 0, 60, n);
        for (int i = 0; i <= 9; ++i) {
            this.paintOctPianoLine(graphics2D, i, (char)(57 - i - 1 + this.octDelta));
        }
        this.paintOverlapRange(graphics2D);
        this.paintPlayNote(graphics2D);
        if (n < this.getHeight()) {
            graphics2D.setColor(this.backgroundColor.get());
            graphics2D.fillRect(0, n + 1, 60, this.getHeight() - n);
        }
        graphics2D.dispose();
    }

    private boolean isWhiteKey(int n) {
        switch (n % 12) {
            case -1: 
            case 0: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    private void paintPlayNote(Graphics2D graphics2D) {
        int[] nArray = new int[]{-2, -2, -1, -2, 1, -3, -2, -2, -1, 0, 0, 2};
        if (this.playNote == null) {
            return;
        }
        for (int n : this.playNote) {
            int n2 = 15;
            if (this.isWhiteKey(n)) {
                n2 += 20;
            }
            int n3 = this.pianoRollView.convertNote2Y(n) + nArray[(n + 12) % 12];
            graphics2D.setColor(Color.RED);
            graphics2D.fillOval(n2, n3, 4, 4);
        }
    }

    private void paintOctPianoLine(Graphics2D graphics2D, int n, char c) {
        int[] nArray;
        int n2 = this.pianoRollView.getNoteHeight();
        int n3 = this.pianoRollView.getNoteHeight() * 12;
        int n4 = this.pianoRollView.getTotalHeight();
        graphics2D.setColor(this.borderColor);
        int n5 = n3 * n;
        for (int i = 0; i < 7; ++i) {
            double d = n3 * i / 7;
            double d2 = n3 * (i + 1) / 7;
            if ((double)n5 + d > (double)n4) break;
            graphics2D.drawRect(0, (int)((double)n5 + d), 40, (int)(d2 - d));
        }
        for (int n6 : nArray = new int[]{1, 2, 3, 5, 6}) {
            int n7 = n3 * n6 / 7 - n2 / 2 - 1;
            if ((n7 += n5) + n2 > n4) break;
            graphics2D.setColor(this.blackKeyColor.get());
            graphics2D.fillRect(0, n7, 20, n2);
            graphics2D.setColor(this.borderColor);
            graphics2D.drawRect(0, n7, 20, n2);
        }
        graphics2D.setColor(this.octaveBorderColor);
        graphics2D.drawLine(40, n5, 60, n5);
        int n8 = n5 + n3;
        if (n8 < n4) {
            char[] cArray = new char[]{'o', c};
            graphics2D.setFont(new Font("Arial", 0, 12));
            graphics2D.drawChars(cArray, 0, cArray.length, 42, n8);
            graphics2D.drawLine(40, n8, 60, n8);
        }
    }

    private void paintOverlapRange(Graphics2D graphics2D) {
        if (this.relativeInst == null) {
            return;
        }
        if (((Boolean)MabiIccoProperties.getInstance().enableEdit.get()).booleanValue() && ((Boolean)MabiIccoProperties.getInstance().instAttr.get()).booleanValue()) {
            int n = this.pianoRollView.getTotalHeight();
            int n2 = this.pianoRollView.getNoteHeight();
            int n3 = 59;
            MMLMidiTrack.OverlapMode overlapMode = (MMLMidiTrack.OverlapMode)MabiIccoProperties.getInstance().overlapMode.get();
            for (int i = 0; i < n; i += n2) {
                int n4 = this.pianoRollView.convertY2Note(i);
                if (!this.relativeInst.isValid(n4)) {
                    graphics2D.setColor(Color.RED);
                } else if (overlapMode.isOverlap(this.relativeInst, n4)) {
                    graphics2D.setColor(Color.BLUE);
                } else {
                    graphics2D.setColor(Color.GREEN);
                }
                graphics2D.drawLine(n3, i, n3, i + n2);
            }
        }
    }

    @Override
    public void playNote(int n, int n2) {
        if (n < -1) {
            this.offNote();
            return;
        }
        this.playNote(new int[]{n}, n2);
    }

    @Override
    public void playNote(int[] nArray, int n) {
        if (nArray == null) {
            this.offNote();
            return;
        }
        MMLNoteEvent[] mMLNoteEventArray = new MMLNoteEvent[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            mMLNoteEventArray[i] = new MMLNoteEvent(nArray[i], 0, 0, n);
        }
        MabiDLS mabiDLS = MabiDLS.getInstance();
        if (!mabiDLS.getSequencer().isRunning()) {
            int n2 = this.mmlManager.getActiveTrackIndex();
            int n3 = this.mmlManager.getActiveMMLPartIndex();
            if (this.playTrackIndex != n2 || this.playPartIndex != n3) {
                this.offNote();
            }
            mabiDLS.loadRequiredInstruments(this.mmlManager.getMMLScore());
            mabiDLS.playNotes(this.mmlManager.getMMLScore(), mMLNoteEventArray, n2, n3);
            this.playNote = nArray;
            this.playTrackIndex = n2;
            this.playPartIndex = n3;
        }
        this.repaint();
    }

    @Override
    public void offNote() {
        this.playNote = null;
        MabiDLS.getInstance().playNote(this.mmlManager.getMMLScore(), Integer.MIN_VALUE, 0, this.playTrackIndex, this.playPartIndex);
        this.repaint();
    }

    public void setRelativeInst(InstClass instClass) {
        this.relativeInst = instClass;
    }
}

