/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.midi;

import com.sun.media.sound.DLSInstrument;
import com.sun.media.sound.DLSRegion;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.function.IntBinaryOperator;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Patch;
import javax.sound.midi.Soundbank;
import jp.fourthline.mabiicco.MabiIccoProperties;
import jp.fourthline.mabiicco.midi.InstType;
import jp.fourthline.mabiicco.midi.MabiDLS;
import jp.fourthline.mabiicco.midi.SoundEnv;
import jp.fourthline.mmlTools.core.ResourceLoader;
import jp.fourthline.mmlTools.parser.MMLEventParser;

public final class InstClass {
    private final String name;
    private final int program;
    private final int lowerNote;
    private final int upperNote;
    private final InstType type;
    private final Instrument inst;
    private final Options options;
    private static ResourceBundle instResource = null;
    public static boolean debug;
    public static int DRUM;

    private static int logicalProgramNum(Instrument instrument) {
        if (instrument == null) {
            throw new IllegalArgumentException("inst is null");
        }
        int n = instrument.getPatch().getProgram();
        if (instrument.toString().startsWith("Drumkit: ")) {
            n += DRUM;
        }
        int n2 = instrument.getPatch().getBank();
        return InstClass.logicalProgramNum(n2, n);
    }

    public static int logicalProgramNum(int n, int n2) {
        return ((n &= 0x7F) << 9) + n2;
    }

    public static int toMidiProram(int n) {
        return n & 0x7F;
    }

    public static int toMidiBank(int n) {
        return n >> 9 & 0x7F;
    }

    private static int parseRegionNote(IntBinaryOperator intBinaryOperator, String string, int n) {
        if (string.startsWith("!")) {
            return MMLEventParser.firstNoteNumber(string.substring(1));
        }
        return intBinaryOperator.applyAsInt(n, MMLEventParser.firstNoteNumber(string));
    }

    public InstClass(String string, int n, int n2, Instrument instrument) {
        String[] stringArray;
        if (string != null) {
            stringArray = string.split(",");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = n + "," + n2;
        }
        String[] stringArray3 = stringArray;
        this.inst = instrument;
        this.type = stringArray3.length > 1 ? InstType.getInstType(stringArray3[1]) : InstType.NORMAL;
        KeyRegion keyRegion = this.regionFromTo(instrument);
        if (stringArray3.length > 2) {
            keyRegion.from = InstClass.parseRegionNote(Math::max, stringArray3[2], keyRegion.from);
        }
        if (stringArray3.length > 3) {
            keyRegion.to = InstClass.parseRegionNote(Math::min, stringArray3[3], keyRegion.to);
        }
        this.lowerNote = keyRegion.from;
        this.upperNote = keyRegion.to;
        this.program = instrument != null ? InstClass.logicalProgramNum(instrument) : n2;
        this.name = string != null && n2 >= 0 ? InstClass.toProgramText(this.program) + ": " + stringArray3[0] : stringArray3[0];
        this.options = new Options(instrument);
    }

    private KeyRegion regionFromTo(Instrument instrument) {
        if (instrument == null) {
            return new KeyRegion();
        }
        int n = Integer.MIN_VALUE;
        int n2 = Integer.MAX_VALUE;
        if (instrument instanceof DLSInstrument) {
            DLSInstrument dLSInstrument = (DLSInstrument)instrument;
            for (DLSRegion dLSRegion : dLSInstrument.getRegions()) {
                n2 = Math.min(n2, dLSRegion.getKeyfrom());
                n = Math.max(n, dLSRegion.getKeyto());
            }
        }
        if (n == Integer.MIN_VALUE || n2 == Integer.MAX_VALUE) {
            return new KeyRegion();
        }
        return new KeyRegion(n2 -= 12, n -= 12);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (object instanceof InstClass) {
            InstClass instClass = (InstClass)object;
            return this.program == instClass.program;
        }
        return false;
    }

    public int getProgram() {
        return this.program;
    }

    public boolean checkPitchRange(int n) {
        return n >= this.lowerNote && n <= this.upperNote;
    }

    public int getLowerNote() {
        return this.lowerNote;
    }

    public int getUpperNote() {
        return this.upperNote;
    }

    public InstType getType() {
        return this.type;
    }

    public Instrument getInstrument() {
        return this.inst;
    }

    public String getMidiName() {
        return "Instrument: " + this.inst.getName() + " bank #" + InstClass.toMidiBank(this.program) + " preset #" + InstClass.toMidiProram(this.program);
    }

    public double getAttention(int n) {
        if (this.options.attentionList == null) {
            return 0.0;
        }
        try {
            n = this.type.convertNote2ValidIndex(n);
            return this.options.attentionList[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return 0.0;
        }
    }

    public boolean isOverlap(int n) {
        if (this.options.overlapList == null) {
            return false;
        }
        try {
            n = this.type.convertNote2ValidIndex(n);
            return this.options.overlapList[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
    }

    public boolean isValid4DLS(int n) {
        if (this.options.overlapList == null) {
            return false;
        }
        try {
            n = this.type.convertNote2ValidIndex(n);
            return this.options.validList[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
    }

    public boolean isValid(int n) {
        if (this.options.overlapList == null) {
            return false;
        }
        return this.type.isValidNote(n, this.options);
    }

    public int convertNoteMML2Midi(int n) {
        return this.type.convertNoteMML2Midi(n, this.options);
    }

    public static boolean[] getEnablePartByProgram(int n) {
        InstClass instClass = MabiDLS.getInstance().getInstByProgram(n);
        if (instClass != null) {
            return instClass.getType().getEnablePart();
        }
        return InstType.NONE.getEnablePart();
    }

    public static int getFirstPartNumberOnProgram(int n) {
        boolean[] blArray = InstClass.getEnablePartByProgram(n);
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            return i;
        }
        throw new AssertionError((Object)"Invalid Inst Part Number.");
    }

    private static String toProgramText(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n & 0x1FF);
        int n2 = InstClass.toMidiBank(n);
        if (n2 != 0) {
            stringBuilder.append('.').append(n2);
        }
        return stringBuilder.toString();
    }

    private static String instName(Instrument instrument, ResourceBundle resourceBundle) {
        if (resourceBundle == null) {
            return instrument.getName().trim();
        }
        try {
            int n = InstClass.logicalProgramNum(instrument);
            String string = resourceBundle.getString(InstClass.toProgramText(n));
            if (string.equals("-")) {
                return instrument.getName().trim();
            }
            return string;
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public String toStringOptionsInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.program);
        for (boolean bl : this.options.validList) {
            stringBuilder.append(',').append(bl);
        }
        for (double d : this.options.attentionList) {
            stringBuilder.append(',').append(d);
        }
        for (boolean bl : this.options.overlapList) {
            stringBuilder.append(',').append(bl);
        }
        return stringBuilder.toString();
    }

    public void dlsInfoWriteToOutputStream(OutputStream outputStream) {
        PrintStream printStream = new PrintStream(outputStream);
        Object object = InstClass.instName(this.inst, instResource);
        String string = this.inst.getName();
        int n = this.inst.getPatch().getBank();
        int n2 = this.inst.getPatch().getProgram();
        printStream.printf("%d,%d=%s \"%s\"\n", n & 0x7F, n2, string, object);
        if (object != null) {
            object = n2 + ": " + (String)object;
        }
        if (debug && this.inst instanceof DLSInstrument) {
            DLSInstrument dLSInstrument = (DLSInstrument)this.inst;
            for (DLSRegion dLSRegion : dLSInstrument.getRegions()) {
                double d = (double)dLSRegion.getSample().getSampleoptions().getAttenuation() / 655360.0;
                printStream.print(" >> " + dLSRegion.getSample().getName() + " ");
                printStream.print(d + " ");
                printStream.print(Math.pow(10.0, d / 20.0) + " ");
                printStream.print(dLSRegion.getKeyfrom() + " ");
                printStream.print(dLSRegion.getKeyto() + " ");
                printStream.print(dLSRegion.getVelfrom() + " ");
                printStream.print(dLSRegion.getVelto() + " ");
                printStream.print(dLSRegion.getChannel() + " ");
                printStream.print(dLSRegion.getExclusiveClass() + " ");
                printStream.print(dLSRegion.getFusoptions() + " ");
                printStream.print(dLSRegion.getPhasegroup() + " ");
                printStream.print(dLSRegion.getOptions() + "* ");
                printStream.print(dLSRegion.getSampleoptions().getUnitynote() + " ");
                printStream.print(dLSRegion.getSampleoptions().getAttenuation() + " ");
                printStream.print(dLSRegion.getSampleoptions().getOptions() + " ");
                printStream.print(dLSRegion.getSampleoptions().getFinetune() + " ");
                printStream.println();
            }
        }
    }

    static List<InstClass> defaultSoundBank(boolean bl) throws MidiUnavailableException {
        Soundbank soundbank = MidiSystem.getSynthesizer().getDefaultSoundbank();
        return InstClass.loadSoundBank(soundbank, bl);
    }

    static List<InstClass> loadDLS(InputStream inputStream, String string) throws IOException {
        try {
            Soundbank soundbank = MidiSystem.getSoundbank(inputStream);
            return InstClass.loadSoundBank(soundbank, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException("loadDLS: " + string);
        }
    }

    private static Instrument instFix(Instrument instrument) {
        if (instrument instanceof DLSInstrument) {
            DLSInstrument dLSInstrument = (DLSInstrument)instrument;
            if (instrument.getSoundbank().getName().equals("Fury Sound Pack - Mabinogi Mobile Instrument Set")) {
                dLSInstrument.setPatch(new Patch(2, instrument.getPatch().getProgram()));
            }
            dLSInstrument.setPatch(new Patch(instrument.getPatch().getBank() + 15488, instrument.getPatch().getProgram()));
        }
        return instrument;
    }

    private static List<InstClass> loadSoundBank(Soundbank soundbank, boolean bl) {
        ArrayList<InstClass> arrayList = new ArrayList<InstClass>();
        for (Instrument instrument : soundbank.getInstruments()) {
            if (instrument.getPatch().getBank() != 0) continue;
            if (debug) {
                System.out.print(instrument.toString() + "\t");
            }
            instrument = InstClass.instFix(instrument);
            String string = instrument.getName();
            String string2 = bl ? InstClass.instName(instrument, instResource) : string.trim();
            int n = instrument.getPatch().getBank() & 0x7F;
            int n2 = instrument.getPatch().getProgram();
            int n3 = InstClass.logicalProgramNum(instrument);
            if (debug) {
                System.out.printf("%d,%d(%d)=%s \"%s\"\n", n, n2, n3, string, string2);
            }
            if (string2 == null && !debug) continue;
            InstClass instClass = new InstClass(string2, n, n2, instrument);
            arrayList.add(instClass);
        }
        return arrayList;
    }

    static {
        try {
            String string = ((SoundEnv)MabiIccoProperties.getInstance().soundEnv.get()).getInstrumentName();
            if (string != null) {
                instResource = ResourceBundle.getBundle(string, new ResourceLoader());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        debug = false;
        DRUM = 256;
    }

    private static final class KeyRegion {
        int from;
        int to;

        KeyRegion() {
            this.from = 0;
            this.to = 1024;
        }

        KeyRegion(int n, int n2) {
            this.from = n;
            this.to = n2;
        }
    }

    static final class Options {
        public static final int OPTION_NUM = 256;
        private final double[] attentionList;
        private final boolean[] overlapList;
        final boolean[] validList;
        final int[] validNoteList;

        Options(boolean[] blArray) {
            this.validList = blArray;
            this.validNoteList = Options.makeValidNoteList(blArray);
            this.attentionList = new double[blArray.length];
            this.overlapList = new boolean[blArray.length];
        }

        private Options(Instrument instrument) {
            if (instrument instanceof DLSInstrument) {
                int n;
                DLSInstrument dLSInstrument = (DLSInstrument)instrument;
                this.attentionList = new double[256];
                this.overlapList = new boolean[256];
                this.validList = new boolean[256];
                for (n = 0; n < 256; ++n) {
                    this.attentionList[n] = 0.0;
                    this.overlapList[n] = false;
                    this.validList[n] = false;
                }
                n = 256;
                int n2 = 0;
                block1: for (DLSRegion dLSRegion : dLSInstrument.getRegions()) {
                    n = Math.min(n, dLSRegion.getKeyfrom());
                    n2 = Math.max(n2, dLSRegion.getKeyto());
                    double d = (double)dLSRegion.getSampleoptions().getAttenuation() / 655360.0;
                    boolean bl = dLSRegion.getOptions() == 1;
                    for (int i = dLSRegion.getKeyfrom(); i <= dLSRegion.getKeyto(); ++i) {
                        if (ExcludeRegion.isExlcude(dLSRegion)) {
                            System.out.println("\u3000\u3000region skip > " + dLSRegion.getSample().getName() + "[" + dLSRegion.getKeyfrom() + "-" + dLSRegion.getKeyto() + "]");
                            dLSRegion.setKeyfrom(0);
                            dLSRegion.setKeyto(0);
                            continue block1;
                        }
                        this.validList[i] = true;
                        this.attentionList[i] = d;
                        this.overlapList[i] = bl;
                    }
                }
                this.validNoteList = Options.makeValidNoteList(this.validList);
            } else {
                this.attentionList = null;
                this.overlapList = null;
                this.validList = null;
                this.validNoteList = null;
            }
        }

        private static int[] makeValidNoteList(boolean[] blArray) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < blArray.length; ++i) {
                if (!blArray[i]) continue;
                arrayList.add(i);
            }
            return arrayList.stream().mapToInt(Integer::intValue).toArray();
        }
    }

    private static final class ExcludeRegion {
        private static final ExcludeRegion[] values = new ExcludeRegion[]{new ExcludeRegion("Pipe_c5", 60, 71, 60), new ExcludeRegion("Pipe_c5", 48, 59, 48), new ExcludeRegion("Pipe_c5", 72, 83, 60)};
        private final String name;
        private final int from;
        private final int to;
        private final int unitynote;

        private static boolean isExlcude(DLSRegion dLSRegion) {
            for (ExcludeRegion excludeRegion : values) {
                if (!excludeRegion.name.equals(dLSRegion.getSample().getName()) || excludeRegion.from != dLSRegion.getKeyfrom() || excludeRegion.to != dLSRegion.getKeyto() || excludeRegion.unitynote != dLSRegion.getSampleoptions().getUnitynote()) continue;
                return true;
            }
            return false;
        }

        private ExcludeRegion(String string, int n, int n2, int n3) {
            this.name = string;
            this.from = n;
            this.to = n2;
            this.unitynote = n3;
        }
    }
}

