/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import jp.fourthline.mmlTools.MMLEventList;
import jp.fourthline.mmlTools.MMLExceptionList;
import jp.fourthline.mmlTools.MMLNoteEvent;
import jp.fourthline.mmlTools.MMLScore;
import jp.fourthline.mmlTools.MMLTrack;
import jp.fourthline.mmlTools.MMLVerifyException;
import jp.fourthline.mmlTools.core.MMLTokenizer;
import jp.fourthline.mmlTools.parser.AbstractMMLParser;
import jp.fourthline.mmlTools.parser.MMLFile;
import jp.fourthline.mmlTools.parser.MMLParseException;

public final class TxtFile
extends AbstractMMLParser {
    private static final int MAX_SIZE = 0x100000;
    public static final String PARSE_CONVERT_VOL = "parse.txt.convertVol";
    public static final String PARSE_CONVERT_OCT = "parse.txt.convertOct";
    public static final String PARSE_L_CONTINUE = "parse.txt.Lcontinue";

    public TxtFile() {
        this.parseProperties = new LinkedHashMap();
        this.parseProperties.put(PARSE_CONVERT_VOL, true);
        this.parseProperties.put(PARSE_CONVERT_OCT, true);
        this.parseProperties.put(PARSE_L_CONTINUE, true);
    }

    @Override
    public MMLScore parse(InputStream inputStream) throws MMLParseException {
        try {
            int n = inputStream.available();
            if (n > 0x100000) {
                throw new MMLParseException("too large file:" + n);
            }
            String string2 = MMLFile.toMMLText(new String(inputStream.readAllBytes()));
            StringBuilder stringBuilder = new StringBuilder();
            string2.lines().forEach(string -> stringBuilder.append(MMLFile.toMMLText(string)));
            AAConverter aAConverter = new AAConverter(this.parseProperties.getOrDefault(PARSE_CONVERT_VOL, true), this.parseProperties.getOrDefault(PARSE_L_CONTINUE, true));
            new MMLTokenizer(stringBuilder.toString()).forEachRemaining(aAConverter::nextToken);
            String[] stringArray = aAConverter.getText().split(",");
            MMLScore mMLScore = new MMLScore();
            MMLTrack mMLTrack = null;
            int n2 = 1;
            for (int i = 0; i < stringArray.length; i += 3) {
                mMLTrack = new MMLTrack();
                mMLTrack.setTrackName("Track" + n2++);
                String string3 = stringArray[i];
                String string4 = i + 1 < stringArray.length ? stringArray[i + 1] : "";
                String string5 = i + 2 < stringArray.length ? stringArray[i + 2] : "";
                mMLTrack.setMML(string3, string4, string5, "");
                mMLScore.addTrack(mMLTrack);
            }
            return this.convertOctave(mMLScore);
        }
        catch (IOException | MMLExceptionList | MMLVerifyException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private MMLScore convertOctave(MMLScore mMLScore) throws MMLExceptionList, MMLVerifyException {
        if (!this.parseProperties.getOrDefault(PARSE_CONVERT_OCT, true).booleanValue()) {
            System.out.println("skip convert oct");
            return mMLScore;
        }
        System.out.println("exec convert oct");
        for (MMLTrack mMLTrack : mMLScore.getTrackList()) {
            for (MMLEventList mMLEventList : mMLTrack.getMMLEventList()) {
                for (MMLNoteEvent mMLNoteEvent : mMLEventList.getMMLNoteEventList()) {
                    mMLNoteEvent.setNote(mMLNoteEvent.getNote() - 12);
                }
            }
        }
        mMLScore.generateAll();
        return mMLScore;
    }

    private static class AAConverter {
        private final boolean convertVol;
        private final boolean lContinue;
        private final StringBuilder sb = new StringBuilder();
        private String lStr = "4";
        private int octave = 5;
        private boolean start = false;

        private AAConverter(boolean bl, boolean bl2) {
            this.convertVol = bl;
            this.lContinue = bl2;
        }

        public void nextToken(String string) {
            String[] stringArray;
            if (!this.start) {
                this.sb.append("o" + this.octave);
                this.start = true;
            }
            if ((stringArray = MMLTokenizer.noteNames(string))[0].equalsIgnoreCase("v")) {
                int n = Integer.parseInt(stringArray[1]);
                if (this.convertVol) {
                    n /= 8;
                }
                this.sb.append("v" + n);
            } else if (stringArray[0].equalsIgnoreCase("l")) {
                this.lStr = stringArray[1];
                this.sb.append(string);
            } else if (stringArray[0].equalsIgnoreCase(",")) {
                this.sb.append(string);
                if (this.lContinue) {
                    this.sb.append("l" + this.lStr);
                }
                this.sb.append("o" + this.octave);
            } else {
                this.sb.append(string);
            }
        }

        public String getText() {
            return this.sb.toString();
        }
    }
}

