/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools.parser;

import java.util.Iterator;
import jp.fourthline.mmlTools.MMLEvent;
import jp.fourthline.mmlTools.MMLNoteEvent;
import jp.fourthline.mmlTools.MMLTempoEvent;
import jp.fourthline.mmlTools.core.MMLException;
import jp.fourthline.mmlTools.core.MMLTokenizer;
import jp.fourthline.mmlTools.core.MelodyParser;
import jp.fourthline.mmlTools.core.ParserWarn3ML;
import jp.fourthline.mmlTools.core.TuningBase;

public final class MMLEventParser
implements Iterator<MMLEvent> {
    private final MMLTokenizer tokenizer;
    private final MelodyParser parser;
    private MMLEvent nextItem = null;
    private boolean hasTie = false;
    private int totalTick = 0;
    private final int startOffset;
    private MMLNoteEvent prevNoteEvent = null;
    private int volume = 8;
    private int tuningFirstTick = 0;
    private int tuningTiedCount = 0;

    public MMLEventParser(String string) {
        this(string, 0);
    }

    public MMLEventParser(String string, int n) {
        this.totalTick = n;
        this.startOffset = n;
        this.tokenizer = new MMLTokenizer(string);
        this.parser = new MelodyParser(string);
    }

    public static int firstNoteNumber(String string) {
        MMLEventParser mMLEventParser = new MMLEventParser(string);
        while (mMLEventParser.hasNext()) {
            MMLEvent mMLEvent = mMLEventParser.next();
            if (!(mMLEvent instanceof MMLNoteEvent)) continue;
            return ((MMLNoteEvent)mMLEvent).getNote();
        }
        return -1;
    }

    private MMLEvent parseNextEvent() {
        while (this.tokenizer.hasNext()) {
            String string = this.tokenizer.next();
            char c = string.charAt(0);
            if (c == '&') {
                this.hasTie = true;
                continue;
            }
            if (c == 'v' || c == 'V') {
                try {
                    int n = Integer.parseInt(string.substring(1));
                    if (n < 0 || n > 15) continue;
                    this.volume = n;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println(numberFormatException.getMessage());
                }
            }
            if (c == 't' || c == 'T') {
                try {
                    int n = Integer.parseInt(string.substring(1));
                    this.nextItem = new MMLTempoEvent(n, this.totalTick, this.totalTick == this.startOffset);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    continue;
                }
                return this.nextItem;
            }
            try {
                int n = this.parser.noteGT(string);
                if (!MMLTokenizer.isNote(c)) continue;
                if (this.hasTie && this.prevNoteEvent != null && this.prevNoteEvent.getNote() == this.parser.getNoteNumber()) {
                    int n2 = this.prevNoteEvent.getTick();
                    if (this.tuningTiedCount == 0) {
                        this.tuningFirstTick = n2;
                    }
                    if (this.tuningFirstTick == n && TuningBase.getInstance(n) != null && ++this.tuningTiedCount >= 3) {
                        this.prevNoteEvent.setTuningNote(TuningBase.getInstance(n));
                    }
                    this.prevNoteEvent.setTick(n2 + n);
                    this.prevNoteEvent.getIndexOfMMLString()[1] = this.tokenizer.getIndex()[1];
                } else if (this.parser.getNoteNumber() >= -1) {
                    this.nextItem = this.prevNoteEvent;
                    this.prevNoteEvent = new MMLNoteEvent(this.parser.getNoteNumber(), n, this.totalTick, this.volume);
                    this.prevNoteEvent.setIndexOfMMLString(this.tokenizer.getIndex());
                }
                if (!this.hasTie) {
                    this.tuningTiedCount = 0;
                }
                this.hasTie = false;
                this.totalTick += n;
                if (this.nextItem == null) continue;
                return this.nextItem;
            }
            catch (MMLException | ParserWarn3ML exception) {
                System.err.println(exception.getMessage());
            }
        }
        this.nextItem = this.prevNoteEvent;
        this.prevNoteEvent = null;
        return this.nextItem;
    }

    @Override
    public boolean hasNext() {
        if (this.nextItem == null) {
            this.parseNextEvent();
        }
        return this.nextItem != null;
    }

    @Override
    public MMLEvent next() {
        if (this.nextItem == null) {
            return this.parseNextEvent();
        }
        MMLEvent mMLEvent = this.nextItem;
        this.nextItem = null;
        return mMLEvent;
    }

    @Override
    public void remove() {
        this.tokenizer.remove();
    }
}

