/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools.parser;

import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import jp.fourthline.mmlTools.MMLScore;
import jp.fourthline.mmlTools.MMLScoreSerializer;
import jp.fourthline.mmlTools.parser.AbstractMMLParser;
import jp.fourthline.mmlTools.parser.MMLFile;
import jp.fourthline.mmlTools.parser.MMLParseException;
import jp.fourthline.mmlTools.parser.MMSFile;
import jp.fourthline.mmlTools.parser.MidiFile;
import jp.fourthline.mmlTools.parser.TxtFile;

public interface IMMLFileParser {
    public MMLScore parse(InputStream var1) throws MMLParseException;

    public Map<String, Boolean> getParseProperties();

    public Map<String, Collection<String>> getParseAttributes();

    public void setParseAttribute(String var1, String var2);

    public String getName();

    public Map<Integer, TrackSelect> getTrackSelectMap();

    public static IMMLFileParser getParser(File file) {
        String string = file.toString().toLowerCase();
        AbstractMMLParser abstractMMLParser = string.endsWith(".mms") ? new MMSFile() : (string.endsWith(".mml") ? new MMLFile() : (string.endsWith(".mid") ? new MidiFile().preparse(file) : (string.endsWith(".txt") ? new TxtFile() : new MMLScoreSerializer(new MMLScore()))));
        return abstractMMLParser;
    }

    public static final class TrackSelect {
        private boolean enable = true;
        private final String name;

        public TrackSelect(String string) {
            this.name = string.isBlank() ? "-" : "<" + string + ">";
        }

        public void setEnable(boolean bl) {
            this.enable = bl;
        }

        public boolean isEnabled() {
            return this.enable;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

