/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools.optimizer;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.OptionalInt;
import jp.fourthline.mmlTools.core.MMLException;
import jp.fourthline.mmlTools.core.MMLTokenizer;
import jp.fourthline.mmlTools.core.MelodyParser;
import jp.fourthline.mmlTools.core.ParserWarn3ML;
import jp.fourthline.mmlTools.optimizer.MMLStringOptimizer;
import jp.fourthline.mmlTools.optimizer.OxLxOptimizer;

public class NxOptimizer
implements MMLStringOptimizer.Optimizer {
    protected int octave = 4;
    protected final MelodyParser parser = new MelodyParser("");
    protected final List<NxBuilder> builderList = new ArrayList<NxBuilder>();

    public NxOptimizer() {
        this.builderList.add(new NxBuilder(this.octave));
    }

    private NxBuilder minStack(List<NxBuilder> list) {
        return list.stream().min(NxBuilder.comparator).get();
    }

    protected int getCurrentNoteNumber() {
        return this.parser.getNoteNumber();
    }

    private void addPattern(List<NxBuilder> list) {
        int n = this.getCurrentNoteNumber();
        if (n < 0 || n > 96) {
            return;
        }
        list.stream().forEach(nxBuilder -> {
            nxBuilder.builder.append("n").append(n);
            ++nxBuilder.nCount;
        });
        this.builderList.add(this.minStack(list));
        this.clearOctToken();
    }

    private void addOctToken(String string) {
        this.builderList.stream().forEach(nxBuilder -> nxBuilder.addOctToken(nxBuilder.builder.length(), string));
    }

    private void clearOctToken() {
        this.builderList.stream().forEach(nxBuilder -> {
            nxBuilder.offset = OptionalInt.empty();
        });
    }

    private List<NxBuilder> listClone() {
        ArrayList<NxBuilder> arrayList = new ArrayList<NxBuilder>();
        this.builderList.stream().forEach(nxBuilder -> arrayList.add(nxBuilder.clone()));
        return arrayList;
    }

    private void cleanList() {
        NxBuilder nxBuilder = this.minStack(this.builderList);
        this.builderList.clear();
        this.builderList.add(nxBuilder);
    }

    protected void notePattern(String string, String string2, String string3) {
        List<NxBuilder> list = this.listClone();
        this.addNoteToken(string);
        this.cleanList();
        if (string3.length() == 0) {
            this.addPattern(list);
        }
    }

    private void doToken(String string) {
        String[] stringArray = MMLTokenizer.noteNames(string);
        char c = Character.toLowerCase(stringArray[0].charAt(0));
        if (c >= 'a' && c <= 'g') {
            this.notePattern(string, stringArray[0], stringArray[1]);
        } else if (c == '>') {
            ++this.octave;
            this.addOctToken(string);
        } else if (c == '<') {
            --this.octave;
            this.addOctToken(string);
        } else if (c == 'o') {
            this.octave = Integer.parseInt(stringArray[1]);
            this.addOctToken(string);
        } else {
            this.addToken(string);
        }
    }

    private void addNoteToken(String string) {
        this.builderList.stream().forEach(nxBuilder -> {
            nxBuilder.builder.append(OxLxOptimizer.getOctaveString(nxBuilder.prevOct, this.octave));
            nxBuilder.builder.append(string);
            nxBuilder.prevOct = this.octave;
        });
        this.clearOctToken();
    }

    private void addToken(String string) {
        this.builderList.stream().forEach(nxBuilder -> nxBuilder.builder.append(string));
    }

    private void printMap() {
        if (MMLStringOptimizer.getDebug()) {
            this.builderList.stream().forEach(nxBuilder -> System.out.println(nxBuilder.toString()));
            System.out.println(" -- ");
        }
    }

    @Override
    public void nextToken(String string) {
        try {
            this.parser.noteGT(string);
        }
        catch (MMLException | ParserWarn3ML exception) {
            // empty catch block
        }
        this.doToken(string);
        this.printMap();
    }

    @Override
    public String getMinString() {
        return this.minStack(this.builderList).builder.toString();
    }

    protected static final class NxBuilder
    implements Cloneable {
        private static final Comparator<NxBuilder> comparator = Comparator.comparingInt(nxBuilder -> nxBuilder.builder.length()).thenComparingInt(nxBuilder -> nxBuilder.nCount);
        protected StringBuilder builder = new StringBuilder();
        private int nCount = 0;
        protected int prevOct;
        private OptionalInt offset = OptionalInt.empty();

        private void addOctToken(int n, String string) {
            if (this.offset.isEmpty()) {
                this.offset = OptionalInt.of(n);
            }
        }

        private NxBuilder(int n) {
            this.prevOct = n;
        }

        protected NxBuilder(int n, String string) {
            this.prevOct = n;
            this.builder = new StringBuilder(string);
        }

        public String toString() {
            return this.builder.toString() + " [o" + this.prevOct + "] (" + this.offset + ") ";
        }

        public NxBuilder clone() {
            NxBuilder nxBuilder = new NxBuilder(this.prevOct);
            nxBuilder.builder = new StringBuilder(this.builder.toString());
            if (this.offset.isPresent()) {
                nxBuilder.offset = OptionalInt.of(this.offset.getAsInt());
            }
            return nxBuilder;
        }
    }
}

