/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools.optimizer;

import java.util.HashMap;
import java.util.Map;
import jp.fourthline.mmlTools.optimizer.NxOptimizer;
import jp.fourthline.mmlTools.optimizer.OxLxOptimizer;

public final class NxBpCmOptimizer
extends NxOptimizer {
    private final Map<Integer, String> map = new HashMap<Integer, String>();
    private final boolean disableNopt;

    public NxBpCmOptimizer(boolean bl) {
        this.disableNopt = bl;
    }

    private void addToken(NxOptimizer.NxBuilder nxBuilder, int n, String string) {
        StringBuilder stringBuilder = new StringBuilder(nxBuilder.builder);
        if (nxBuilder.prevOct != n) {
            stringBuilder.append(OxLxOptimizer.getOctaveString(nxBuilder.prevOct, n));
        }
        stringBuilder.append(string);
        String string2 = this.map.get(n);
        if (string2 == null || string2.length() > stringBuilder.length()) {
            this.map.put(n, stringBuilder.toString());
        }
    }

    public NxBpCmOptimizer(int n, String string, boolean bl) {
        this.octave = n;
        this.disableNopt = bl;
        this.builderList.clear();
        this.builderList.add(new NxOptimizer.NxBuilder(n, string));
        this.parser.setOctave(n);
    }

    @Override
    protected void notePattern(String string2, String string3, String string4) {
        this.builderList.stream().forEach(nxBuilder -> {
            int n;
            this.addToken((NxOptimizer.NxBuilder)nxBuilder, this.octave, string2);
            if (string3.equals("b")) {
                this.addToken((NxOptimizer.NxBuilder)nxBuilder, this.octave + 1, "c-" + string4);
            } else if (string3.equals("c")) {
                this.addToken((NxOptimizer.NxBuilder)nxBuilder, this.octave - 1, "b+" + string4);
            }
            if (!this.disableNopt && nxBuilder.prevOct != this.octave && string4.length() == 0 && (n = this.getCurrentNoteNumber()) >= 0 && n <= 96) {
                this.addToken((NxOptimizer.NxBuilder)nxBuilder, nxBuilder.prevOct, "n" + n);
            }
        });
        this.builderList.clear();
        this.map.forEach((n, string) -> this.builderList.add(new NxOptimizer.NxBuilder((int)n, (String)string)));
        this.map.clear();
    }
}

