/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools.optimizer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jp.fourthline.mmlTools.MMLEventList;
import jp.fourthline.mmlTools.core.MMLTokenizer;
import jp.fourthline.mmlTools.optimizer.BpCmOptimizer;
import jp.fourthline.mmlTools.optimizer.CacheMap;
import jp.fourthline.mmlTools.optimizer.NxBpCmOptimizer;
import jp.fourthline.mmlTools.optimizer.NxOptimizer;
import jp.fourthline.mmlTools.optimizer.OxLxFixedAltOptimizer;
import jp.fourthline.mmlTools.optimizer.OxLxFixedOptimizer;
import jp.fourthline.mmlTools.optimizer.OxLxOptimizer;

public final class MMLStringOptimizer {
    private static boolean debug = false;
    public static final int GEN1 = 1;
    public static final int GEN2 = 2;
    public static final int GEN3 = 3;
    private static int optLevel = 1;
    private static final Map<String, String> mmlCache = Collections.synchronizedMap(new CacheMap(256));
    private static final List<Map<?, ?>> cacheList = new ArrayList();
    private final String originalMML;
    private boolean disableNopt = false;

    public static void addCacheList(Map<?, ?> map) {
        cacheList.add(map);
    }

    public static void clearAllCache() {
        cacheList.forEach(map -> map.clear());
    }

    public static void setDebug(boolean bl) {
        debug = bl;
    }

    public static boolean getDebug() {
        return debug;
    }

    public static void setOptimizeLevel(int n) {
        optLevel = n;
    }

    public MMLStringOptimizer(String string) {
        this.originalMML = string;
    }

    public String toString() {
        return this.cachedOptimize(1, false);
    }

    public String preciseOptimize() {
        return this.cachedOptimize(optLevel, this.disableNopt);
    }

    private String cachedOptimize(int n, boolean bl) {
        String string;
        String string2;
        String string3 = n + ":" + bl + ":" + this.originalMML;
        String string4 = mmlCache.get(string3);
        if (string4 != null) {
            return string4;
        }
        string4 = n == 2 ? (new MMLEventList(string2 = this.optimizeGen2()).equals(new MMLEventList(this.originalMML)) ? string2 : this.optimize(bl)) : (n == 3 ? (new MMLEventList(string = this.optimizeGen3()).equals(new MMLEventList(this.originalMML)) ? string : this.optimize(bl)) : this.optimize(bl));
        mmlCache.put(string3, string4);
        return string4;
    }

    public String optimizeGen2() {
        Optimizer[] optimizerArray = new Optimizer[]{new OxLxFixedOptimizer(this.disableNopt), new NxBpCmOptimizer(this.disableNopt)};
        return this.optimize(optimizerArray);
    }

    public String optimizeGen3() {
        Optimizer[] optimizerArray = new Optimizer[]{new OxLxFixedAltOptimizer(this.disableNopt), new NxBpCmOptimizer(this.disableNopt), new OxLxFixedAltOptimizer.PatternOptimizer()};
        return this.optimize(optimizerArray);
    }

    public String optimizeForTextEditor() {
        Optimizer[] optimizerArray = new Optimizer[]{new OxLxFixedOptimizer(true)};
        return this.optimize(optimizerArray);
    }

    public String optimize(boolean bl) {
        Optimizer[] optimizerArray;
        if (!bl) {
            Optimizer[] optimizerArray2 = new Optimizer[3];
            optimizerArray2[0] = new OxLxOptimizer();
            optimizerArray2[1] = new BpCmOptimizer();
            optimizerArray = optimizerArray2;
            optimizerArray2[2] = new NxOptimizer();
        } else {
            Optimizer[] optimizerArray3 = new Optimizer[2];
            optimizerArray3[0] = new OxLxOptimizer();
            optimizerArray = optimizerArray3;
            optimizerArray3[1] = new BpCmOptimizer();
        }
        return this.optimize(optimizerArray);
    }

    private String optimize(Optimizer[] optimizerArray) {
        String string = this.originalMML;
        for (Optimizer optimizer : optimizerArray) {
            new MMLTokenizer(string).forEachRemaining(optimizer::nextToken);
            string = optimizer.getMinString();
        }
        return string;
    }

    public MMLStringOptimizer setDisableNopt(boolean bl) {
        this.disableNopt = bl;
        return this;
    }

    static Map<String, String> getCache() {
        return mmlCache;
    }

    public static void main(String[] stringArray) {
        MMLStringOptimizer.setDebug(true);
        String string = "c1<a+>rc<a+>c1";
        System.out.println(new MMLStringOptimizer(string).optimizeGen2());
    }

    static {
        MMLStringOptimizer.addCacheList(mmlCache);
    }

    public static interface Optimizer {
        public void nextToken(String var1);

        public String getMinString();
    }
}

