/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools.optimizer;

import jp.fourthline.mmlTools.core.MMLTokenizer;
import jp.fourthline.mmlTools.optimizer.MMLStringOptimizer;

public final class AAOptimizer
implements MMLStringOptimizer.Optimizer {
    private final int INIT_AA_VOL = 100;
    private StringBuilder sb = new StringBuilder();
    private int vol = 100;
    private String lStr = null;
    private String prevToken = "";
    private boolean tieMode = false;

    private int convertVol(int n) {
        int n2 = n * 8;
        if (n2 > 127) {
            n2 = 127;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        return n2;
    }

    private boolean volOctPattern(String string) {
        boolean bl = false;
        char c = Character.toLowerCase(string.charAt(0));
        String[] stringArray = MMLTokenizer.noteNames(string);
        if (MMLTokenizer.isNote(c) && this.vol == 100) {
            this.vol = this.convertVol(8);
            this.sb.append("V" + this.vol);
        } else if (stringArray[0].equals("v")) {
            this.vol = this.convertVol(Integer.parseInt(stringArray[1]));
            this.sb.append("V" + this.vol);
            bl = true;
        } else if (stringArray[0].equals("o")) {
            int n = Integer.parseInt(stringArray[1]) + 1;
            this.sb.append("o" + n);
            bl = true;
        }
        if (string.equals(",")) {
            this.vol = 100;
        }
        return bl;
    }

    private boolean lStrPattern(String string) {
        boolean bl = false;
        char c = Character.toLowerCase(string.charAt(0));
        String[] stringArray = MMLTokenizer.noteNames(string);
        if (string.startsWith("l")) {
            this.lStr = string.substring(1);
            bl = true;
        } else if (string.equals("&")) {
            this.tieMode = true;
        } else if (MMLTokenizer.isNote(c)) {
            if (this.tieMode && this.lStr != null) {
                if (!this.prevToken.equals("&")) {
                    this.tieMode = false;
                    if (this.lStr != null) {
                        this.sb.append("l" + this.lStr);
                        this.sb.append(string);
                        this.lStr = null;
                        bl = true;
                    }
                } else if (stringArray[1].equals("") || stringArray[1].equals(".")) {
                    this.sb.append(stringArray[0]).append(this.lStr).append(stringArray[1]);
                    bl = true;
                }
            } else if (!this.tieMode && this.lStr != null) {
                this.sb.append("l" + this.lStr);
                this.lStr = null;
            }
        }
        if (string.equals(",") && this.lStr != null) {
            this.tieMode = false;
            this.sb.append("l" + this.lStr);
            this.lStr = null;
        }
        this.prevToken = string;
        return bl;
    }

    @Override
    public void nextToken(String string) {
        if (!this.volOctPattern(string) && !this.lStrPattern(string)) {
            this.sb.append(string);
        }
    }

    @Override
    public String getMinString() {
        return this.sb.toString();
    }
}

