/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools.core;

import java.util.function.Function;

public final class MMLException
extends Exception {
    private static final long serialVersionUID = 300035736039298711L;
    private static Function<String, String> localizeFunc = null;
    private final String localizedMessage;

    public static void setLocalizeFunc(Function<String, String> function) {
        localizeFunc = function;
    }

    private MMLException(String string, String string2, String string3) {
        super(string + ": " + string2);
        this.localizedMessage = localizeFunc != null ? localizeFunc.apply("mml_exception." + string3) + ": " + string2 : null;
    }

    @Override
    public String getLocalizedMessage() {
        return this.localizedMessage != null ? this.localizedMessage : this.getMessage();
    }

    public static MMLException createUndefinedTickException(String string) {
        return new MMLException("Undefined tick table", string, "undefined_tick");
    }

    public static MMLException createUndefinedTickException(int n) {
        return MMLException.createUndefinedTickException(Integer.toString(n));
    }

    public static MMLException createUndefinedTickException(int n, int n2) {
        if (n == n2) {
            return MMLException.createUndefinedTickException(n);
        }
        return MMLException.createUndefinedTickException(n + "/" + n2);
    }

    public static MMLException createIllegalNote(String string) {
        return new MMLException("Illegal note", string, "illegal_note");
    }

    public static MMLException createIllegalNote(int n) {
        return MMLException.createIllegalNote(Integer.toString(n));
    }
}

