/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools;

import java.util.Objects;
import jp.fourthline.mmlTools.MMLEvent;
import jp.fourthline.mmlTools.core.IllegalTickOffsetException;
import jp.fourthline.mmlTools.core.MMLException;
import jp.fourthline.mmlTools.core.MMLTicks;
import jp.fourthline.mmlTools.core.TuningBase;

public final class MMLNoteEvent
extends MMLEvent
implements Cloneable {
    private static final long serialVersionUID = 4372538748155995529L;
    public static final int INIT_VOL = 8;
    public static final int MAX_VOL = 15;
    private int note;
    private int tick;
    private TuningBase tuningBase = null;
    private int velocity;
    private int[] indexOfMMLString = null;
    private boolean mute = false;
    private static final String[] noteNameTable = new String[]{"c", "c+", "d", "d+", "e", "f", "f+", "g", "g+", "a", "a+", "b"};

    public MMLNoteEvent(int n, int n2, int n3) {
        this(n, n2, n3, 8);
    }

    public MMLNoteEvent(int n, int n2, int n3, int n4) {
        super(n3);
        if (n3 + n2 >= 3840000) {
            throw new IllegalTickOffsetException(n3 + n2);
        }
        if (n4 < 0 || n4 > 15) {
            throw new IllegalArgumentException("velocity  " + n4);
        }
        this.note = n;
        this.tick = n2;
        this.velocity = n4;
    }

    public int getNote() {
        return this.note;
    }

    public void setNote(int n) {
        this.note = n;
    }

    public int getTick() {
        return this.tick;
    }

    public int getEndTick() {
        return this.getTickOffset() + this.getTick();
    }

    public void setTick(int n) {
        this.tick = n;
    }

    public boolean isTuningNote() {
        return this.tuningBase != null;
    }

    public TuningBase getTuningBase() {
        return this.tuningBase;
    }

    public void setTuningNote(TuningBase tuningBase) {
        this.tuningBase = tuningBase;
    }

    public int getVelocity() {
        return this.velocity;
    }

    public void setVelocity(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > 15) {
            n = 15;
        }
        this.velocity = n;
    }

    public void modifyVelocity(boolean bl) {
        this.setVelocity(this.velocity + (bl ? 1 : -1));
    }

    public int[] getIndexOfMMLString() {
        return this.indexOfMMLString;
    }

    public void setIndexOfMMLString(int[] nArray) {
        this.indexOfMMLString = nArray;
    }

    public boolean isMute() {
        return this.mute;
    }

    public void setMute(boolean bl) {
        this.mute = bl;
    }

    @Override
    public String toString() {
        return "[Note] note: " + this.note + ", tick: " + this.tick + ", offset: " + this.getTickOffset() + ", velocity: " + this.velocity;
    }

    private String getNoteName() throws MMLException {
        if (this.note == -1) {
            return "c-";
        }
        return noteNameTable[this.note % noteNameTable.length];
    }

    @Override
    public String toMMLString() throws MMLException {
        return this.toMMLString(0);
    }

    private String toMMLString(int n) throws MMLException {
        if (this.note < -1 || this.note >= 108) {
            throw MMLException.createIllegalNote(this.note);
        }
        String string = this.getNoteName();
        int n2 = this.tick;
        if (this.getTickOffset() < n) {
            n2 -= n - this.getTickOffset();
        }
        MMLTicks mMLTicks = new MMLTicks(string, n2);
        if (this.tuningBase != null) {
            return mMLTicks.toMMLTextByBase(this.tuningBase);
        }
        return mMLTicks.toMMLText();
    }

    public String toMMLString(MMLNoteEvent mMLNoteEvent) throws MMLException {
        if (this.note < -1 || this.note >= 108) {
            throw MMLException.createIllegalNote(this.note);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.createMMLSpaceString(mMLNoteEvent));
        stringBuilder.append(this.changeOctaveinMMLString(mMLNoteEvent.getOctave()));
        if (mMLNoteEvent.getVelocity() != this.velocity) {
            stringBuilder.append("v").append(this.velocity);
        }
        stringBuilder.append(this.toMMLString(mMLNoteEvent.getEndTick()));
        return stringBuilder.toString();
    }

    private String createMMLSpaceString(MMLNoteEvent mMLNoteEvent) throws MMLException {
        int n = this.getTickOffset() - mMLNoteEvent.getEndTick();
        if (n > 0) {
            MMLTicks mMLTicks = new MMLTicks("r", n, false);
            return mMLTicks.toMMLText();
        }
        return "";
    }

    public String changeOctaveinMMLString(int n) {
        String string = "";
        int n2 = n - this.getOctave();
        if (n2 > 0) {
            string = "<<<<<<<<".substring(0, n2);
        } else if (n2 < 0) {
            string = ">>>>>>>>".substring(0, -n2);
        }
        return string;
    }

    public int getOctave() {
        if (this.note < 0) {
            return 0;
        }
        return this.note / 12;
    }

    public MMLNoteEvent clone() {
        try {
            return (MMLNoteEvent)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException.getMessage());
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof MMLNoteEvent) {
            MMLNoteEvent mMLNoteEvent = (MMLNoteEvent)object;
            return this.tick == mMLNoteEvent.tick && this.note == mMLNoteEvent.note && this.velocity == mMLNoteEvent.velocity && super.equals(mMLNoteEvent) && Objects.equals((Object)this.tuningBase, (Object)mMLNoteEvent.tuningBase);
        }
        return false;
    }

    public static String keyToAbsNote(int n) {
        try {
            MMLNoteEvent mMLNoteEvent = new MMLNoteEvent(n, 0, 0);
            int n2 = mMLNoteEvent.getOctave();
            String string = mMLNoteEvent.getNoteName().toUpperCase();
            return "O" + n2 + string;
        }
        catch (MMLException mMLException) {
            mMLException.printStackTrace();
            return "";
        }
    }
}

