/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mmlTools;

import java.util.ArrayList;
import java.util.List;
import jp.fourthline.mmlTools.MMLBuilder;
import jp.fourthline.mmlTools.MMLEventList;
import jp.fourthline.mmlTools.MMLExceptionList;
import jp.fourthline.mmlTools.MMLTempoEvent;
import jp.fourthline.mmlTools.core.MMLTickTable;
import jp.fourthline.mmlTools.optimizer.MMLStringOptimizer;

public class MMLConverter {
    private final MMLTickTable.Switch useTable;
    private boolean allowNOpt = false;

    public MMLConverter(MMLTickTable.Switch switch_) {
        this.useTable = switch_;
    }

    public void setOption(boolean bl) {
        this.allowNOpt = bl;
    }

    public String convertMML(List<MMLEventList> list) throws MMLExceptionList {
        MMLTickTable.getInstance().tableInvSwitch(this.useTable);
        String string = null;
        try {
            string = this.getGenericMMLStrings(list);
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            MMLTickTable.getInstance().tableInvSwitch(null);
        }
        return string;
    }

    private String optimize(String string) {
        MMLStringOptimizer mMLStringOptimizer = new MMLStringOptimizer(string).setDisableNopt(!this.allowNOpt);
        String string2 = mMLStringOptimizer.optimizeGen2();
        return string2;
    }

    private boolean verify(MMLEventList mMLEventList, String string) {
        String string2;
        MMLEventList mMLEventList2 = new MMLEventList(string, null, 0);
        String string3 = mMLEventList2.getMMLNoteEventList().stream().filter(mMLNoteEvent -> mMLNoteEvent.getVelocity() > 0).toList().toString();
        boolean bl = string3.equals(string2 = mMLEventList.getMMLNoteEventList().stream().filter(mMLNoteEvent -> mMLNoteEvent.getVelocity() > 0).toList().toString());
        if (!bl) {
            System.out.println(string);
            System.out.println(string2);
            System.out.println(string3);
        }
        return bl;
    }

    private List<MMLEventList> makeRelationPart(List<MMLEventList> list, int n) {
        ArrayList<MMLEventList> arrayList = new ArrayList<MMLEventList>();
        int n2 = list.size();
        for (int i = 1; i < n2; ++i) {
            arrayList.add(list.get((n + i) % n2));
        }
        return arrayList;
    }

    private String getGenericMMLStrings(List<MMLEventList> list) throws MMLExceptionList {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<MMLExceptionList.Entry> arrayList = new ArrayList<MMLExceptionList.Entry>();
        ArrayList<MMLTempoEvent> arrayList2 = !list.isEmpty() ? new ArrayList<MMLTempoEvent>(list.get(0).getGlobalTempoList()) : List.of();
        try {
            for (int i = 0; i < list.size(); ++i) {
                MMLEventList mMLEventList = list.get(i);
                String string = MMLBuilder.create(mMLEventList, 0, 4).setNoTempoVZeroCombine().toMMLStringMusicQ(arrayList2, this.makeRelationPart(list, i));
                if (!this.verify(mMLEventList, string = this.optimize(string))) {
                    return null;
                }
                if (string.length() <= 0) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(string);
            }
        }
        catch (MMLExceptionList mMLExceptionList) {
            arrayList.addAll(mMLExceptionList.getErr());
        }
        if (!arrayList.isEmpty()) {
            throw new MMLExceptionList(arrayList);
        }
        stringBuilder.insert(0, "MML@");
        stringBuilder.append(";");
        return stringBuilder.toString();
    }
}

