/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui.table;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.midi.InstClass;
import jp.fourthline.mabiicco.midi.MabiDLS;
import jp.fourthline.mmlTools.ComposeRank;
import jp.fourthline.mmlTools.MMLTrack;
import jp.fourthline.mmlTools.core.MMLText;

public final class TrackListTable
extends JTable {
    private static final long serialVersionUID = -710966050907225119L;
    private final InCheckTableModel checkTableModel;

    public TrackListTable(List<MMLTrack> list) {
        this(list, false);
    }

    public TrackListTable(List<MMLTrack> list, boolean bl) {
        this.checkTableModel = new InCheckTableModel(list, bl);
        this.initialize(bl);
    }

    public TrackListTable(MMLTrack mMLTrack, List<MMLText> list) {
        this.checkTableModel = new InCheckTableModel(mMLTrack, list);
        this.initialize(false);
    }

    private void initialize(boolean bl) {
        this.setModel(this.checkTableModel);
        if (bl) {
            this.getColumnModel().getColumn(0).setPreferredWidth(0);
            this.getColumnModel().getColumn(1).setPreferredWidth(20);
            this.getColumnModel().getColumn(1).setMaxWidth(20);
            this.getColumnModel().getColumn(4).setPreferredWidth(180);
            this.setRowSelectionAllowed(false);
        } else {
            this.getColumnModel().getColumn(0).setPreferredWidth(20);
            this.getColumnModel().getColumn(0).setMaxWidth(20);
            this.getColumnModel().getColumn(3).setPreferredWidth(180);
            this.setSelectionMode(0);
            this.setRowSelectionInterval(0, 0);
        }
        this.getTableHeader().setReorderingAllowed(false);
        this.setFocusable(false);
    }

    public boolean[] getCheckList() {
        return this.checkTableModel.checkValue;
    }

    public int getCheckCount() {
        int n = 0;
        for (boolean bl : this.getCheckList()) {
            if (!bl) continue;
            ++n;
        }
        return n;
    }

    public void setInitialCheck(int n) {
        this.setInitialCheck(n, true);
    }

    public void setInitialCheck(int n, boolean bl) {
        for (int i = 0; i < this.checkTableModel.checkValue.length; ++i) {
            if (i >= n) continue;
            this.checkTableModel.checkValue[i] = bl;
        }
    }

    public boolean selectedRowCanSplit() {
        int n = this.getSelectedRow();
        ComposeRank composeRank = this.checkTableModel.rankList.get(n);
        return !composeRank.canCompose();
    }

    public ComposeRank getRank(int n) {
        return this.checkTableModel.rankList.get(n);
    }

    public String getTableListInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("#\t").append(AppResource.appText("mml.output.trackName")).append('\t').append(AppResource.appText("mml.output.instrument")).append('\t').append(AppResource.appText("mml.output.rank")).append('\n');
        for (Object[] objectArray : this.checkTableModel.dataList) {
            for (Object object : objectArray) {
                stringBuilder.append(object).append('\t');
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1).append('\n');
        }
        return stringBuilder.toString();
    }

    private static final class InCheckTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -5732476297298041942L;
        private final String[] columnNames = new String[]{"", "#", AppResource.appText("mml.output.trackName"), AppResource.appText("mml.output.instrument"), AppResource.appText("mml.output.rank")};
        private final boolean checkBox;
        private final boolean[] checkValue;
        private final ArrayList<Object[]> dataList = new ArrayList();
        private final ArrayList<ComposeRank> rankList = new ArrayList();

        private InCheckTableModel(List<MMLTrack> list, boolean bl) {
            this.checkBox = bl;
            this.checkValue = new boolean[list.size()];
            int n = 0;
            for (MMLTrack mMLTrack : list) {
                InstClass instClass = MabiDLS.getInstance().getInstByProgram(mMLTrack.getProgram());
                this.dataList.add(new Object[]{++n, mMLTrack.getTrackName(), instClass.toString(), mMLTrack.mmlRankFormat()});
                this.rankList.add(mMLTrack.mmlRank());
            }
        }

        private InCheckTableModel(MMLTrack mMLTrack, List<MMLText> list) {
            this.checkBox = false;
            this.checkValue = null;
            int n = 0;
            for (MMLText mMLText : list) {
                InstClass instClass = MabiDLS.getInstance().getInstByProgram(mMLTrack.getProgram());
                this.dataList.add(new String[]{Integer.toString(++n), mMLTrack.getTrackName(), instClass.toString(), mMLText.mmlRankFormat()});
                this.rankList.add(mMLText.mmlRank());
            }
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public int getColumnCount() {
            int n = this.columnNames.length;
            if (!this.checkBox) {
                --n;
            }
            return n;
        }

        @Override
        public int getRowCount() {
            return this.dataList.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (!this.checkBox) {
                ++n2;
            }
            if (n2 == 0) {
                return this.checkValue[n];
            }
            return this.dataList.get(n)[n2 - 1];
        }

        @Override
        public String getColumnName(int n) {
            if (!this.checkBox) {
                ++n;
            }
            return this.columnNames[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!this.checkBox) {
                ++n2;
            }
            return n2 == 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (!this.checkBox) {
                ++n2;
            }
            if (n2 != 0) {
                return;
            }
            this.checkValue[n] = object.equals(Boolean.TRUE);
        }
    }
}

