/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui.mml;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.ui.IMMLManager;
import jp.fourthline.mabiicco.ui.UIUtils;
import jp.fourthline.mabiicco.ui.editor.NumberSpinner;
import jp.fourthline.mmlTools.MMLExceptionList;
import jp.fourthline.mmlTools.MMLScore;
import jp.fourthline.mmlTools.MMLTempoConverter;
import jp.fourthline.mmlTools.MMLTempoEvent;
import jp.fourthline.mmlTools.MMLTrack;
import jp.fourthline.mmlTools.MMLVerifyException;
import jp.fourthline.mmlTools.core.MMLException;
import jp.fourthline.mmlTools.core.MMLTicks;

public final class TrackPropertyPanel
extends JPanel {
    private static final long serialVersionUID = 7599129671956571455L;
    private final JTextField trackNameField = new JTextField();
    private final JSlider panpotSlider = new JSlider();
    private final JSpinner volumeSpinner = NumberSpinner.createSpinner(0, 0, 127, 1);
    private final MMLOutputOptions instOption;
    private final MMLOutputOptions songOption;
    private final JCheckBox disableNoptCheckBox = UIUtils.createCheckBox("track_property.disable_nopt", true);
    private final JCheckBox tempoOnlyMelodyCheckBox = UIUtils.createCheckBox("track_property.tempo_only_melody", true);
    private final IMMLManager mmlManager;
    private final MMLTrack track;
    private final MMLTrack sandTrack;
    private final Dimension prefSize = new Dimension(350, 370);

    public TrackPropertyPanel(MMLTrack mMLTrack, IMMLManager iMMLManager) {
        int n3 = mMLTrack.getCommonStartOffset();
        this.track = mMLTrack;
        this.sandTrack = mMLTrack.clone();
        this.mmlManager = iMMLManager;
        this.instOption = new MMLOutputOptions(0, n2 -> this.sandTrack.setStartDelta(n2 - n3), n -> this.sandTrack.setAttackDelayCorrect((int)n));
        this.songOption = new MMLOutputOptions(3, n2 -> this.sandTrack.setStartSongDelta(n2 - n3), n -> this.sandTrack.setAttackSongDelayCorrect((int)n));
        this.initialize();
    }

    private void initialize() {
        this.setLayout(null);
        this.add(this.newJLabel(AppResource.appText("track_property.trackname"), 20, 3, 100, 14));
        this.trackNameField.setBounds(120, 0, 200, 19);
        this.trackNameField.setEditable(true);
        this.add(this.trackNameField);
        this.trackNameField.setColumns(10);
        this.panpotSlider.setSnapToTicks(true);
        this.panpotSlider.setPaintTicks(true);
        this.panpotSlider.setMinorTickSpacing(4);
        this.panpotSlider.setMajorTickSpacing(16);
        this.panpotSlider.setMaximum(128);
        this.panpotSlider.setBounds(120, 30, 200, 23);
        this.add(this.panpotSlider);
        JLabel jLabel = new JLabel("L64");
        jLabel.setBounds(120, 50, 30, 23);
        this.add(jLabel);
        JLabel jLabel2 = new JLabel("0");
        jLabel2.setBounds(217, 50, 30, 23);
        this.add(jLabel2);
        JLabel jLabel3 = new JLabel("R64");
        jLabel3.setBounds(302, 50, 30, 23);
        this.add(jLabel3);
        this.add(this.newJLabel(AppResource.appText("track_property.panpot"), 20, 40, 100, 14));
        this.volumeSpinner.setBounds(180, 80, 60, 23);
        this.add(this.volumeSpinner);
        JButton jButton = new JButton("reset");
        jButton.setFocusable(false);
        jButton.addActionListener(actionEvent -> this.volumeSpinner.setValue(100));
        jButton.setBounds(260, 82, 60, 18);
        jButton.putClientProperty("JButton.buttonType", "roundRect");
        this.add(jButton);
        this.add(this.newJLabel(AppResource.appText("track_property.volume"), 20, 83, 100, 14));
        this.add(this.instOption.createMMLOptionPanel("track_property.mmlOptions1", 5, 120));
        this.add(this.songOption.createMMLOptionPanel("track_property.mmlOptions2", 5, 210));
        JPanel jPanel = UIUtils.createTitledPanel("track_property.opt_option");
        jPanel.setBounds(5, 300, 340, 70);
        this.disableNoptCheckBox.setBounds(20, 20, 240, 20);
        jPanel.add(this.disableNoptCheckBox);
        this.tempoOnlyMelodyCheckBox.setBounds(20, 40, 240, 20);
        jPanel.add(this.tempoOnlyMelodyCheckBox);
        this.add(jPanel);
        int n = this.track.getCommonStartOffset();
        this.trackNameField.setText(this.track.getTrackName());
        this.panpotSlider.setValue(this.track.getPanpot());
        this.volumeSpinner.setValue(this.track.getVolume());
        this.instOption.setValue(this.track.getStartDelta() + n, this.track.getAttackDelayCorrect());
        this.songOption.setValue(this.track.getStartSongDelta() + n, this.track.getAttackSongDelayCorrect());
        this.disableNoptCheckBox.setSelected(this.track.getDisableNopt());
        this.tempoOnlyMelodyCheckBox.setSelected(this.track.getOptTempoMelodyOnly());
    }

    private JLabel newJLabel(String string, int n, int n2, int n3, int n4) {
        JLabel jLabel = new JLabel(string);
        jLabel.setBounds(n, n2, n3, n4);
        return jLabel;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    private void applyProperty() {
        int n = this.track.getCommonStartOffset();
        this.track.setTrackName(this.trackNameField.getText());
        this.track.setPanpot(this.panpotSlider.getValue());
        this.track.setVolume((Integer)this.volumeSpinner.getValue());
        try {
            this.track.setStartDelta(this.instOption.getStartOffset() - n);
            this.track.setStartSongDelta(this.songOption.getStartOffset() - n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(this, AppResource.appText("error.startOffset"), AppResource.getAppTitle(), 2);
            return;
        }
        this.track.setAttackDelayCorrect(this.instOption.getAttackDelayCorrect());
        this.track.setAttackSongDelayCorrect(this.songOption.getAttackDelayCorrect());
        this.track.setDisableNopt(this.disableNoptCheckBox.isSelected());
        this.track.setOptTempoOnlyMelody(this.tempoOnlyMelodyCheckBox.isSelected());
        this.mmlManager.updateActivePart(true);
    }

    public List<String> getLabelText() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List.of(this.instOption, this.songOption).forEach(mMLOutputOptions -> {
            arrayList.add(mMLOutputOptions.startOffsetText.getText());
            arrayList.add(mMLOutputOptions.attackDelayCorrectText.getText());
        });
        return arrayList;
    }

    public void showDialog(Frame frame) {
        int n = JOptionPane.showConfirmDialog(frame, this, AppResource.appText("track_property"), 2, -1);
        if (n == 0) {
            this.applyProperty();
        }
    }

    private class MMLOutputOptions {
        private final JSpinner startOffsetSpinner = NumberSpinner.createSpinner(0, 0, 393216, 1);
        private final JLabel startOffsetText = new JLabel();
        private final JSpinner attackDelayCorrectSpinner = NumberSpinner.createSpinner(0, -48, 48, 1);
        private final JLabel attackDelayCorrectText = new JLabel();
        private final int partIndex;
        private final Consumer<Integer> ss1;
        private final Consumer<Integer> ss2;

        private MMLOutputOptions(int n, Consumer<Integer> consumer, Consumer<Integer> consumer2) {
            this.partIndex = n;
            this.ss1 = consumer;
            this.ss2 = consumer2;
        }

        private JPanel createMMLOptionPanel(String string, int n, int n2) {
            String string2 = AppResource.appText("track_property.startDelta");
            String string3 = AppResource.appText("track_property.attackDelayCorrect");
            JPanel jPanel = UIUtils.createTitledPanel(string);
            jPanel.setBounds(n, n2, 340, 80);
            TrackPropertyPanel.this.add(jPanel);
            jPanel.add(TrackPropertyPanel.this.newJLabel(string2, 20, 20, 170, 14));
            this.startOffsetSpinner.setBounds(160, 20, 100, 20);
            jPanel.add(this.startOffsetSpinner);
            this.startOffsetText.setBounds(270, 23, 120, 14);
            jPanel.add(this.startOffsetText);
            this.startOffsetSpinner.addChangeListener(changeEvent -> this.updateStartOffsetText());
            jPanel.add(TrackPropertyPanel.this.newJLabel(string3, 20, 50, 140, 14));
            this.attackDelayCorrectSpinner.setBounds(160, 50, 60, 20);
            jPanel.add(this.attackDelayCorrectSpinner);
            this.attackDelayCorrectText.setBounds(230, 53, 120, 14);
            jPanel.add(this.attackDelayCorrectText);
            this.attackDelayCorrectSpinner.addChangeListener(changeEvent -> this.updateDelayTickText());
            return jPanel;
        }

        private void setValue(int n, int n2) {
            this.startOffsetSpinner.setValue(n);
            this.attackDelayCorrectSpinner.setValue(n2);
            this.updateLabelAll();
        }

        private int getStartOffset() {
            return (Integer)this.startOffsetSpinner.getValue();
        }

        private int getAttackDelayCorrect() {
            return (Integer)this.attackDelayCorrectSpinner.getValue();
        }

        private void updateLabelAll() {
            this.updateStartOffsetText();
            this.updateDelayTickText();
        }

        private void updateStartOffsetText() {
            this.updateLabelStartOffset(this.startOffsetText, (Integer)this.startOffsetSpinner.getValue());
        }

        private void updateLabelStartOffset(JLabel jLabel, int n) {
            MMLScore mMLScore = TrackPropertyPanel.this.mmlManager.getMMLScore();
            String string = mMLScore.getBarTextTick(n);
            jLabel.setText(string);
            this.ss1.accept(n);
            try {
                TrackPropertyPanel.this.sandTrack.generate();
                jLabel.setForeground(Color.BLACK);
            }
            catch (MMLExceptionList | MMLVerifyException exception) {
                jLabel.setForeground(Color.RED);
            }
        }

        private void updateDelayTickText() {
            this.updateLabelTickToMML(this.attackDelayCorrectText, (Integer)this.attackDelayCorrectSpinner.getValue(), this.partIndex);
        }

        private void updateLabelTickToMML(JLabel jLabel, int n, int n2) {
            int n3 = TrackPropertyPanel.this.track.getStartOffset(n2);
            List<MMLTempoEvent> list = TrackPropertyPanel.this.track.getGlobalTempoList();
            double d = MMLTempoConverter.getTimeOnTickOffset(list, n3);
            double d2 = MMLTempoConverter.getTimeOnTickOffset(list, n3 - n);
            long l = Math.round(d - d2);
            Object object = "";
            if (n != 0) {
                try {
                    object = new MMLTicks("L", Math.abs(n)).toMMLText();
                    if (n < 0) {
                        object = "-" + (String)object;
                    }
                    object = "=" + (String)object;
                }
                catch (MMLException mMLException) {
                    object = "=N/A";
                }
            }
            jLabel.setText(l + "ms" + (String)object);
            this.ss2.accept(n);
            try {
                TrackPropertyPanel.this.sandTrack.generate();
                jLabel.setForeground(Color.BLACK);
            }
            catch (MMLExceptionList | MMLVerifyException exception) {
                jLabel.setForeground(Color.RED);
            }
        }
    }
}

