/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui.mml;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.ui.IMMLManager;
import jp.fourthline.mabiicco.ui.MMLTrackView;
import jp.fourthline.mabiicco.ui.UIUtils;
import jp.fourthline.mabiicco.ui.editor.MMLEditor;
import jp.fourthline.mabiicco.ui.table.TrackListTable;
import jp.fourthline.mmlTools.MMLEventList;
import jp.fourthline.mmlTools.MMLScore;
import jp.fourthline.mmlTools.MMLTrack;

public final class MMLPartChangePanel
extends JPanel {
    private static final long serialVersionUID = 8558159209741558854L;
    private TrackListTable table;
    private final JDialog dialog;
    private final JButton applyButton = new JButton(AppResource.appText("part_change.apply"));
    private final IMMLManager mmlManager;
    private final MMLEditor editor;
    private final Frame parentFrame;
    private JRadioButton radioSelectArea;
    private JRadioButton radioAllArea;
    private JRadioButton radioChange;
    private JRadioButton radioMove;
    private JRadioButton radioCopy;
    private JComboBox<String> partSelectComboBox;
    private final JLabel selectedRange = new JLabel();
    private final Dimension prefSize = new Dimension(460, 450);

    public MMLPartChangePanel() {
        this.dialog = null;
        this.mmlManager = null;
        this.editor = null;
        this.parentFrame = null;
        this.initializePanel(null, 0);
    }

    public MMLPartChangePanel(Frame frame, IMMLManager iMMLManager, MMLEditor mMLEditor) {
        this.dialog = new JDialog(frame, AppResource.appText("part_change"), true);
        this.mmlManager = iMMLManager;
        this.editor = mMLEditor;
        this.parentFrame = frame;
        this.initializePanel(iMMLManager.getMMLScore().getTrackList(), iMMLManager.getActiveTrackIndex());
    }

    private void initializePanel(List<MMLTrack> list, int n) {
        this.setLayout(null);
        this.applyButton.setBounds(204, 412, 90, 29);
        this.add(this.applyButton);
        this.applyButton.addActionListener(actionEvent -> {
            this.changePartAction();
            this.mmlManager.updateActivePart(true);
            this.dialog.setVisible(false);
        });
        JButton jButton = new JButton(AppResource.appText("part_change.cancel"));
        jButton.setBounds(319, 412, 90, 29);
        this.add(jButton);
        jButton.setFocusable(false);
        jButton.addActionListener(actionEvent -> this.dialog.setVisible(false));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(new LineBorder(new Color(128, 128, 128), 1, true), AppResource.appText("part_change.src"), 4, 2, null, null));
        jPanel.setBounds(12, 10, 414, 63);
        jPanel.setLayout(null);
        this.add(jPanel);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.radioSelectArea = new JRadioButton(AppResource.appText("part_change.selectArea"));
        this.radioSelectArea.setBounds(8, 22, 113, 21);
        jPanel.add(this.radioSelectArea);
        buttonGroup.add(this.radioSelectArea);
        this.selectedRange.setBounds(8, 43, 260, 14);
        jPanel.add(this.selectedRange);
        this.radioAllArea = new JRadioButton(AppResource.appText("part_change.all"));
        this.radioAllArea.setBounds(138, 22, 113, 21);
        jPanel.add(this.radioAllArea);
        buttonGroup.add(this.radioAllArea);
        if (this.editor != null) {
            if (this.editor.hasSelectedNote()) {
                this.radioSelectArea.setSelected(true);
            } else {
                this.radioSelectArea.setEnabled(false);
                this.radioAllArea.setSelected(true);
            }
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new TitledBorder(new LineBorder(new Color(128, 128, 128), 1, true), AppResource.appText("part_change.dest"), 4, 2, null, null));
        jPanel2.setBounds(12, 83, 414, 246);
        jPanel2.setLayout(null);
        this.add(jPanel2);
        JLabel jLabel = new JLabel(AppResource.appText("track"));
        jLabel.setBounds(12, 23, 172, 14);
        jPanel2.add(jLabel);
        JLabel jLabel2 = new JLabel(AppResource.appText("part"));
        jLabel2.setBounds(12, 209, 64, 14);
        jPanel2.add(jLabel2);
        this.partSelectComboBox = new JComboBox();
        this.partSelectComboBox.setBounds(100, 206, 131, 19);
        this.partSelectComboBox.addActionListener(actionEvent -> this.updateRange());
        jPanel2.add(this.partSelectComboBox);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBounds(12, 46, 372, 142);
        jPanel2.add(jScrollPane);
        this.table = new TrackListTable(list);
        jScrollPane.setViewportView(this.table);
        this.table.setRowSelectionInterval(n, n);
        Point point = jScrollPane.getViewport().getViewPosition();
        point.y = n * this.table.getRowHeight();
        jScrollPane.getViewport().setViewPosition(point);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                MMLPartChangePanel.this.updateView();
            }
        });
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(new TitledBorder(new LineBorder(new Color(128, 128, 128), 1, true), AppResource.appText("part_change.method"), 4, 2, null, null));
        jPanel3.setBounds(12, 339, 414, 63);
        jPanel3.setLayout(null);
        this.add(jPanel3);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.radioChange = new JRadioButton(AppResource.appText("part_change.swap"));
        this.radioChange.setBounds(8, 22, 113, 21);
        this.radioChange.setSelected(true);
        jPanel3.add(this.radioChange);
        buttonGroup2.add(this.radioChange);
        this.radioMove = new JRadioButton(AppResource.appText("part_change.move"));
        this.radioMove.setBounds(139, 22, 113, 21);
        jPanel3.add(this.radioMove);
        buttonGroup2.add(this.radioMove);
        this.radioCopy = new JRadioButton(AppResource.appText("part_change.copy"));
        this.radioCopy.setBounds(256, 22, 113, 21);
        jPanel3.add(this.radioCopy);
        buttonGroup2.add(this.radioCopy);
        UIUtils.dialogCloseAction(this.dialog);
        this.updateView();
    }

    private void updateView() {
        this.updatePartSelectBox();
        this.updateRange();
    }

    private void updatePartSelectBox() {
        if (this.mmlManager == null) {
            return;
        }
        MMLEventList mMLEventList = this.mmlManager.getActiveMMLPart();
        if (mMLEventList == null) {
            return;
        }
        int n = this.table.getSelectedRow();
        this.partSelectComboBox.removeAllItems();
        MMLTrack mMLTrack = this.mmlManager.getMMLScore().getTrack(n);
        for (int i = 0; i < MMLTrackView.MMLPART_NAME.length; ++i) {
            if (mMLTrack.getMMLEventAtIndex(i) == mMLEventList) continue;
            this.partSelectComboBox.addItem(MMLTrackView.MMLPART_NAME[i]);
        }
    }

    private MMLEventList getToPart() {
        int n;
        MMLEventList mMLEventList = null;
        int n2 = this.table.getSelectedRow();
        MMLTrack mMLTrack = this.mmlManager.getMMLScore().getTrack(n2);
        Object object = this.partSelectComboBox.getSelectedItem();
        if (object != null && (n = Arrays.asList(MMLTrackView.MMLPART_NAME).indexOf(object)) >= 0) {
            mMLEventList = mMLTrack.getMMLEventAtIndex(n);
        }
        return mMLEventList;
    }

    private void updateRange() {
        Object object = "";
        MMLEventList mMLEventList = this.mmlManager.getActiveMMLPart();
        MMLEventList mMLEventList2 = this.getToPart();
        if (mMLEventList != null && mMLEventList2 != null) {
            MMLEditor.TickRange tickRange = this.editor.selectedRange(mMLEventList, mMLEventList2);
            MMLScore mMLScore = this.mmlManager.getMMLScore();
            if (tickRange != null) {
                object = "[ " + mMLScore.getBarTextTick(tickRange.start()) + ", " + mMLScore.getBarTextTick(tickRange.end()) + " ]";
            }
        }
        this.selectedRange.setText((String)object);
    }

    private void changePartAction() {
        if (this.mmlManager == null) {
            return;
        }
        MMLEditor.ChangePartAction changePartAction = MMLEditor.ChangePartAction.SWAP;
        if (this.radioMove.isSelected()) {
            changePartAction = MMLEditor.ChangePartAction.MOVE;
        } else if (this.radioCopy.isSelected()) {
            changePartAction = MMLEditor.ChangePartAction.COPY;
        }
        MMLEventList mMLEventList = this.mmlManager.getActiveMMLPart();
        MMLEventList mMLEventList2 = this.getToPart();
        if (mMLEventList != null && mMLEventList2 != null) {
            this.editor.changePart(mMLEventList, mMLEventList2, this.radioSelectArea.isSelected(), changePartAction);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    public void showDialog() {
        if (this.mmlManager.getActiveMMLPart() != null) {
            this.dialog.getContentPane().add(this);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setLocationRelativeTo(this.parentFrame);
            this.dialog.setVisible(true);
        }
    }
}

