/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui.mml;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.ui.IMMLManager;
import jp.fourthline.mabiicco.ui.UIUtils;
import jp.fourthline.mabiicco.ui.table.TrackListTable;
import jp.fourthline.mmlTools.MMLScore;
import jp.fourthline.mmlTools.MMLTrack;

public final class MMLImportPanel
extends JPanel {
    private static final long serialVersionUID = -1504636951822574399L;
    private TrackListTable table;
    private final JDialog dialog;
    private final Frame parentFrame;
    private final MMLScore importedScore;
    private final IMMLManager mmlManager;
    private final int possibleImportTrackCount;
    private final boolean newImport;
    private final JLabel lblNewLabel = new JLabel(AppResource.appText("mml.input.import.possibleImport") + ": XX/XX");
    private final Dimension prefSize = new Dimension(460, 300);

    public MMLImportPanel(Frame frame, MMLScore mMLScore, IMMLManager iMMLManager, boolean bl) {
        this.dialog = new JDialog(frame, AppResource.appText("mml.input.import"), true);
        this.importedScore = mMLScore;
        this.mmlManager = iMMLManager;
        this.parentFrame = frame;
        this.newImport = bl;
        this.possibleImportTrackCount = bl ? mMLScore.getTrackCount() : Math.min(24 - iMMLManager.getMMLScore().getTrackCount(), mMLScore.getTrackCount());
        this.initializePanel(mMLScore.getTrackList());
    }

    private void initializePanel(List<MMLTrack> list) {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(null);
        JButton jButton = new JButton(AppResource.appText("mml.input.import"));
        jButton.setMargin(new Insets(5, 10, 5, 10));
        jPanel.add(jButton);
        jButton.addActionListener(actionEvent -> {
            this.importMMLTrack();
            this.dialog.setVisible(false);
        });
        JButton jButton2 = new JButton(AppResource.appText("mml.output.closeButton"));
        jButton2.setMargin(new Insets(5, 10, 5, 10));
        jPanel.add(jButton2);
        jButton2.setFocusable(false);
        jButton2.addActionListener(actionEvent -> this.dialog.setVisible(false));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBounds(12, 10, 422, 229);
        jPanel2.add(jScrollPane);
        this.table = new TrackListTable(list, true);
        this.table.setInitialCheck(this.possibleImportTrackCount);
        this.table.addPropertyChangeListener(propertyChangeEvent -> {
            jButton.setEnabled(this.table.getCheckCount() > 0 && this.table.getCheckCount() <= this.possibleImportTrackCount);
            this.updateLabel();
        });
        jScrollPane.setViewportView(this.table);
        this.lblNewLabel.setBounds(22, 242, 300, 14);
        this.updateLabel();
        jPanel2.add(this.lblNewLabel);
        this.table.setDefaultEditor(Object.class, null);
        UIUtils.dialogCloseAction(this.dialog);
        this.add((Component)jPanel, "South");
        this.add((Component)jPanel2, "Center");
    }

    private void updateLabel() {
        this.lblNewLabel.setText(AppResource.appText("mml.input.import.possibleImport") + ": " + this.table.getCheckCount() + "/" + this.possibleImportTrackCount);
    }

    void importMMLTrack() {
        List<MMLTrack> list = this.importedScore.getTrackList();
        MMLScore mMLScore = this.mmlManager.getMMLScore();
        if (this.newImport) {
            for (int i = 0; i < mMLScore.getTrackCount(); ++i) {
                mMLScore.removeTrack(0);
            }
            mMLScore.setAuthor(this.importedScore.getAuthor());
            mMLScore.setTitle(this.importedScore.getTitle());
            mMLScore.setBaseTime(this.importedScore.getBaseTime());
        }
        boolean[] blArray = this.table.getCheckList();
        for (int i = 0; i < list.size(); ++i) {
            if (!blArray[i]) continue;
            mMLScore.addTrack(list.get(i));
        }
        this.mmlManager.updateActivePart(false);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    public void showDialog() {
        this.dialog.getContentPane().add(this);
        this.dialog.pack();
        this.dialog.setResizable(false);
        this.dialog.setLocationRelativeTo(this.parentFrame);
        this.dialog.setVisible(true);
    }
}

