/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.ui.IMMLManager;
import jp.fourthline.mabiicco.ui.UIUtils;
import jp.fourthline.mabiicco.ui.table.TrackListTable;
import jp.fourthline.mmlTools.MMLTrack;

public final class MultiTracksViewEditor
extends JPanel {
    private static final long serialVersionUID = 7227807579193973972L;
    private TrackListTable table;
    private final JDialog dialog;
    private JButton applyButton;
    private final IMMLManager mmlManager;
    private final Frame parentFrame;
    private boolean[] oldValue;
    private final Dimension prefSize = new Dimension(460, 300);

    public MultiTracksViewEditor(Frame frame, IMMLManager iMMLManager) {
        this.dialog = new JDialog(frame, AppResource.appText("edit.tracks.view"), true);
        this.mmlManager = iMMLManager;
        this.parentFrame = frame;
        this.initializePanel();
    }

    public void showDialog() {
        this.dialog.getContentPane().add(this);
        this.dialog.pack();
        this.dialog.setResizable(false);
        this.dialog.setLocationRelativeTo(this.parentFrame);
        this.dialog.setVisible(true);
    }

    private void initializePanel() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        this.applyButton = new JButton(AppResource.appText("edit.apply"));
        this.applyButton.setMargin(new Insets(5, 10, 5, 10));
        jPanel.add(this.applyButton);
        this.applyButton.addActionListener(actionEvent -> {
            this.apply(this.table.getCheckList());
            this.mmlManager.updateActivePart(true);
            this.dialog.setVisible(false);
        });
        JButton jButton = new JButton(AppResource.appText("edit.cancel"));
        jButton.setMargin(new Insets(5, 10, 5, 10));
        jPanel.add(jButton);
        jButton.setFocusable(false);
        jButton.addActionListener(actionEvent -> {
            this.apply(this.oldValue);
            this.dialog.setVisible(false);
        });
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBounds(12, 10, 422, 169);
        jPanel2.add((Component)jScrollPane, "Center");
        JPanel jPanel4 = new JPanel();
        JButton jButton2 = new JButton(AppResource.appText("menu.selectAll"));
        jButton2.addActionListener(actionEvent -> {
            this.table.setInitialCheck(this.table.getCheckList().length);
            this.repaint();
        });
        jPanel4.add(jButton2);
        JButton jButton3 = new JButton(AppResource.appText("menu.selectClear"));
        jButton3.addActionListener(actionEvent -> {
            this.table.setInitialCheck(this.table.getCheckList().length, false);
            this.repaint();
        });
        jPanel4.add(jButton3);
        jPanel2.add((Component)jPanel4, "North");
        this.table = new TrackListTable(this.mmlManager.getMMLScore().getTrackList(), true);
        this.table.addPropertyChangeListener(propertyChangeEvent -> this.apply(this.table.getCheckList()));
        jScrollPane.setViewportView(this.table);
        this.table.setDefaultEditor(Object.class, null);
        for (int i = 0; i < this.table.getCheckList().length; ++i) {
            MMLTrack mMLTrack = this.mmlManager.getMMLScore().getTrack(i);
            this.table.getCheckList()[i] = mMLTrack.isVisible();
        }
        this.oldValue = (boolean[])this.table.getCheckList().clone();
        UIUtils.dialogCloseAction(this.dialog, this::cancelAction);
        this.add((Component)jPanel, "South");
        this.add((Component)jPanel3, "North");
        this.add((Component)jPanel2, "Center");
    }

    private void cancelAction() {
        this.apply(this.oldValue);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    public void apply(boolean[] blArray) {
        List<MMLTrack> list = this.mmlManager.getMMLScore().getTrackList();
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).setVisible(blArray[i]);
        }
        this.parentFrame.repaint();
    }
}

