/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.ui.IMMLManager;
import jp.fourthline.mabiicco.ui.IViewTargetMarker;
import jp.fourthline.mabiicco.ui.UIUtils;
import jp.fourthline.mabiicco.ui.editor.AbstractMarkerEditor;
import jp.fourthline.mabiicco.ui.editor.IEditAlign;
import jp.fourthline.mmlTools.Marker;

public final class MarkerEditor
extends AbstractMarkerEditor<Marker> {
    private final Frame parentFrame;

    public MarkerEditor(Frame frame, IMMLManager iMMLManager, IEditAlign iEditAlign, IViewTargetMarker iViewTargetMarker) {
        super("marker", iMMLManager, iEditAlign, iViewTargetMarker);
        this.parentFrame = frame;
    }

    private String showTextInputDialog(String string, String string2) {
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel(AppResource.appText("edit.label_" + this.suffix)));
        JTextField jTextField = new JTextField(string2, 10);
        UIUtils.setDefaultFocus(jTextField);
        jPanel.add(jTextField);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        int n = JOptionPane.showConfirmDialog(this.parentFrame, jPanel2, string, 2);
        if (n == 0) {
            return jTextField.getText();
        }
        return null;
    }

    @Override
    protected List<Marker> getEventList() {
        return this.mmlManager.getMMLScore().getMarkerList();
    }

    @Override
    protected boolean insertAction() {
        String string = this.showTextInputDialog(AppResource.appText("edit." + this.insertCommand), AppResource.appText("edit.new.marker"));
        if (string == null || string.length() == 0) {
            return false;
        }
        Marker marker = new Marker(string, this.targetTick);
        this.getEventList().add(marker);
        return true;
    }

    @Override
    protected boolean editAction() {
        String string = this.showTextInputDialog(AppResource.appText("edit." + this.editCommand), ((Marker)this.targetEvent).getName());
        if (string == null) {
            return false;
        }
        ((Marker)this.targetEvent).setName(string);
        return true;
    }

    @Override
    protected boolean deleteAction() {
        this.getEventList().remove(this.targetEvent);
        return true;
    }
}

