/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui.editor;

import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.midi.MabiDLS;
import jp.fourthline.mabiicco.ui.IMMLManager;
import jp.fourthline.mabiicco.ui.UIUtils;
import jp.fourthline.mabiicco.ui.editor.AbstractNumberDialogAction;
import jp.fourthline.mabiicco.ui.editor.RangeMode;
import jp.fourthline.mmlTools.MMLEventList;
import jp.fourthline.mmlTools.MMLTrack;

public final class MMLTranspose
extends AbstractNumberDialogAction {
    private static int selectedIndex = 0;
    private static final List<RangeMode> modeList;
    private final List<JRadioButton> buttons = new ArrayList<JRadioButton>();
    private final IMMLManager mmlManager;

    public MMLTranspose(Frame frame, IMMLManager iMMLManager) {
        super(frame, AppResource.appText("edit.transpose"), AppResource.appText("edit.transpose.text"), 0, -12, 12, 1);
        this.mmlManager = iMMLManager;
        JPanel jPanel = UIUtils.createTitledPanel("edit.transpose.range", null);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        ButtonGroup buttonGroup = new ButtonGroup();
        for (RangeMode rangeMode : modeList) {
            JRadioButton jRadioButton = new JRadioButton(AppResource.appText(rangeMode.getButtonName()));
            jPanel.add(jRadioButton);
            buttonGroup.add(jRadioButton);
            this.buttons.add(jRadioButton);
            jRadioButton.addActionListener(actionEvent -> {
                int n;
                selectedIndex = n = this.buttons.indexOf(actionEvent.getSource());
            });
        }
        this.buttons.get(selectedIndex).setSelected(true);
        this.cPanel.add((Component)jPanel, "South");
    }

    @Override
    public void apply(int n) {
        if (n == 0) {
            return;
        }
        RangeMode rangeMode = modeList.get(selectedIndex);
        rangeMode.action(this.mmlManager, (n2, n3) -> {
            MMLTrack mMLTrack = this.mmlManager.getMMLScore().getTrack(n2);
            if (MabiDLS.getInstance().getInstByProgram(mMLTrack.getProgram()).getType().allowTranspose()) {
                MMLEventList mMLEventList = mMLTrack.getMMLEventAtIndex(n3);
                mMLEventList.transpose(n);
            }
        });
        this.mmlManager.updateActivePart(true);
    }

    static {
        List<RangeMode> list = Arrays.asList(RangeMode.values());
        Collections.reverse(list);
        modeList = list;
    }
}

