/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui.editor;

import java.awt.Cursor;
import java.awt.Frame;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import jp.fourthline.mabiicco.ActionDispatcher;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.IEditState;
import jp.fourthline.mabiicco.IEditStateObserver;
import jp.fourthline.mabiicco.midi.IPlayNote;
import jp.fourthline.mabiicco.midi.MabiDLS;
import jp.fourthline.mabiicco.ui.IMMLManager;
import jp.fourthline.mabiicco.ui.PianoRollView;
import jp.fourthline.mabiicco.ui.editor.EditMode;
import jp.fourthline.mabiicco.ui.editor.EditTool;
import jp.fourthline.mabiicco.ui.editor.EditorAction;
import jp.fourthline.mabiicco.ui.editor.IEditAlign;
import jp.fourthline.mabiicco.ui.editor.IEditContext;
import jp.fourthline.mabiicco.ui.editor.MMLNotePropertyPanel;
import jp.fourthline.mabiicco.ui.editor.VelocityChangeMenu;
import jp.fourthline.mmlTools.MMLEvent;
import jp.fourthline.mmlTools.MMLEventList;
import jp.fourthline.mmlTools.MMLExceptionList;
import jp.fourthline.mmlTools.MMLNoteEvent;
import jp.fourthline.mmlTools.MMLTrack;

public final class MMLEditor
implements MouseInputListener,
IEditState,
IEditContext,
IEditAlign {
    private EditMode editMode = EditMode.SELECT;
    private final ArrayList<MMLNoteEvent> selectedNote = new ArrayList();
    private final ArrayList<MMLNoteEvent> detachedNote = new ArrayList();
    private int editAlign = 48;
    private IEditStateObserver editObserver;
    private final PianoRollView pianoRollView;
    private final IPlayNote notePlayer;
    private final IMMLManager mmlManager;
    private final JPopupMenu popupMenu = new JPopupMenu();
    private final VelocityChangeMenu velocityChangeMenu;
    private final JMenuItem createTupletMenu;
    private final Frame parentFrame;
    private final EditorAction editorAction;
    private static final String MMLEVENT_PREFIX = "MMLEVENT@";
    private MMLNoteEvent popupTargetNote;

    @Override
    public void changeEditTool(EditTool editTool) {
        this.changeState(editTool.getEditMode());
        this.setCursor(editTool.getCursor());
    }

    public MMLEditor(Frame frame, IPlayNote iPlayNote, PianoRollView pianoRollView, IMMLManager iMMLManager) {
        this.notePlayer = iPlayNote;
        this.pianoRollView = pianoRollView;
        this.mmlManager = iMMLManager;
        this.parentFrame = frame;
        this.editorAction = new EditorAction(this, iMMLManager, pianoRollView, iPlayNote, this::tickAlign);
        pianoRollView.setSelectNote(this.selectedNote);
        pianoRollView.addMouseInputListener(this);
        this.editMode.enter(this);
        this.velocityChangeMenu = new VelocityChangeMenu(this.popupMenu, () -> this.popupTargetNote.getVelocity(), n -> {
            iMMLManager.getActiveMMLPart().setVelocityCommand(this.popupTargetNote, (int)n);
            iMMLManager.generateActiveTrack();
        }, n -> {
            for (MMLNoteEvent mMLNoteEvent : this.selectedNote) {
                mMLNoteEvent.setVelocity((int)n);
            }
            iMMLManager.generateActiveTrack();
        });
        this.newPopupMenu(AppResource.appText("part_change"), "part_change");
        this.popupMenu.add(new JSeparator());
        this.newPopupMenu(AppResource.appText("edit.select_previous_all"), "select_previous_all");
        this.newPopupMenu(AppResource.appText("edit.select_after_all"), "select_after_all");
        this.newPopupMenu(AppResource.appText("edit.select_all_same_pitch"), "select_all_same_pitch");
        this.popupMenu.add(new JSeparator());
        this.newPopupMenu(AppResource.appText("edit.set_temp_mute"), "set_temp_mute");
        this.newPopupMenu(AppResource.appText("edit.unset_temp_mute"), "unset_temp_mute");
        this.newPopupMenu(AppResource.appText("edit.unset_temp_mute_all"), "unset_temp_mute_all");
        this.popupMenu.add(new JSeparator());
        this.createTupletMenu = this.newPopupMenu(AppResource.appText("edit.convert_tuplet"), "convert_tuplet");
        this.newPopupMenu(AppResource.appText("menu.delete"), "delete", AppResource.appText("menu.delete.icon"));
        this.newPopupMenu(AppResource.appText("note.properties"), "note_property");
        ActionDispatcher.getInstance().addUpdateUIComponent(this.popupMenu);
    }

    public void setEditAlign(int n) {
        this.editAlign = n;
    }

    @Override
    public int getEditAlign() {
        return this.editAlign;
    }

    private long tickAlign(long l) {
        int n;
        int n2;
        MMLTrack mMLTrack = this.mmlManager.getActiveTrack();
        int n3 = mMLTrack.getStartOffset(n2 = this.mmlManager.getActiveMMLPartIndex());
        if (n3 <= (n = mMLTrack.getCommonStartOffset()) && l >= (long)n) {
            n3 = n;
        }
        return l - (l - (long)n3) % (long)this.editAlign;
    }

    public void reset() {
        this.selectNote(null);
        if (this.editObserver != null) {
            this.editObserver.notifyUpdateEditState();
        }
    }

    public boolean selectNote(MMLNoteEvent mMLNoteEvent) {
        return this.selectNote(mMLNoteEvent, false);
    }

    private boolean selectNote(MMLNoteEvent mMLNoteEvent, boolean bl) {
        if (mMLNoteEvent == null) {
            this.selectedNote.clear();
        } else if (!bl) {
            if (!this.selectedNote.contains(mMLNoteEvent)) {
                this.selectedNote.clear();
                this.selectedNote.add(mMLNoteEvent);
            }
        } else {
            if (!this.selectedNote.contains(mMLNoteEvent)) {
                this.selectedNote.add(mMLNoteEvent);
            } else {
                this.selectedNote.remove(mMLNoteEvent);
            }
            return false;
        }
        return true;
    }

    private void selectMultipleNote(MMLNoteEvent mMLNoteEvent, MMLNoteEvent mMLNoteEvent2, boolean bl, boolean bl2) {
        int[] nArray = new int[]{mMLNoteEvent.getNote(), mMLNoteEvent2.getNote()};
        int[] nArray2 = new int[]{mMLNoteEvent.getTickOffset(), mMLNoteEvent2.getTickOffset()};
        Arrays.sort(nArray);
        Arrays.sort(nArray2);
        if (!bl) {
            nArray[0] = 0;
            nArray[1] = 108;
        }
        this.selectedNote.clear();
        MMLEventList mMLEventList = this.mmlManager.getActiveMMLPart();
        if (mMLEventList == null) {
            return;
        }
        for (MMLNoteEvent mMLNoteEvent3 : mMLEventList.getMMLNoteEventList()) {
            if (mMLNoteEvent3.getNote() >= nArray[0] && mMLNoteEvent3.getNote() <= nArray[1] && mMLNoteEvent3.getEndTick() > nArray2[0] && mMLNoteEvent3.getTickOffset() <= nArray2[1]) {
                if (bl2 && this.detachedNote.contains(mMLNoteEvent3)) continue;
                this.selectedNote.add(mMLNoteEvent3);
                continue;
            }
            if (!this.detachedNote.contains(mMLNoteEvent3)) continue;
            this.selectedNote.add(mMLNoteEvent3);
        }
    }

    private MMLNoteEvent pointToNote(Point point) {
        if (point != null) {
            if (point.y > this.pianoRollView.getTotalHeight()) {
                return null;
            }
            MMLEventList mMLEventList = this.mmlManager.getActiveMMLPart();
            if (mMLEventList == null) {
                return null;
            }
            int n = this.pianoRollView.convertY2Note(point.y);
            long l = this.pianoRollView.convertXtoTick(point.x);
            MMLNoteEvent mMLNoteEvent = mMLEventList.searchOnTickOffset(l);
            if (mMLNoteEvent != null && mMLNoteEvent.getNote() == n) {
                return mMLNoteEvent;
            }
        }
        return null;
    }

    @Override
    public boolean selectNoteByPoint(Point point, int n) {
        if (point == null) {
            return this.selectNote(null);
        }
        MMLNoteEvent mMLNoteEvent = this.pointToNote(point);
        if (mMLNoteEvent == null) {
            return true;
        }
        if (this.selectedNote.size() == 1 && (n & 0x40) != 0) {
            this.selectMultipleNote(this.selectedNote.get(0), mMLNoteEvent, false, false);
            return false;
        }
        return this.selectNote(mMLNoteEvent, (n & 0x80) != 0);
    }

    @Override
    public void newMMLNoteAndSelected(Point point) {
        this.editorAction.newNoteAction(point);
    }

    @Override
    public void updateSelectedNoteAndTick(Point point, boolean bl, boolean bl2) {
        if (this.selectedNote.size() <= 0) {
            return;
        }
        this.pianoRollView.onViewScrollPoint(point);
        MMLNoteEvent mMLNoteEvent = this.selectedNote.get(0);
        int n = this.pianoRollView.convertY2Note(point.y);
        long l = this.pianoRollView.convertXtoTick(point.x);
        long l2 = bl2 ? this.tickAlign(l + (long)this.editAlign) : l;
        long l3 = l2 - (long)mMLNoteEvent.getTickOffset();
        if (l3 < 0L) {
            l3 = 0L;
        }
        if (bl) {
            mMLNoteEvent.setNote(n);
        }
        mMLNoteEvent.setTick((int)l3);
        this.pianoRollView.setPaintNoteInfo(!bl2 ? mMLNoteEvent : null);
        this.notePlayer.playNote(mMLNoteEvent.getNote(), mMLNoteEvent.getVelocity());
    }

    @Override
    public void detachSelectedMMLNote() {
        this.detachedNote.clear();
        for (MMLNoteEvent mMLNoteEvent : this.selectedNote) {
            this.detachedNote.add(mMLNoteEvent.clone());
        }
    }

    @Override
    public void moveSelectedMMLNote(Point point, Point point2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        long l;
        int n = this.mmlManager.getActiveMMLPartStartOffset();
        this.pianoRollView.onViewScrollPoint(point2);
        long l2 = this.pianoRollView.convertXtoTick(point.x);
        long l3 = this.pianoRollView.convertXtoTick(point2.x);
        int n2 = this.pianoRollView.convertY2Note(point.y);
        int n3 = this.pianoRollView.convertY2Note(point2.y) - n2;
        long l4 = l = l3 - l2;
        if (bl) {
            l4 = 0L;
            if (bl3) {
                n3 += n3 >= 0 ? 5 : -5;
                n3 -= n3 % 12;
            }
        } else if (bl2) {
            l4 -= l % (long)this.editAlign;
        } else {
            System.out.print("");
        }
        if ((long)this.detachedNote.get(0).getTickOffset() + l4 < (long)n) {
            l4 = n - this.detachedNote.get(0).getTickOffset();
        }
        int n4 = this.detachedNote.get(0).getVelocity();
        for (int i = 0; i < this.selectedNote.size(); ++i) {
            MMLNoteEvent mMLNoteEvent = this.detachedNote.get(i);
            MMLNoteEvent mMLNoteEvent2 = this.selectedNote.get(i);
            mMLNoteEvent2.setNote(mMLNoteEvent.getNote() + n3);
            mMLNoteEvent2.setTickOffset(mMLNoteEvent.getTickOffset() + (int)l4);
            if ((long)mMLNoteEvent.getTickOffset() > l2 || (long)mMLNoteEvent.getEndTick() <= l2) continue;
            n4 = mMLNoteEvent2.getVelocity();
            this.pianoRollView.setPaintNoteInfo(bl4 ? mMLNoteEvent2 : null);
        }
        this.notePlayer.playNote(n2 + n3, n4);
    }

    @Override
    public void editLengthSelectedMMLNote(Point point, Point point2, boolean bl) {
        if (this.selectedNote.size() == 1) {
            this.updateSelectedNoteAndTick(point2, false, bl);
        } else {
            this.editorAction.editLengthAction(point, point2, bl, this.selectedNote, this.detachedNote);
        }
    }

    @Override
    public void cancelEdit() {
        int n = 0;
        for (MMLNoteEvent mMLNoteEvent : this.selectedNote) {
            MMLNoteEvent mMLNoteEvent2 = this.detachedNote.get(n++);
            mMLNoteEvent.setNote(mMLNoteEvent2.getNote());
            mMLNoteEvent.setTickOffset(mMLNoteEvent2.getTickOffset());
            mMLNoteEvent.setTick(mMLNoteEvent2.getTick());
        }
        this.detachedNote.clear();
    }

    @Override
    public void applyEditNote(boolean bl) {
        MMLEventList mMLEventList = this.mmlManager.getActiveMMLPart();
        if (mMLEventList == null) {
            return;
        }
        this.selectedNote.forEach(mMLNoteEvent -> mMLEventList.deleteMMLEvent((MMLEvent)mMLNoteEvent));
        this.selectedNote.forEach(mMLNoteEvent -> mMLEventList.addMMLNoteEvent((MMLNoteEvent)mMLNoteEvent));
        if (!bl) {
            this.selectNote(null);
        }
        this.notePlayer.offNote();
        this.mmlManager.generateActiveTrack();
    }

    @Override
    public void setCursor(Cursor cursor) {
        this.pianoRollView.setCursor(cursor);
    }

    @Override
    public void areaSelectingAction(Point point, Point point2) {
        int n;
        int n2;
        int n3 = point.x;
        int n4 = point2.x;
        if (n3 > n4) {
            n4 = point.x;
            n3 = point2.x;
        }
        if ((n2 = point.y) > (n = Math.min(point2.y, this.pianoRollView.getTotalHeight()))) {
            n = point.y;
            n2 = point2.y;
        }
        Rectangle rectangle = new Rectangle(n3, n2, n4 - n3, n - n2);
        this.pianoRollView.setSelectingArea(rectangle);
        int n5 = this.pianoRollView.convertY2Note(n2);
        int n6 = (int)this.pianoRollView.convertXtoTick(n3);
        int n7 = this.pianoRollView.convertY2Note(n);
        int n8 = (int)this.pianoRollView.convertXtoTick(n4);
        this.selectMultipleNote(new MMLNoteEvent(n5, 0, n6, 0), new MMLNoteEvent(n7, 0, n8, 0), true, true);
    }

    @Override
    public void applyAreaSelect() {
        this.pianoRollView.setSelectingArea(null);
    }

    @Override
    public boolean onExistNote(Point point) {
        return this.pointToNote(point) != null;
    }

    @Override
    public boolean selectTrackOnExistNote(Point point) {
        if (this.onExistNote(point)) {
            return false;
        }
        int n = this.pianoRollView.convertY2Note(point.y);
        int n2 = (int)this.pianoRollView.convertXtoTick(point.x);
        return this.mmlManager.selectTrackOnExistNote(n, n2);
    }

    @Override
    public boolean isEditLengthPosition(Point point) {
        int n = this.pianoRollView.convertY2Note(point.y);
        int n2 = (int)this.pianoRollView.convertXtoTick(point.x);
        MMLEventList mMLEventList = this.mmlManager.getActiveMMLPart();
        if (mMLEventList == null) {
            return false;
        }
        MMLNoteEvent mMLNoteEvent = mMLEventList.searchOnTickOffset(n2);
        if (mMLNoteEvent != null && mMLNoteEvent.getNote() == n) {
            return mMLNoteEvent.getEndTick() <= n2 + mMLNoteEvent.getTick() / 5;
        }
        return false;
    }

    @Override
    public EditMode changeState(EditMode editMode) {
        if (this.editMode != editMode) {
            this.editMode.exit(this);
            this.editMode = editMode;
            this.editMode.enter(this);
        }
        return editMode;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
            this.noteProperty();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getY() > this.pianoRollView.getTotalHeight()) {
            return;
        }
        this.editMode.pressEvent(this, mouseEvent);
        this.pianoRollView.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.editMode.releaseEvent(this, mouseEvent);
        this.pianoRollView.setPaintNoteInfo(null);
        this.pianoRollView.repaint();
        this.editObserver.notifyUpdateEditState();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.editMode.executeEvent(this, mouseEvent);
        this.pianoRollView.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.editMode.executeEvent(this, mouseEvent);
    }

    @Override
    public boolean hasSelectedNote() {
        return !this.selectedNote.isEmpty();
    }

    @Override
    public boolean isSelectedNote(MMLNoteEvent mMLNoteEvent) {
        return this.selectedNote.contains(mMLNoteEvent);
    }

    @Override
    public boolean hasSelectedMultipleConsecutiveNotes() {
        if (this.selectedNote.size() >= 2) {
            List<MMLNoteEvent> list = this.mmlManager.getActiveMMLPart().getMMLNoteEventList();
            int n = 0;
            for (int i = 0; i < this.selectedNote.size() - 1; ++i) {
                while (n < list.size() - 1 && list.get(n) != this.selectedNote.get(i)) {
                    ++n;
                }
                if (n >= list.size() - 1 || !list.get(n + 1).equals(this.selectedNote.get(i + 1))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void removeRestsBetweenNotes() {
        List<MMLNoteEvent> list = this.mmlManager.getActiveMMLPart().getMMLNoteEventList();
        int n = 0;
        for (int i = 0; i < this.selectedNote.size() - 1; ++i) {
            while (n < list.size() - 1 && list.get(n) != this.selectedNote.get(i)) {
                ++n;
            }
            if (n >= list.size() - 1 || !list.get(n + 1).equals(this.selectedNote.get(i + 1))) continue;
            MMLNoteEvent mMLNoteEvent = list.get(n);
            mMLNoteEvent.setTick(list.get(n + 1).getTickOffset() - mMLNoteEvent.getTickOffset());
        }
        this.selectNote(null);
        this.editObserver.notifyUpdateEditState();
        this.mmlManager.generateActiveTrack();
    }

    private void selectedNoteUpDown(int n) {
        MMLEventList mMLEventList = this.mmlManager.getActiveMMLPart();
        if (mMLEventList == null) {
            return;
        }
        for (MMLNoteEvent mMLNoteEvent2 : this.selectedNote) {
            int n2 = mMLNoteEvent2.getNote() + n;
            if (n2 >= -1 && n2 < 108) continue;
            return;
        }
        this.selectedNote.forEach(mMLNoteEvent -> mMLNoteEvent.setNote(mMLNoteEvent.getNote() + n));
        this.mmlManager.updateActivePart(true);
    }

    @Override
    public void octaveUp() {
        this.selectedNoteUpDown(12);
    }

    @Override
    public void octaveDown() {
        this.selectedNoteUpDown(-12);
    }

    @Override
    public void setEditStateObserver(IEditStateObserver iEditStateObserver) {
        this.editObserver = iEditStateObserver;
    }

    private MMLEventList fromClipBoard() {
        MMLEventList mMLEventList = null;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            String string = (String)clipboard.getData(DataFlavor.stringFlavor);
            if (string != null && string.startsWith(MMLEVENT_PREFIX)) {
                mMLEventList = new MMLEventList(string.substring(MMLEVENT_PREFIX.length()));
            }
        }
        catch (UnsupportedFlavorException | IOException exception) {
            // empty catch block
        }
        return mMLEventList;
    }

    private void toClipBoard(MMLEventList mMLEventList) {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(MMLEVENT_PREFIX + mMLEventList.getInternalMMLString());
            clipboard.setContents(stringSelection, stringSelection);
        }
        catch (MMLExceptionList mMLExceptionList) {
            // empty catch block
        }
    }

    @Override
    public boolean canPaste() {
        MMLEventList mMLEventList = this.fromClipBoard();
        if (mMLEventList == null) {
            return false;
        }
        return mMLEventList.getMMLNoteEventList().size() != 0;
    }

    @Override
    public void paste(long l) {
        if (!this.canPaste()) {
            return;
        }
        MMLEventList mMLEventList = this.mmlManager.getActiveMMLPart();
        if (mMLEventList == null) {
            return;
        }
        this.selectNote(null);
        MMLEventList mMLEventList2 = this.fromClipBoard();
        int n = (int)(l - (long)mMLEventList2.getMMLNoteEventList().get(0).getTickOffset());
        for (MMLNoteEvent mMLNoteEvent : mMLEventList2.getMMLNoteEventList()) {
            MMLNoteEvent mMLNoteEvent2 = mMLNoteEvent.clone();
            mMLNoteEvent2.setTickOffset(mMLNoteEvent.getTickOffset() + n);
            mMLEventList.addMMLNoteEvent(mMLNoteEvent2);
            this.selectNote(mMLNoteEvent2, true);
        }
        this.editObserver.notifyUpdateEditState();
        this.mmlManager.updateActivePart(true);
    }

    @Override
    public void selectedCut() {
        MMLEventList mMLEventList = this.mmlManager.getActiveMMLPart();
        if (mMLEventList == null) {
            return;
        }
        MMLEventList mMLEventList2 = new MMLEventList("");
        for (MMLNoteEvent mMLNoteEvent : this.selectedNote) {
            mMLEventList2.addMMLNoteEvent(mMLNoteEvent);
            mMLEventList.deleteMMLEvent(mMLNoteEvent);
        }
        this.toClipBoard(mMLEventList2);
        this.selectNote(null);
        this.editObserver.notifyUpdateEditState();
        this.mmlManager.updateActivePart(true);
    }

    @Override
    public void selectedCopy() {
        MMLEventList mMLEventList = new MMLEventList("");
        for (MMLNoteEvent mMLNoteEvent : this.selectedNote) {
            mMLEventList.addMMLNoteEvent(mMLNoteEvent);
        }
        this.toClipBoard(mMLEventList);
        this.editObserver.notifyUpdateEditState();
    }

    @Override
    public void selectedDelete() {
        MMLEventList mMLEventList = this.mmlManager.getActiveMMLPart();
        if (mMLEventList == null) {
            return;
        }
        for (MMLNoteEvent mMLNoteEvent : this.selectedNote) {
            mMLEventList.deleteMMLEvent(mMLNoteEvent);
        }
        this.selectNote(null);
        this.editObserver.notifyUpdateEditState();
        this.mmlManager.updateActivePart(true);
    }

    @Override
    public void noteProperty() {
        if (this.selectedNote.isEmpty()) {
            return;
        }
        MMLEventList mMLEventList = this.mmlManager.getActiveMMLPart();
        if (mMLEventList != null) {
            new MMLNotePropertyPanel(this.selectedNote.toArray(new MMLNoteEvent[this.selectedNote.size()]), mMLEventList).showDialog(this.parentFrame);
            this.mmlManager.generateActiveTrack();
        }
    }

    @Override
    public void selectAll() {
        MMLEventList mMLEventList = this.mmlManager.getActiveMMLPart();
        if (mMLEventList != null) {
            this.selectedNote.clear();
            this.selectedNote.addAll(mMLEventList.getMMLNoteEventList());
        }
    }

    @Override
    public void selectPreviousAll() {
        MMLEventList mMLEventList = this.mmlManager.getActiveMMLPart();
        if (mMLEventList != null) {
            this.selectedNote.clear();
            for (MMLNoteEvent mMLNoteEvent : mMLEventList.getMMLNoteEventList()) {
                if (mMLNoteEvent.getTickOffset() > this.popupTargetNote.getTickOffset()) break;
                this.selectedNote.add(mMLNoteEvent);
            }
        }
    }

    @Override
    public void selectAfterAll() {
        MMLEventList mMLEventList = this.mmlManager.getActiveMMLPart();
        if (mMLEventList != null) {
            this.selectedNote.clear();
            for (MMLNoteEvent mMLNoteEvent : mMLEventList.getMMLNoteEventList()) {
                if (mMLNoteEvent.getTickOffset() < this.popupTargetNote.getTickOffset()) continue;
                this.selectedNote.add(mMLNoteEvent);
            }
        }
    }

    @Override
    public void selectAllSamePitch() {
        MMLEventList mMLEventList = this.mmlManager.getActiveMMLPart();
        if (mMLEventList != null) {
            this.selectedNote.clear();
            for (MMLNoteEvent mMLNoteEvent : mMLEventList.getMMLNoteEventList()) {
                if (mMLNoteEvent.getNote() != this.popupTargetNote.getNote()) continue;
                this.selectedNote.add(mMLNoteEvent);
            }
        }
    }

    @Override
    public void setTempMute(boolean bl) {
        for (MMLNoteEvent mMLNoteEvent : this.selectedNote) {
            mMLNoteEvent.setMute(bl);
        }
        this.pianoRollView.repaint();
    }

    @Override
    public void setTempMuteAll() {
        for (MMLTrack mMLTrack : this.mmlManager.getMMLScore().getTrackList()) {
            for (MMLEventList mMLEventList : mMLTrack.getMMLEventList()) {
                for (MMLNoteEvent mMLNoteEvent : mMLEventList.getMMLNoteEventList()) {
                    mMLNoteEvent.setMute(false);
                }
            }
        }
        this.pianoRollView.repaint();
    }

    @Override
    public void convertTuplet() {
        MMLEventList mMLEventList = this.mmlManager.getActiveMMLPart();
        if (mMLEventList == null) {
            return;
        }
        int n = this.selectedNote.size();
        if (n < 3) {
            return;
        }
        this.selectedNote.sort(Comparator.comparingInt(mMLNoteEvent -> mMLNoteEvent.getTickOffset()));
        int n2 = this.selectedNote.get(0).getTickOffset();
        int n3 = this.selectedNote.get(n - 1).getEndTick() - n2;
        for (MMLNoteEvent mMLNoteEvent2 : this.selectedNote) {
            mMLEventList.deleteMMLEvent(mMLNoteEvent2);
        }
        for (int i = 0; i < n; ++i) {
            MMLNoteEvent mMLNoteEvent2;
            mMLNoteEvent2 = this.selectedNote.get(i);
            int n4 = n3 * i / n;
            int n5 = n3 * (i + 1) / n;
            mMLNoteEvent2.setTickOffset(n4 + n2);
            mMLNoteEvent2.setTick(n5 - n4);
            mMLEventList.addMMLNoteEvent(mMLNoteEvent2);
        }
        this.selectNote(null);
        this.editObserver.notifyUpdateEditState();
        this.mmlManager.updateActivePart(true);
    }

    public TickRange selectedRange(MMLEventList mMLEventList, MMLEventList mMLEventList2) {
        if (this.selectedNote.size() == 0) {
            return null;
        }
        MMLNoteEvent mMLNoteEvent2 = this.selectedNote.stream().min(Comparator.comparingInt(mMLNoteEvent -> mMLNoteEvent.getTickOffset())).get();
        MMLNoteEvent mMLNoteEvent3 = this.selectedNote.stream().max(Comparator.comparingInt(mMLNoteEvent -> mMLNoteEvent.getEndTick())).get();
        int n = mMLEventList.getAlignmentStartTick(mMLEventList2, mMLNoteEvent2.getTickOffset());
        int n2 = mMLEventList.getAlignmentEndTick(mMLEventList2, mMLNoteEvent3.getEndTick());
        return new TickRange(n, n2);
    }

    public void changePart(MMLEventList mMLEventList, MMLEventList mMLEventList2, boolean bl, ChangePartAction changePartAction) {
        int n;
        int n2 = 0;
        if (bl && this.selectedNote.size() > 0) {
            TickRange tickRange = this.selectedRange(mMLEventList, mMLEventList2);
            n2 = tickRange.start();
            n = tickRange.end();
        } else {
            int n3;
            n = (int)mMLEventList.getTickLength();
            if (n < (n3 = (int)mMLEventList2.getTickLength())) {
                n = n3;
            }
        }
        switch (changePartAction) {
            case SWAP: {
                mMLEventList.swap(mMLEventList2, n2, n);
                break;
            }
            case MOVE: {
                mMLEventList.move(mMLEventList2, n2, n);
                break;
            }
            case COPY: {
                mMLEventList.copy(mMLEventList2, n2, n);
                break;
            }
        }
    }

    private JMenuItem newPopupMenu(String string, String string2) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(ActionDispatcher.getInstance());
        jMenuItem.setActionCommand(string2);
        this.popupMenu.add(jMenuItem);
        return jMenuItem;
    }

    private JMenuItem newPopupMenu(String string, String string2, String string3) {
        JMenuItem jMenuItem = this.newPopupMenu(string, string2);
        try {
            jMenuItem.setIcon(AppResource.getImageIcon(string3));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return jMenuItem;
    }

    @Override
    public void showPopupMenu(Point point) {
        if (MabiDLS.getInstance().getSequencer().isRecording()) {
            return;
        }
        int n = (int)this.pianoRollView.convertXtoTick(point.x);
        MMLEventList mMLEventList = this.mmlManager.getActiveMMLPart();
        if (mMLEventList == null) {
            return;
        }
        this.popupTargetNote = mMLEventList.searchOnTickOffset(n);
        this.velocityChangeMenu.setValue(this.popupTargetNote.getVelocity());
        this.createTupletMenu.setEnabled(this.selectedNote.size() >= 3);
        if (this.hasSelectedNote()) {
            try {
                this.popupMenu.show(this.pianoRollView, point.x, point.y);
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean canEditStartOffset(Point point) {
        int n;
        int n2 = this.mmlManager.getActiveMMLPartStartOffset();
        return n2 <= (n = (int)this.pianoRollView.convertXtoTick(point.x));
    }

    @Override
    public void notesModifyVelocity(Point point, boolean bl) {
        MMLNoteEvent mMLNoteEvent2 = this.pointToNote(point);
        if (!this.selectedNote.isEmpty()) {
            this.selectedNote.forEach(mMLNoteEvent -> mMLNoteEvent.modifyVelocity(bl));
            this.mmlManager.updateActivePart(true);
        } else if (mMLNoteEvent2 != null) {
            mMLNoteEvent2.modifyVelocity(bl);
            this.mmlManager.updateActivePart(true);
        }
    }

    @Override
    public void glueAction(Point point) {
        this.editorAction.glueAction(point);
    }

    @Override
    public void splitAction(Point point) {
        this.editorAction.splitAction(point);
    }

    public record TickRange(int start, int end) {
    }

    public static enum ChangePartAction {
        SWAP,
        MOVE,
        COPY;

    }
}

