/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui.editor;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.ui.IMMLManager;
import jp.fourthline.mabiicco.ui.IViewTargetMarker;
import jp.fourthline.mabiicco.ui.editor.AbstractColumnEditor;
import jp.fourthline.mmlTools.BarLineType;
import jp.fourthline.mmlTools.MMLScore;
import jp.fourthline.mmlTools.Measure;
import jp.fourthline.mmlTools.TimeSignature;

public final class BarLineEditor
extends AbstractColumnEditor {
    private final Frame parentFrame;
    private final IMMLManager mmlManager;
    private final IViewTargetMarker viewTargetMarker;
    private final JMenu setTypeMenu;
    private int targetMeasure;
    private final Map<JRadioButtonMenuItem, BarLineType> menuMap = new HashMap<JRadioButtonMenuItem, BarLineType>();
    private static final String MENU_PREFIX = "edit.barLine_";

    public BarLineEditor(Frame frame, IMMLManager iMMLManager, IViewTargetMarker iViewTargetMarker) {
        this.parentFrame = frame;
        this.mmlManager = iMMLManager;
        this.viewTargetMarker = iViewTargetMarker;
        this.setTypeMenu = this.newMenu(AppResource.appText("edit.set_barLine_type"), JMenu::new);
        ButtonGroup buttonGroup = new ButtonGroup();
        for (BarLineType barLineType : BarLineType.values()) {
            this.newRadioMenu(buttonGroup, barLineType);
        }
    }

    private void newRadioMenu(ButtonGroup buttonGroup, BarLineType barLineType) {
        String string = MENU_PREFIX + barLineType.name().toLowerCase();
        JRadioButtonMenuItem jRadioButtonMenuItem = this.newMenu(AppResource.appText(string), JRadioButtonMenuItem::new);
        buttonGroup.add(jRadioButtonMenuItem);
        this.setTypeMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem.addActionListener(this);
        this.menuMap.put(jRadioButtonMenuItem, barLineType);
    }

    @Override
    public List<JMenuItem> getMenuItems() {
        return Arrays.asList(this.setTypeMenu);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        MMLScore mMLScore = this.mmlManager.getMMLScore();
        Object object = actionEvent.getSource();
        BarLineType barLineType = this.menuMap.get(object);
        if (barLineType != null) {
            mMLScore.setBarLineType(this.targetMeasure, barLineType);
            this.mmlManager.updateActivePart(true);
            this.parentFrame.repaint();
        }
    }

    @Override
    public void activateEditMenuItem(int n, int n2) {
        this.targetMeasure = new Measure(this.mmlManager.getMMLScore(), n).getMeasure();
        BarLineType barLineType = this.mmlManager.getMMLScore().getBarLineTypeMap().getOrDefault(this.targetMeasure, BarLineType.NORMAL);
        this.menuMap.forEach((jRadioButtonMenuItem, barLineType2) -> jRadioButtonMenuItem.setSelected(barLineType2 == barLineType));
    }

    @Override
    protected void viewTargetMarker(AbstractButton abstractButton, boolean bl) {
        if (bl) {
            int n = TimeSignature.measureToTick(this.mmlManager.getMMLScore(), this.targetMeasure);
            this.viewTargetMarker.PaintOnTarget(n);
        } else {
            this.viewTargetMarker.PaintOff();
        }
    }
}

