/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.event.MouseInputListener;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.MabiIccoProperties;
import jp.fourthline.mabiicco.midi.InstClass;
import jp.fourthline.mabiicco.midi.MabiDLS;
import jp.fourthline.mabiicco.ui.IMMLManager;
import jp.fourthline.mabiicco.ui.SettingButtonGroupItem;
import jp.fourthline.mabiicco.ui.UIUtils;
import jp.fourthline.mabiicco.ui.color.ColorManager;
import jp.fourthline.mabiicco.ui.color.ColorSet;
import jp.fourthline.mabiicco.ui.color.ScaleColor;
import jp.fourthline.mmlTools.BarLineType;
import jp.fourthline.mmlTools.MMLEventList;
import jp.fourthline.mmlTools.MMLNoteEvent;
import jp.fourthline.mmlTools.MMLScore;
import jp.fourthline.mmlTools.MMLTrack;
import jp.fourthline.mmlTools.Measure;
import jp.fourthline.mmlTools.TimeSignature;
import jp.fourthline.mmlTools.core.MMLException;
import jp.fourthline.mmlTools.core.MMLTicks;

public final class PianoRollView
extends JPanel {
    private static final long serialVersionUID = -7229093886476553295L;
    public static final int OCTNUM = 9;
    private NoteHeight noteHeight = NoteHeight.H10;
    private double wideScale = 6.0;
    private JViewport viewport;
    private IMMLManager mmlManager;
    private long sequencePosition = 0L;
    private long runningSequencePosition = 0L;
    private long startViewTick;
    private long endViewTick;
    private List<MMLNoteEvent> selectNoteList;
    private MMLNoteEvent paintNoteInfo = null;
    private Rectangle selectingRect;
    private InstClass relativeInst;
    private ScaleColor scaleColor = ScaleColor.C_MAJOR;
    private static final Color pitchRangeBorderColor = Color.RED;
    private static final ColorSet noSoundColor = ColorSet.create(new Color(0.9f, 0.8f, 0.8f), new Color(180, 150, 150));
    private static final ColorSet outRangeColor = ColorSet.create(new Color(230, 204, 204), new Color(180, 150, 150));
    private static final ColorSet barBorder = ColorSet.create(new Color(0.5f, 0.5f, 0.5f));
    private static final ColorSet darkBarBorder = ColorSet.create(new Color(0.3f, 0.2f, 0.3f));
    private static final ColorSet shadowColor = ColorSet.create(Color.GRAY, Color.DARK_GRAY);
    private static final ColorSet START_OFFSET_COLOR = ColorSet.create(new Color(0.9f, 0.8f, 0.8f), new Color(180, 150, 150));
    private static final ColorSet seqBarColor = ColorSet.create(Color.RED);
    private static final ColorSet vStrColor = ColorSet.create(Color.DARK_GRAY);
    private static final int DRAW_START_MARGIN = 192;
    private final MabiIccoProperties properties = MabiIccoProperties.getInstance();
    private PaintMode paintMode = PaintMode.ALL_TRACK;
    private boolean showAllVelocity = false;
    private static final float[] dash = new float[]{2.0f, 4.0f};
    private static final BasicStroke dashStroke = new BasicStroke(1.0f, 0, 0, 10.0f, dash, 0.0f);
    private static final BasicStroke boldStroke = new BasicStroke(2.0f);
    private static final BasicStroke dottedStroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{4.0f, 2.0f}, 0.0f);

    public int getNoteHeight() {
        return this.noteHeight.h;
    }

    public void setNoteHeight(NoteHeight noteHeight) {
        this.noteHeight = noteHeight;
    }

    public int getTotalHeight() {
        return 108 * this.noteHeight.h + this.noteHeight.h;
    }

    public void setScaleColor(ScaleColor scaleColor) {
        this.scaleColor = scaleColor;
    }

    public PaintMode getPaintMode() {
        return this.paintMode;
    }

    public void setPaintMode(PaintMode paintMode) {
        this.paintMode = paintMode;
    }

    public PianoRollView() {
        this.setPreferredSize(new Dimension(0, this.getTotalHeight()));
        this.noteHeight = (NoteHeight)this.properties.pianoRollNoteHeight.get();
        this.scaleColor = (ScaleColor)this.properties.scaleColor.get();
        this.setSequenceTick(0L);
    }

    public void addMouseInputListener(MouseInputListener mouseInputListener) {
        this.addMouseListener(mouseInputListener);
        this.addMouseMotionListener(mouseInputListener);
    }

    public void setViewportAndParent(JViewport jViewport, IMMLManager iMMLManager) {
        this.viewport = jViewport;
        this.mmlManager = iMMLManager;
    }

    public void setSelectNote(List<MMLNoteEvent> list) {
        this.selectNoteList = list;
    }

    public void setPaintNoteInfo(MMLNoteEvent mMLNoteEvent) {
        this.paintNoteInfo = mMLNoteEvent;
    }

    public void setSelectingArea(Rectangle rectangle) {
        this.selectingRect = rectangle;
    }

    public int getNewWidth() {
        this.updateViewWidthTrackLength();
        return Math.max(this.getWidth(), this.getPreferredSize().width);
    }

    private void updateViewWidthTrackLength() {
        int n;
        MMLScore mMLScore = this.mmlManager.getMMLScore();
        long l = mMLScore.getTotalTickLengthWithAll();
        long l2 = TimeSignature.measureToTick(mMLScore, mMLScore.getUserViewMeasure());
        try {
            n = MMLTicks.getTick("1");
            l += (long)(n * 12);
            l -= l % (long)n;
            l += (long)this.mmlManager.getActiveMMLPartStartOffset();
        }
        catch (MMLException mMLException) {
            mMLException.printStackTrace();
        }
        n = this.convertTicktoX(l);
        int n2 = this.convertTicktoX(l2);
        if (n < n2) {
            n = n2;
        }
        Dimension dimension = this.getPreferredSize();
        int n3 = this.getTotalHeight();
        if (dimension.width != n || dimension.height != n3) {
            super.setPreferredSize(new Dimension(n, n3));
        }
        this.revalidate();
    }

    public void setWideScale(double d) {
        if (d > 6.0 || d < 0.1) {
            return;
        }
        this.wideScale = d;
        this.updateViewWidthTrackLength();
    }

    public void onViewScrollPoint(Point point) {
        int n = point.y;
        int n2 = this.viewport.getViewPosition().y;
        int n3 = n2 + this.viewport.getHeight() - this.noteHeight.h;
        int n4 = this.viewport.getViewPosition().x;
        if (n4 + this.viewport.getWidth() < point.x) {
            ++n4;
        }
        if (n < n2) {
            if ((n2 -= this.noteHeight.h) < 0) {
                n2 = 0;
            }
            n = n2;
        } else if (n > n3) {
            if ((n2 += this.noteHeight.h) > this.getHeight() - this.viewport.getHeight()) {
                n2 = this.getHeight() - this.viewport.getHeight();
                n = n3;
            } else {
                n = n3 + this.noteHeight.h;
            }
        }
        this.viewport.setViewPosition(new Point(n4, n2));
        point.y = n;
    }

    public double getWideScale() {
        return this.wideScale;
    }

    public long convertXtoTick(int n) {
        return (long)((double)n * this.wideScale);
    }

    public int convertTicktoX(long l) {
        return (int)((double)l / this.wideScale);
    }

    public int convertY2Note(int n) {
        int n2;
        if (n < 0) {
            n = 0;
        }
        if ((n2 = 108 - n / this.noteHeight.h - 1) < -1) {
            n2 = -1;
        }
        return n2;
    }

    public int convertNote2Y(int n) {
        int n2 = 108 - n - 1;
        return n2 *= this.noteHeight.h;
    }

    public long getSequencePosition() {
        return this.sequencePosition;
    }

    public int getSequenceX() {
        return this.convertTicktoX(this.sequencePosition);
    }

    public void updateRunningSequencePosition() {
        this.runningSequencePosition = MabiDLS.getInstance().getSequencer().getTickPosition();
    }

    public long getSequencePlayPosition() {
        long l = this.sequencePosition;
        if (MabiDLS.getInstance().getSequencer().isRunning()) {
            return this.runningSequencePosition;
        }
        return l;
    }

    public void setSequenceTick(long l) {
        if (!MabiDLS.getInstance().getSequencer().isRunning()) {
            if (l < 0L) {
                l = 0L;
            }
            this.sequencePosition = l;
        }
    }

    private void updateViewTick() {
        double d = this.viewport.getViewPosition().getX();
        double d2 = this.viewport.getExtentSize().getWidth();
        this.startViewTick = this.convertXtoTick((int)d);
        this.endViewTick = this.convertXtoTick((int)(d + d2));
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.showAllVelocity = (Boolean)this.properties.showAllVelocity.get();
        this.updateViewTick();
        int n = this.getTotalHeight();
        this.updateViewWidthTrackLength();
        int n2 = this.convertTicktoX(this.mmlManager.getActiveMMLPartStartOffset());
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        UIUtils.setRenderingHint(graphics2D);
        for (int i = 0; i <= 9; ++i) {
            this.paintOctPianoLine(graphics2D, i, n2);
        }
        this.paintMeasure(graphics2D);
        this.paintPitchRangeBorder(graphics2D);
        this.paintOtherTrack(graphics2D);
        this.paintActiveTrack(graphics2D);
        this.paintSelectedNote(graphics2D);
        this.paintNoteInfo(graphics2D);
        this.paintSelectingArea(graphics2D);
        this.paintSequenceLine(graphics2D, n);
        if (n < this.getHeight()) {
            graphics2D.setColor(Color.LIGHT_GRAY);
            graphics2D.fillRect(0, n + 1, this.getWidth(), this.getHeight() - n);
        }
        graphics2D.dispose();
    }

    private void paintOctPianoLine(Graphics2D graphics2D, int n, int n2) {
        int n3 = 12 * this.noteHeight.h * n;
        int n4 = 9 - n - 1;
        int n5 = this.getTotalHeight();
        int n6 = this.getWidth();
        for (int i = 0; i < 12; ++i) {
            int n7 = n3 + i * this.noteHeight.h;
            if (n7 > n5) {
                return;
            }
            int n8 = n4 * 12 + (11 - i);
            Color color = this.scaleColor.getColor(i);
            if (((Boolean)this.properties.enableEdit.get()).booleanValue()) {
                if (((Boolean)this.properties.viewRange.get()).booleanValue() && !this.relativeInst.checkPitchRange(n8)) {
                    color = outRangeColor.get();
                } else if (((Boolean)this.properties.instAttr.get()).booleanValue() && !this.relativeInst.isValid(n8)) {
                    color = noSoundColor.get();
                }
            }
            graphics2D.setColor(color);
            graphics2D.fillRect(0, n7, n6, this.noteHeight.h);
            graphics2D.setColor(START_OFFSET_COLOR.get());
            graphics2D.fillRect(0, n7, n2, this.noteHeight.h);
            if (i == 0) {
                graphics2D.setColor(darkBarBorder.get());
            } else {
                graphics2D.setColor(ScaleColor.BORDER_COLOR);
            }
            graphics2D.drawLine(0, n7, n6, n7);
        }
        graphics2D.setColor(darkBarBorder.get());
        graphics2D.drawLine(0, 12 * this.noteHeight.h + n3, n6, 12 * this.noteHeight.h + n3);
    }

    private void paintPitchRangeBorder(Graphics2D graphics2D) {
        if (((Boolean)this.properties.enableEdit.get()).booleanValue() && ((Boolean)this.properties.viewRange.get()).booleanValue()) {
            int n = this.getWidth();
            int n2 = this.convertNote2Y(this.relativeInst.getLowerNote() - 1);
            int n3 = this.convertNote2Y(this.relativeInst.getUpperNote());
            graphics2D.setColor(pitchRangeBorderColor);
            graphics2D.drawLine(0, n2, n, n2);
            graphics2D.drawLine(0, n3, n, n3);
        }
    }

    void paintSequenceLine(Graphics2D graphics2D, int n) {
        long l = this.getSequencePlayPosition();
        int n2 = this.convertTicktoX(l);
        graphics2D.setColor(seqBarColor.get());
        graphics2D.drawLine(n2, 0, n2, n);
    }

    private void paintHalfMeasure(Graphics2D graphics2D, int n, int n2) {
        int n3;
        int n4 = this.getTotalHeight();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(dashStroke);
        graphics2D.setColor(barBorder.get());
        for (n3 = n2; n3 >= 32; n3 /= 2) {
        }
        for (int i = n + n3; i < n + n2; i += n3) {
            graphics2D.drawLine(i, 0, i, n4);
        }
        graphics2D.setStroke(stroke);
    }

    void drawBarLine(Graphics2D graphics2D, int n, int n2, int n3) {
        Stroke stroke = graphics2D.getStroke();
        BarLineType barLineType = this.mmlManager.getMMLScore().getBarLineTypeMap().get(n);
        if (barLineType != null) {
            switch (barLineType) {
                case BOLD: {
                    graphics2D.setStroke(boldStroke);
                    break;
                }
                case DOTTED: {
                    graphics2D.setStroke(dottedStroke);
                    break;
                }
                case DOUBLE: {
                    graphics2D.drawLine(n2 - 1, 0, n2 - 1, n3);
                    ++n2;
                    break;
                }
                case FINAL: {
                    graphics2D.drawLine(n2 - 2, 0, n2 - 2, n3);
                    ++n2;
                    graphics2D.setStroke(boldStroke);
                    break;
                }
            }
        }
        graphics2D.drawLine(n2, 0, n2, n3);
        graphics2D.setStroke(stroke);
    }

    private void paintMeasure(Graphics2D graphics2D) {
        MMLScore mMLScore = this.mmlManager.getMMLScore();
        int n = 0;
        int n2 = 0;
        int n3 = this.getTotalHeight();
        Measure measure = new Measure(mMLScore, (int)this.startViewTick);
        n2 = measure.measuredTick();
        int n4 = measure.getNumTime();
        int n5 = measure.getBeatTick();
        while ((long)n2 <= this.endViewTick) {
            if ((long)n2 >= this.startViewTick - (long)n5) {
                int n6 = this.convertTicktoX(n2);
                if (n % n4 == 0) {
                    graphics2D.setColor(darkBarBorder.get());
                    this.drawBarLine(graphics2D, measure.getMeasure(), n6, n3);
                } else {
                    graphics2D.setColor(barBorder.get());
                    graphics2D.drawLine(n6, 0, n6, n3);
                }
                this.paintHalfMeasure(graphics2D, n6, this.convertTicktoX(n5));
            }
            n2 += n5;
            if (++n < n4) continue;
            n = 0;
            measure = new Measure(mMLScore, n2);
            n4 = measure.getNumTime();
            n5 = measure.getBeatTick();
        }
    }

    private void drawNote(Graphics2D graphics2D, MMLNoteEvent mMLNoteEvent, Color color, Color color2, boolean bl, MMLNoteEvent mMLNoteEvent2) {
        int n = mMLNoteEvent.getNote();
        int n2 = mMLNoteEvent.getTick();
        int n3 = mMLNoteEvent.getTickOffset();
        int n4 = this.convertTicktoX(n3);
        int n5 = this.convertNote2Y(n) + 1;
        int n6 = this.convertTicktoX(n2) - 1;
        int n7 = this.noteHeight.h - 2;
        if (n6 > 1) {
            --n6;
        }
        if (bl) {
            UIUtils.drawRect(graphics2D, shadowColor.get(), shadowColor.get(), n4 + 2, n5 + 2, n6, n7);
        }
        UIUtils.drawRect(graphics2D, color, color2, n4, n5, n6, n7);
        if (bl) {
            int n8 = mMLNoteEvent.getVelocity();
            if (this.showAllVelocity || mMLNoteEvent2 == null || mMLNoteEvent2.getVelocity() != n8) {
                String string = "V" + n8;
                graphics2D.setColor(vStrColor.get());
                graphics2D.drawString(string, n4, n5);
            }
        }
    }

    public int isValidDrawNote(MMLNoteEvent mMLNoteEvent) {
        if ((long)mMLNoteEvent.getEndTick() < this.startViewTick && (long)mMLNoteEvent.getTickOffset() < this.startViewTick - 192L) {
            return -1;
        }
        if ((long)mMLNoteEvent.getTickOffset() > this.endViewTick) {
            return 1;
        }
        return 0;
    }

    private void paintMMLPart(Graphics2D graphics2D, List<MMLNoteEvent> list, Color color, Color color2, boolean bl) {
        MMLNoteEvent mMLNoteEvent = new MMLNoteEvent(0, 0, 0, 8);
        Color color3 = ColorManager.defaultColor().getUnusedFillColor();
        for (MMLNoteEvent mMLNoteEvent2 : list) {
            int n = this.isValidDrawNote(mMLNoteEvent2);
            if (n < 0) {
                mMLNoteEvent = mMLNoteEvent2;
                continue;
            }
            if (n > 0) break;
            this.drawNote(graphics2D, mMLNoteEvent2, color, mMLNoteEvent2.isMute() ? color3 : color2, bl, mMLNoteEvent);
            mMLNoteEvent = mMLNoteEvent2;
        }
    }

    private void paintMMLTrack(Graphics2D graphics2D, int n, MMLTrack mMLTrack) {
        if (!mMLTrack.isVisible()) {
            return;
        }
        boolean[] blArray = InstClass.getEnablePartByProgram(mMLTrack.getProgram());
        boolean[] blArray2 = InstClass.getEnablePartByProgram(mMLTrack.getSongProgram());
        MMLEventList mMLEventList = this.mmlManager.getActiveMMLPart();
        int n2 = 0;
        int n3 = mMLTrack.getMMLEventList().size();
        for (int i = 0; i < n3; ++i) {
            MMLEventList mMLEventList2 = mMLTrack.getMMLEventAtIndex(i);
            if (mMLEventList2 == mMLEventList) {
                ++n2;
                continue;
            }
            Color color = ColorManager.defaultColor().getPartRectColor(n, n2);
            Color color2 = ColorManager.defaultColor().getPartFillColor(n, n2);
            if (!blArray[i] && !blArray2[i]) {
                color2 = ColorManager.defaultColor().getUnusedFillColor();
            } else {
                ++n2;
            }
            this.paintMMLPart(graphics2D, mMLEventList2.getMMLNoteEventList(), color, color2, false);
        }
    }

    private void paintActiveTrack(Graphics2D graphics2D) {
        MMLEventList mMLEventList;
        int n = this.mmlManager.getActiveTrackIndex();
        if (this.paintMode != PaintMode.ACTIVE_PART) {
            this.paintMMLTrack(graphics2D, n, this.mmlManager.getMMLScore().getTrack(n));
        }
        if ((mMLEventList = this.mmlManager.getActiveMMLPart()) != null) {
            Color color = ColorManager.defaultColor().getActiveRectColor(n);
            Color color2 = ColorManager.defaultColor().getActiveFillColor(n);
            this.paintMMLPart(graphics2D, mMLEventList.getMMLNoteEventList(), color, color2, true);
        }
    }

    private void paintOtherTrack(Graphics2D graphics2D) {
        MMLScore mMLScore = this.mmlManager.getMMLScore();
        if (this.paintMode != PaintMode.ALL_TRACK) {
            return;
        }
        if (mMLScore != null) {
            MMLTrack mMLTrack = this.mmlManager.getActiveTrack();
            int n = mMLScore.getTrackCount();
            for (int i = 0; i < n; ++i) {
                MMLTrack mMLTrack2 = mMLScore.getTrack(i);
                if (mMLTrack2 == mMLTrack) continue;
                this.paintMMLTrack(graphics2D, i, mMLTrack2);
            }
        }
    }

    private void paintNoteInfo(Graphics2D graphics2D) {
        if (this.paintNoteInfo != null) {
            int n = this.paintNoteInfo.getTickOffset() - this.mmlManager.getActiveMMLPartStartOffset();
            String string = "start = " + n;
            Object object = "N/A";
            try {
                object = this.paintNoteInfo.toMMLString();
            }
            catch (MMLException mMLException) {
                // empty catch block
            }
            object = this.paintNoteInfo.getTick() + ": " + (String)object;
            int n2 = this.convertTicktoX(this.paintNoteInfo.getTickOffset());
            int n3 = this.convertTicktoX(this.paintNoteInfo.getEndTick());
            int n4 = this.convertNote2Y(this.paintNoteInfo.getNote()) - 2;
            graphics2D.setColor(Color.WHITE);
            graphics2D.drawString(string, n2 - 1, n4 - 12 - 1);
            graphics2D.drawString((String)object, n3 - 1, n4 - 1);
            graphics2D.drawString(string, n2 + 1, n4 - 12 + 1);
            graphics2D.drawString((String)object, n3 + 1, n4 + 1);
            graphics2D.setColor(Color.BLUE);
            graphics2D.drawString(string, n2, n4 - 12);
            graphics2D.drawString((String)object, n3, n4);
        }
    }

    private void paintSelectedNote(Graphics2D graphics2D) {
        if (this.selectNoteList != null) {
            this.paintMMLPart(graphics2D, this.selectNoteList, Color.YELLOW, Color.YELLOW, false);
        }
    }

    private void paintSelectingArea(Graphics2D graphics2D) {
        if (this.selectingRect != null) {
            graphics2D.setColor(Color.BLUE);
            graphics2D.draw(this.selectingRect);
        }
    }

    public void setRelativeInst(InstClass instClass) {
        this.relativeInst = instClass;
        this.repaint();
    }

    public static enum NoteHeight implements SettingButtonGroupItem
    {
        H6(6),
        H8(8),
        H10(10),
        H12(12),
        H14(14);

        private final int h;

        private NoteHeight(int n2) {
            this.h = n2;
        }

        @Override
        public String getButtonName() {
            return this.h + "px";
        }
    }

    public static enum PaintMode {
        ALL_TRACK("paintMode.all_track"),
        ACTIVE_TRACK("paintMode.active_track"),
        ACTIVE_PART("paintMode.active_part");

        private final String resourceName;

        private PaintMode(String string2) {
            this.resourceName = AppResource.appText(string2);
        }

        public String toString() {
            return this.resourceName;
        }
    }
}

