/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import jp.fourthline.mabiicco.ActionDispatcher;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.midi.InstClass;
import jp.fourthline.mabiicco.midi.InstType;
import jp.fourthline.mabiicco.midi.MabiDLS;
import jp.fourthline.mabiicco.ui.IMMLManager;
import jp.fourthline.mabiicco.ui.PartButtonIcon;
import jp.fourthline.mmlTools.MMLTrack;

public final class MMLTrackView
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 4955513242349170508L;
    public static final String[] MMLPART_NAME = new String[]{AppResource.appText("melody"), AppResource.appText("chord1"), AppResource.appText("chord2"), AppResource.appText("song")};
    private final JToggleButton[] partButton;
    private final JTextField[] mmlText;
    private final JComboBox<InstClass> comboBox;
    private final JComboBox<InstClass> songComboBox;
    private final JLabel trackComposeLabel;
    private final JToolBar toolBar = new JToolBar();
    private final JButton muteButton = new JButton("");
    private final JButton soloButton = new JButton("");
    private final JButton allButton = new JButton("");
    private final JLabel trackIndexLabel = new JLabel();
    private IMMLManager mmlManager;
    private final InstClass noUseSongEx = new InstClass(AppResource.appText("instrument.nouse_chorus") + ",0", -1, -1, null);
    private final InstClass excludeSongPart = new InstClass(AppResource.appText("instrument.excludeSongPart") + ",0", -2, -2, null);
    private int trackIndex;
    private boolean disableAction = false;
    private final JPanel mmlTextPanel = new JPanel();
    private static final Map<Integer, MMLTrackView> instanceList = new HashMap<Integer, MMLTrackView>();

    public void setVisibleMMLTextPanel(boolean bl) {
        if (bl) {
            this.add((Component)this.mmlTextPanel, "Center");
        } else {
            this.remove(this.mmlTextPanel);
        }
    }

    private MMLTrackView() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        JPanel jPanel3 = new JPanel();
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "East");
        this.add((Component)jPanel, "North");
        this.setVisibleMMLTextPanel(true);
        this.trackComposeLabel = new JLabel("");
        jPanel3.add(this.trackComposeLabel);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{20, 0, 0, 0, 0, 20};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.mmlTextPanel.setLayout(gridBagLayout);
        this.comboBox = new JComboBox<InstClass>(MabiDLS.getInstance().getAvailableInstByInstType(InstType.MAIN_INST_LIST));
        this.songComboBox = new JComboBox<InstClass>(MabiDLS.getInstance().getAvailableInstByInstType(InstType.SUB_INST_LIST));
        this.songComboBox.addItem(this.noUseSongEx);
        this.songComboBox.addItem(this.excludeSongPart);
        this.songComboBox.setSelectedItem(this.noUseSongEx);
        this.comboBox.setFocusable(false);
        this.songComboBox.setFocusable(false);
        jPanel2.add(this.comboBox);
        this.comboBox.addActionListener(this);
        this.comboBox.setMaximumRowCount(30);
        this.comboBox.setPreferredSize(new Dimension(200, 20));
        jPanel2.add(this.songComboBox);
        this.songComboBox.addActionListener(this);
        this.songComboBox.setMaximumRowCount(30);
        this.songComboBox.setPreferredSize(new Dimension(140, 20));
        this.toolBar.setFloatable(false);
        jPanel.add(this.toolBar);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.partButton = new JToggleButton[MMLPART_NAME.length];
        this.mmlText = new JTextField[MMLPART_NAME.length];
        for (int i = 0; i < MMLPART_NAME.length; ++i) {
            int n = 2 * i + 1;
            this.partButton[i] = new JToggleButton(MMLPART_NAME[i]);
            this.partButton[i].setFocusable(false);
            this.mmlTextPanel.add((Component)this.partButton[i], this.createGridBag(1, n, false));
            buttonGroup.add(this.partButton[i]);
            this.mmlText[i] = new JTextField();
            this.mmlText[i].setEditable(false);
            this.mmlText[i].setFocusable(false);
            this.mmlText[i].setFont(new Font("Monospaced", 0, 12));
            this.mmlText[i].setColumns(10);
            this.mmlText[i].addMouseListener(new ButtonCombAdapter(this.partButton[i]));
            this.mmlTextPanel.add((Component)this.mmlText[i], this.createGridBag(3, n, true));
        }
        this.partButton[0].setSelected(true);
    }

    private GridBagConstraints createGridBag(int n, int n2, boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        if (bl) {
            gridBagConstraints.fill = 2;
        }
        return gridBagConstraints;
    }

    private MMLTrackView(int n, ActionListener actionListener) {
        this();
        this.trackIndex = n;
        this.muteButton.setFocusable(false);
        this.muteButton.setToolTipText(AppResource.appText("mmltrack.mute"));
        this.toolBar.add(this.muteButton);
        this.soloButton.setFocusable(false);
        this.soloButton.setIcon(AppResource.getImageIcon(AppResource.appText("mmltrack.solo.icon")));
        this.soloButton.setToolTipText(AppResource.appText("mmltrack.solo"));
        this.toolBar.add(this.soloButton);
        this.allButton.setFocusable(false);
        this.allButton.setIcon(AppResource.getImageIcon(AppResource.appText("mmltrack.all.icon")));
        this.allButton.setToolTipText(AppResource.appText("mmltrack.all"));
        this.toolBar.add(this.allButton);
        this.toolBar.add(this.trackIndexLabel);
        for (JToggleButton jToggleButton : this.partButton) {
            jToggleButton.addActionListener(actionListener);
        }
        this.muteButton.addActionListener(this);
        this.soloButton.addActionListener(this);
        this.allButton.addActionListener(this);
    }

    public static MMLTrackView getInstance(int n, ActionListener actionListener, IMMLManager iMMLManager) {
        MMLTrackView mMLTrackView;
        if (instanceList.containsKey(n)) {
            mMLTrackView = instanceList.get(n);
        } else {
            mMLTrackView = new MMLTrackView(n, actionListener);
            instanceList.put(n, mMLTrackView);
        }
        mMLTrackView.mmlManager = iMMLManager;
        mMLTrackView.updateTrack();
        mMLTrackView.updateMuteButton();
        mMLTrackView.setSelectMMLPartOfIndex(0);
        mMLTrackView.updatePartButtonStatus();
        return mMLTrackView;
    }

    public void updateMuteButton() {
        this.muteButton.setEnabled(true);
        this.soloButton.setEnabled(true);
        this.allButton.setEnabled(true);
        if (MabiDLS.getInstance().getMute(this.trackIndex)) {
            this.muteButton.setIcon(AppResource.getImageIcon(AppResource.appText("mmltrack.mute.on.icon")));
        } else {
            this.muteButton.setIcon(AppResource.getImageIcon(AppResource.appText("mmltrack.mute.off.icon")));
        }
    }

    public int getSelectedMMLPartIndex() {
        for (int i = 0; i < MMLPART_NAME.length; ++i) {
            if (!this.partButton[i].isSelected()) continue;
            return i;
        }
        return 0;
    }

    public void setSelectMMLPartOfIndex(int n) {
        for (JToggleButton jToggleButton : this.partButton) {
            jToggleButton.setSelected(false);
        }
        this.partButton[n].setSelected(true);
    }

    public void updateTrack() {
        MMLTrack mMLTrack = this.mmlManager.getMMLScore().getTrack(this.trackIndex);
        String[] stringArray = mMLTrack.getMabiMMLArray();
        int n = this.mmlText.length;
        for (int i = 0; i < n; ++i) {
            if (i < stringArray.length) {
                this.mmlText[i].setText(stringArray[i]);
                continue;
            }
            this.mmlText[i].setText("");
        }
        this.setInstProgram(mMLTrack);
        this.updateRankFormat(mMLTrack);
    }

    private void updateRankFormat(MMLTrack mMLTrack) {
        this.trackComposeLabel.setText(mMLTrack.mmlRankFormat());
        String string = "   " + (this.trackIndex + 1) + "/" + this.mmlManager.getMMLScore().getTrackCount();
        this.trackIndexLabel.setText(string);
    }

    private InstClass convertInstBySongProgram(InstClass instClass, int n) {
        InstClass instClass2 = MabiDLS.getInstance().getInstByProgram(n);
        if (instClass2 != null) {
            return instClass2;
        }
        if (n == this.excludeSongPart.getProgram() && instClass.getType() != InstType.VOICE) {
            return this.excludeSongPart;
        }
        return this.noUseSongEx;
    }

    private void setInstProgram(MMLTrack mMLTrack) {
        int n = mMLTrack.getProgram();
        int n2 = mMLTrack.getSongProgram();
        this.disableAction = true;
        InstClass instClass = MabiDLS.getInstance().getInstByProgram(n);
        if (instClass != null) {
            this.comboBox.setSelectedItem(instClass);
        } else {
            this.comboBox.setSelectedIndex(0);
            n = ((InstClass)this.comboBox.getSelectedItem()).getProgram();
            mMLTrack.setProgram(n);
        }
        InstClass instClass2 = this.convertInstBySongProgram(instClass, n2);
        this.songComboBox.setSelectedItem(instClass2);
        mMLTrack.setSongProgram(instClass2.getProgram());
        this.disableAction = false;
        this.updateProgramChangeStatus();
    }

    private void updateProgramChangeStatus() {
        InstClass instClass = (InstClass)this.comboBox.getSelectedItem();
        MMLTrack mMLTrack = this.mmlManager.getMMLScore().getTrack(this.trackIndex);
        this.songComboBox.setVisible(instClass.getType() != InstType.VOICE);
        this.updatePartButtonStatus();
        InstClass instClass2 = (InstClass)this.songComboBox.getSelectedItem();
        int n = instClass.getProgram();
        int n2 = this.convertInstBySongProgram(instClass, instClass2.getProgram()).getProgram();
        if (mMLTrack.getProgram() == n && mMLTrack.getSongProgram() == n2) {
            return;
        }
        this.mmlManager.updateActiveTrackProgram(this.trackIndex, n, n2);
        this.updateRankFormat(mMLTrack);
    }

    private void updatePartButtonStatus() {
        InstClass instClass = (InstClass)this.comboBox.getSelectedItem();
        InstClass instClass2 = (InstClass)this.songComboBox.getSelectedItem();
        boolean[] blArray = instClass.getType().getEnablePart();
        boolean[] blArray2 = instClass2.getType().getEnablePart();
        int n = 0;
        for (int i = 0; i < this.partButton.length; ++i) {
            int n2 = blArray[i] || blArray2[i] ? 1 : 0;
            this.partButton[i].setEnabled(n2 != 0);
            this.mmlText[i].setEnabled(n2 != 0);
            this.partButton[i].setIcon(n2 != 0 ? PartButtonIcon.getInstance(n++, this.trackIndex) : PartButtonIcon.getDefautIcon());
        }
        if (!this.partButton[this.getSelectedMMLPartIndex()].isEnabled()) {
            this.partButton[this.getSelectedMMLPartIndex()].setSelected(false);
            for (JToggleButton jToggleButton : this.partButton) {
                if (!jToggleButton.isEnabled()) continue;
                jToggleButton.setSelected(true);
            }
        }
    }

    public void switchMMLPart(boolean bl) {
        int n = 0;
        for (int i = 0; i < this.partButton.length; ++i) {
            if (!this.partButton[i].isSelected()) continue;
            n = i;
            break;
        }
        do {
            if (bl) {
                if (++n < this.partButton.length) continue;
                n = 0;
                continue;
            }
            if (--n >= 0) continue;
            n = this.partButton.length - 1;
        } while (!this.partButton[n].isEnabled());
        this.partButton[n].setSelected(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.disableAction) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object instanceof JComboBox) {
            this.updateProgramChangeStatus();
        } else if (object.equals(this.muteButton)) {
            MabiDLS.getInstance().toggleMute(this.trackIndex);
            this.updateMuteButton();
        } else if (object.equals(this.soloButton)) {
            MabiDLS.getInstance().solo(this.trackIndex);
            this.updateMuteButton();
        } else if (object.equals(this.allButton)) {
            MabiDLS.getInstance().all();
            this.updateMuteButton();
        }
    }

    JComboBox<InstClass> getComboBox() {
        return this.comboBox;
    }

    JComboBox<InstClass> getSongComboBox() {
        return this.songComboBox;
    }

    String getRankText() {
        return this.trackComposeLabel.getText();
    }

    private static class ButtonCombAdapter
    extends MouseAdapter {
        private final JToggleButton button;

        private ButtonCombAdapter(JToggleButton jToggleButton) {
            this.button = jToggleButton;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (this.button.isEnabled()) {
                this.button.setSelected(true);
                Arrays.asList(this.button.getActionListeners()).forEach(actionListener -> actionListener.actionPerformed(null));
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getClickCount();
            if (n == 2) {
                ActionDispatcher.getInstance().doAction(this, "mml_text_edit");
            }
        }
    }
}

