/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco.midi;

import com.sun.media.sound.ModelPatch;
import com.sun.media.sound.SoftSynthesizer;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.DoubleConsumer;
import javax.sound.midi.Instrument;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Patch;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Track;
import javax.sound.midi.Transmitter;
import javax.sound.sampled.LineUnavailableException;
import jp.fourthline.mabiicco.AppErrorHandler;
import jp.fourthline.mabiicco.MabiIccoProperties;
import jp.fourthline.mabiicco.midi.DLSLoader;
import jp.fourthline.mabiicco.midi.ExtendMessage;
import jp.fourthline.mabiicco.midi.IWavoutState;
import jp.fourthline.mabiicco.midi.InstClass;
import jp.fourthline.mabiicco.midi.InstType;
import jp.fourthline.mabiicco.midi.MMLMidiTrack;
import jp.fourthline.mabiicco.midi.SoundEnv;
import jp.fourthline.mabiicco.midi.WavoutDataLine;
import jp.fourthline.mmlTools.MMLEvent;
import jp.fourthline.mmlTools.MMLEventList;
import jp.fourthline.mmlTools.MMLNoteEvent;
import jp.fourthline.mmlTools.MMLScore;
import jp.fourthline.mmlTools.MMLTempoEvent;
import jp.fourthline.mmlTools.MMLTrack;
import jp.fourthline.mmlTools.Marker;

public final class MabiDLS {
    private static MabiDLS instance = null;
    private Synthesizer synthesizer;
    private Sequencer sequencer;
    private MidiChannel[] channel;
    private int[] midiChannelProgram;
    private final List<MMLNoteEvent[]> playNoteList = new ArrayList<MMLNoteEvent[]>();
    private final List<int[]> playMidiNoteList = new ArrayList<int[]>();
    public static final int MAX_CHANNEL_PLAY_NOTE = 4;
    private static final int CHORUS_INDEX = 3;
    private static final int NUM_CHANNEL_ON_TRACK = 4;
    private static final int MAX_MIDI_PART = 96;
    private final List<InstClass> insts = new ArrayList<InstClass>();
    private final Map<File, List<InstClass>> instsMap = new LinkedHashMap<File, List<InstClass>>();
    public static final int DLS_BANK = 15488;
    public static final int DRUM_BANK = 15360;
    public static final String[] DEFALUT_DLS_PATH = new String[]{"Nexon/Mabinogi/mp3/MSXspirit01.dls", "Nexon/Mabinogi/mp3/MSXspirit02.dls", "Nexon/Mabinogi/mp3/MSXspirit03.dls", "Nexon/Mabinogi/mp3/MSXspirit04.dls"};
    private final ArrayList<Runnable> notifier = new ArrayList();
    private final boolean[] muteState = new boolean[24];
    private WavoutDataLine wavout;
    private boolean allLoaded = false;
    private boolean loop = false;
    private long startTick;
    private int startTempo;

    public static MabiDLS getInstance() {
        if (instance == null) {
            instance = new MabiDLS();
        }
        return instance;
    }

    private MabiDLS() {
    }

    public void initializeMIDI() throws MidiUnavailableException, InvalidMidiDataException, IOException, LineUnavailableException {
        this.synthesizer = MidiSystem.getSynthesizer();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("midi channels", 96);
        hashMap.put("large mode", "true");
        hashMap.put("max polyphony", "256");
        this.wavout = new WavoutDataLine();
        ((SoftSynthesizer)this.synthesizer).open(this.wavout, hashMap);
        this.addTrackEndNotifier(() -> this.wavout.stopRec());
        long l = this.synthesizer.getLatency();
        int n = this.synthesizer.getMaxPolyphony();
        int n2 = this.synthesizer.getChannels().length;
        System.out.printf("Latency: %d\nMaxPolyphony: %d\nChannels: %d\n", l, n, n2);
        this.sequencer = MidiSystem.getSequencer(false);
        this.sequencer.open();
        this.sequencer.addMetaEventListener(metaMessage -> {
            int n = metaMessage.getType();
            if (n == 81) {
                byte[] byArray = metaMessage.getData();
                this.sequencer.setTempoInMPQ(ByteBuffer.wrap(byArray).getInt());
            } else if (n == 47) {
                if (this.loop && !this.wavout.isRec()) {
                    this.sequenceStart();
                } else {
                    this.notifier.forEach(runnable -> runnable.run());
                }
            }
        });
        this.initializeSynthesizer();
        Transmitter transmitter = this.sequencer.getTransmitter();
        transmitter.setReceiver(new ExtendMessage.ExtendReceiver(this.synthesizer.getReceiver(), 96));
    }

    public void setLoop(boolean bl) {
        this.loop = bl;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public void createSequenceAndStart(MMLScore mMLScore, long l) {
        this.createSequenceAndStandby(mMLScore, l);
        this.sequenceStart();
    }

    private void createSequenceAndStandby(MMLScore mMLScore, long l) {
        try {
            MabiDLS.getInstance().loadRequiredInstruments(mMLScore);
            Sequencer sequencer = MabiDLS.getInstance().getSequencer();
            Sequence sequence = this.createSequenceOnSepChannel(mMLScore);
            sequencer.setSequence(sequence);
            this.startTick = l;
            this.startTempo = mMLScore.getTempoOnTick(l);
            this.updateMidiControl(mMLScore);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
        }
    }

    public IWavoutState getWavout() {
        return this.wavout;
    }

    public void startWavout(MMLScore mMLScore, File file, Runnable runnable, int n) throws IOException {
        this.createSequenceAndStandby(mMLScore, 0L);
        this.wavout.startRec(file, runnable, n);
        this.sequenceStart();
    }

    public void stopWavout() {
        this.wavout.stopRec();
        this.sequencer.stop();
    }

    public void allNoteOff() {
        for (MidiChannel midiChannel : this.channel) {
            midiChannel.allNotesOff();
            midiChannel.controlChange(64, 0);
            midiChannel.resetAllControllers();
        }
    }

    private void sequenceStart() {
        this.allNoteOff();
        this.midiSetMuteState();
        this.sequencer.setTickPosition(this.startTick);
        this.sequencer.setTempoInBPM(this.startTempo);
        this.sequencer.start();
    }

    public void addTrackEndNotifier(Runnable runnable) {
        this.notifier.add(runnable);
    }

    public void loadingDefaultSound() {
        try {
            boolean bl = ((SoundEnv)MabiIccoProperties.getInstance().soundEnv.get()).nameConvertForDefaultSoundBank();
            List<InstClass> object = InstClass.defaultSoundBank(bl);
            for (InstClass instClass : object) {
                if (this.insts.contains(instClass)) continue;
                this.insts.add(instClass);
            }
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
        for (InstClass instClass : this.insts) {
            this.synthesizer.loadInstrument(instClass.getInstrument());
        }
        this.allLoaded = true;
    }

    public List<File> loadingDLSFiles(List<File> list, DoubleConsumer doubleConsumer) throws IOException {
        DLSLoader dLSLoader = new DLSLoader(list);
        return dLSLoader.load(doubleConsumer, this.insts, this.instsMap);
    }

    public Map<File, List<InstClass>> getInstsMap() {
        return this.instsMap;
    }

    public synchronized void loadRequiredInstruments(MMLScore mMLScore) {
        if (this.allLoaded) {
            return;
        }
        ArrayList<InstClass> arrayList = new ArrayList<InstClass>();
        ArrayList<MMLTrack> arrayList2 = new ArrayList<MMLTrack>(mMLScore.getTrackList());
        for (MMLTrack mMLTrack : arrayList2) {
            InstClass instClass = this.getInstByProgram(mMLTrack.getProgram());
            InstClass instClass2 = this.getInstByProgram(mMLTrack.getSongProgram());
            if (instClass != null && !arrayList.contains(instClass)) {
                arrayList.add(instClass);
            }
            if (instClass2 == null || arrayList.contains(instClass2)) continue;
            arrayList.add(instClass2);
        }
        this.loadRequiredInstruments(arrayList);
    }

    public synchronized void loadRequiredInstruments(List<InstClass> list) {
        List<Instrument> list2 = Arrays.asList(this.synthesizer.getLoadedInstruments());
        for (InstClass instClass : list) {
            try {
                Instrument instrument = instClass.getInstrument();
                if (list2.contains(instrument)) continue;
                this.synthesizer.loadInstrument(instrument);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                AppErrorHandler.getInstance().exec();
                System.exit(1);
            }
        }
    }

    public Sequencer getSequencer() {
        return this.sequencer;
    }

    public Synthesizer getSynthesizer() {
        return this.synthesizer;
    }

    private void initializeSynthesizer() throws InvalidMidiDataException, IOException, MidiUnavailableException {
        this.channel = this.synthesizer.getChannels();
        this.midiChannelProgram = new int[this.channel.length];
        for (int i = 0; i < this.channel.length; ++i) {
            this.playNoteList.add(new MMLNoteEvent[4]);
            this.playMidiNoteList.add(new int[4]);
        }
        for (MidiChannel midiChannel : this.channel) {
            midiChannel.programChange(15488, 0);
            midiChannel.controlChange(91, 0);
            midiChannel.controlChange(64, 0);
        }
        Soundbank soundbank = this.synthesizer.getDefaultSoundbank();
        ArrayList<ModelPatch> arrayList = new ArrayList<ModelPatch>();
        for (Instrument instrument : soundbank.getInstruments()) {
            ModelPatch modelPatch;
            Patch patch = instrument.getPatch();
            if (!(patch instanceof ModelPatch) || (modelPatch = (ModelPatch)patch).isPercussion()) continue;
            arrayList.add(modelPatch);
        }
        this.synthesizer.unloadInstruments(soundbank, (Patch[])arrayList.toArray(Patch[]::new));
        this.all();
    }

    public List<InstClass> getAllInst() {
        return this.insts;
    }

    public InstClass[] getAvailableInstByInstType(List<InstType> list) {
        return (InstClass[])this.insts.stream().filter(instClass -> list.contains(instClass.getType())).toArray(InstClass[]::new);
    }

    public InstClass getInstByProgram(int n) {
        for (InstClass instClass : this.insts) {
            if (instClass.getProgram() != n) continue;
            return instClass;
        }
        for (InstClass instClass : this.insts) {
            if (InstClass.toMidiProram(instClass.getProgram()) != InstClass.toMidiProram(n)) continue;
            return instClass;
        }
        return null;
    }

    private int getChannel(int n, int n2) {
        return n * 4 + n2;
    }

    public void playNote(MMLScore mMLScore, int n, int n2, int n3, int n4) {
        int n5 = this.getChannel(n3, n4);
        MMLNoteEvent mMLNoteEvent = this.playNoteList.get(n5)[0];
        if (mMLNoteEvent == null || mMLNoteEvent.getNote() != n) {
            mMLNoteEvent = new MMLNoteEvent(n, 0, 0, n2);
        }
        this.playNotes(mMLScore, new MMLNoteEvent[]{mMLNoteEvent}, n3, n4);
    }

    public void playDrum(boolean bl, int n, int n2, int n3) {
        int n4 = 9;
        int n5 = 0;
        if (bl) {
            n3 = 0;
        } else {
            n5 = 15488;
        }
        MidiChannel midiChannel = this.channel[n4];
        midiChannel.setMute(false);
        midiChannel.controlChange(10, 64);
        midiChannel.controlChange(7, 100);
        midiChannel.programChange(n5, n3);
        if (n >= 0) {
            midiChannel.noteOn(bl ? n : this.getInstByProgram(n3).convertNoteMML2Midi(n), n2);
        } else {
            midiChannel.allNotesOff();
        }
    }

    public void playNotes(MMLScore mMLScore, MMLNoteEvent[] mMLNoteEventArray, int n, int n2) {
        int n3 = this.getChannel(n, n2);
        if (this.sequencer.isRunning()) {
            return;
        }
        if (n3 >= this.channel.length) {
            return;
        }
        this.updateMidiControl(mMLScore);
        this.channel[n3].setMute(false);
        this.setTrackPanpot(n, 64);
        this.setTrackVolume(n, 100);
        MMLNoteEvent[] mMLNoteEventArray2 = this.playNoteList.get(n3);
        int[] nArray = this.playMidiNoteList.get(n3);
        MidiChannel midiChannel = this.channel[n3];
        int n4 = this.midiChannelProgram[n3];
        InstClass instClass = this.getInstByProgram(n4);
        for (int i = 0; i < mMLNoteEventArray2.length; ++i) {
            MMLNoteEvent mMLNoteEvent = null;
            if (mMLNoteEventArray != null && i < mMLNoteEventArray.length) {
                mMLNoteEvent = mMLNoteEventArray[i];
            }
            if (!(mMLNoteEvent != null && mMLNoteEvent.equals(mMLNoteEventArray2[i]) || mMLNoteEventArray2[i] == null)) {
                midiChannel.noteOff(nArray[i]);
                mMLNoteEventArray2[i] = null;
            }
            if (mMLNoteEvent == null || mMLNoteEvent.equals(mMLNoteEventArray2[i])) continue;
            int n5 = this.convertVelocityOnAtt(instClass, mMLNoteEvent.getNote(), mMLNoteEvent.getVelocity());
            int n6 = instClass.convertNoteMML2Midi(mMLNoteEvent.getNote());
            if (n6 >= 0) {
                midiChannel.noteOn(n6, n5);
            }
            mMLNoteEventArray2[i] = mMLNoteEvent;
            nArray[i] = n6;
        }
    }

    public int selectSongProgram(int n, int n2) {
        int n3 = n;
        if (this.getInstByProgram(n).getType() != InstType.VOICE && n2 >= 0) {
            n3 = n2;
        }
        return n3;
    }

    private void changeProgram(int n, int n2, int n3) {
        int n4 = InstClass.toMidiProram(n2);
        int n5 = InstClass.toMidiBank(n2);
        n5 += 15488;
        if ((n2 & InstClass.DRUM) != 0) {
            n5 = 15360;
            n2 -= InstClass.DRUM;
        }
        int n6 = this.getChannel(n, 3);
        for (int i = this.getChannel(n, 0); i < n6; ++i) {
            this.channel[i].programChange(n5, n4);
            this.midiChannelProgram[i] = n2;
        }
        this.channel[n6].programChange(15488, this.selectSongProgram(n2, n3));
    }

    public void setTrackPanpot(int n, int n2) {
        if (n < 0 || n >= 24) {
            throw new IllegalArgumentException("trackIndex: " + n);
        }
        for (int i = this.getChannel(n, 0); i < this.getChannel(n + 1, 0); ++i) {
            this.channel[i].controlChange(10, n2);
        }
    }

    public void setTrackVolume(int n, int n2) {
        if (n < 0 || n >= 24) {
            throw new IllegalArgumentException("trackIndex: " + n);
        }
        for (int i = this.getChannel(n, 0); i < this.getChannel(n + 1, 0); ++i) {
            this.channel[i].controlChange(7, n2);
        }
    }

    public void toggleMute(int n) {
        if (n < 0 || n >= 24) {
            throw new IllegalArgumentException("trackIndex: " + n);
        }
        this.muteState[n] = !this.muteState[n];
        this.midiSetMuteState();
    }

    public void setMute(int n, boolean bl) {
        if (n < 0 || n >= 24) {
            throw new IllegalArgumentException("trackIndex: " + n);
        }
        this.muteState[n] = bl;
        this.midiSetMuteState();
    }

    public boolean getMute(int n) {
        if (n < 0 || n >= 24) {
            throw new IllegalArgumentException("trackIndex: " + n);
        }
        return this.muteState[n];
    }

    public void solo(int n) {
        if (n < 0 || n >= 24) {
            throw new IllegalArgumentException("trackIndex: " + n);
        }
        for (int i = 0; i < this.muteState.length; ++i) {
            this.muteState[i] = i != n;
        }
        this.midiSetMuteState();
    }

    public void all() {
        for (int i = 0; i < this.muteState.length; ++i) {
            this.muteState[i] = false;
        }
        this.midiSetMuteState();
    }

    private void midiSetMuteState() {
        for (int i = 0; i < this.muteState.length; ++i) {
            for (int j = this.getChannel(i, 0); j < this.getChannel(i + 1, 0); ++j) {
                this.channel[j].setMute(this.muteState[i]);
            }
        }
    }

    public void updateMidiControl(MMLScore mMLScore) {
        int n = 0;
        for (MMLTrack mMLTrack : mMLScore.getTrackList()) {
            this.setTrackPanpot(n, mMLTrack.getPanpot());
            this.setTrackVolume(n, mMLTrack.getVolume());
            this.changeProgram(n, mMLTrack.getProgram(), mMLTrack.getSongProgram());
            ++n;
        }
    }

    public Sequence createSequenceForPlay(MMLScore mMLScore) throws InvalidMidiDataException {
        return this.createSequence(mMLScore, 1, true, false, true);
    }

    public Sequence createSequenceForMidi(MMLScore mMLScore) throws InvalidMidiDataException {
        return this.createSequence(mMLScore, 0, false, true, false);
    }

    /*
     * WARNING - void declaration
     */
    private Sequence createSequence(MMLScore mMLScore, int n, boolean bl, boolean bl2, boolean bl3) throws InvalidMidiDataException {
        Iterator<MMLTrack> iterator;
        Sequence sequence = new Sequence(0.0f, 96);
        int n2 = mMLScore.getTotalTickLength();
        Track track = sequence.createTrack();
        if (bl2) {
            for (Marker object2 : mMLScore.getMarkerList()) {
                iterator = (Iterator<MMLTrack>)object2.getMetaData();
                track.add(new MidiEvent(new MetaMessage(6, (byte[])iterator, ((Iterator<MMLTrack>)iterator).length), object2.getTickOffset()));
            }
        }
        List<MMLTempoEvent> list = mMLScore.getTempoEventList();
        Iterator n4 = list.iterator();
        while (n4.hasNext()) {
            iterator = (MMLTempoEvent)n4.next();
            byte[] byArray = ((MMLTempoEvent)((Object)iterator)).getMetaData();
            int n3 = ((MMLEvent)((Object)iterator)).getTickOffset();
            if (n3 >= n2) break;
            track.add(new MidiEvent(new MetaMessage(81, byArray, byArray.length), n3));
        }
        boolean bl4 = false;
        for (MMLTrack mMLTrack : mMLScore.getTrackList()) {
            void var10_13;
            this.convertMidiTrack(sequence.createTrack(), mMLTrack, (int)var10_13, mMLTrack.getProgram(), n, bl, bl2, bl3);
            if (mMLTrack.getSongProgram() >= 0) {
                this.convertMidiTrack(sequence.createTrack(), mMLTrack, (int)(var10_13 + 24), mMLTrack.getSongProgram(), n, bl, bl2, bl3);
            }
            if (++var10_13 < this.channel.length) continue;
            break;
        }
        return sequence;
    }

    public Sequence createSequenceOnSepChannel(MMLScore mMLScore) throws InvalidMidiDataException {
        int n;
        Sequence sequence = new Sequence(0.0f, 96);
        int n2 = mMLScore.getTotalTickLength();
        Track track = sequence.createTrack();
        List<MMLTempoEvent> list = mMLScore.getTempoEventList();
        for (MMLTempoEvent object22 : list) {
            Object object = object22.getMetaData();
            n = object22.getTickOffset();
            if (n >= n2) break;
            track.add(new MidiEvent(new MetaMessage(81, (byte[])object, ((Object)object).length), n));
        }
        int n3 = 0;
        for (Object object : mMLScore.getTrackList()) {
            for (n = 0; n < 4; ++n) {
                List<MMLNoteEvent> list2;
                boolean[] blArray;
                int n4 = ((MMLTrack)object).getProgram();
                if (n == 3 && ((MMLTrack)object).getSongProgram() >= 0) {
                    n4 = ((MMLTrack)object).getSongProgram();
                }
                if (!(blArray = InstClass.getEnablePartByProgram(n4))[n] || (list2 = ((MMLTrack)object).getMMLEventAtIndex(n).getMMLNoteEventList()).size() <= 0) continue;
                int n5 = this.getChannel(n3, n);
                InstClass instClass = this.getInstByProgram(n4);
                MMLMidiTrack mMLMidiTrack = new MMLMidiTrack(instClass);
                mMLMidiTrack.setAttackDelayCorrect(((MMLTrack)object).getAttackDelayCorrect(n));
                mMLMidiTrack.add(list2);
                this.convertMidiPart(sequence.createTrack(), mMLMidiTrack.getNoteEventList(), n5, instClass, 1, true);
            }
            ++n3;
        }
        return sequence;
    }

    private void convertMidiTrack(Track track, MMLTrack mMLTrack, int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3) throws InvalidMidiDataException {
        Object object;
        Object[] objectArray;
        if (bl2) {
            objectArray = mMLTrack.getTrackName().getBytes();
            object = new MetaMessage(3, (byte[])objectArray, objectArray.length);
            track.add(new MidiEvent((MidiMessage)object, 0L));
        }
        objectArray = InstClass.getEnablePartByProgram(n2);
        object = this.getInstByProgram(n2);
        MMLMidiTrack mMLMidiTrack = new MMLMidiTrack((InstClass)object);
        for (int i = 0; i < objectArray.length; ++i) {
            if (!objectArray[i]) continue;
            if (bl) {
                mMLMidiTrack.setAttackDelayCorrect(mMLTrack.getAttackDelayCorrect(i));
            }
            MMLEventList mMLEventList = mMLTrack.getMMLEventAtIndex(i);
            mMLMidiTrack.add(mMLEventList.getMMLNoteEventList());
        }
        this.convertMidiPart(track, mMLMidiTrack.getNoteEventList(), n, (InstClass)object, n3, bl3);
    }

    private void convertMidiPart(Track track, List<MMLNoteEvent> list, int n, InstClass instClass, int n2, boolean bl) throws InvalidMidiDataException {
        int n3 = 8;
        int n4 = instClass.getProgram();
        ExtendMessage extendMessage = new ExtendMessage(192, n, n4 & 0xFF, 0);
        track.add(new MidiEvent(extendMessage, 0L));
        for (MMLNoteEvent mMLNoteEvent : list) {
            if (bl && mMLNoteEvent.isMute()) continue;
            int n5 = mMLNoteEvent.getNote();
            int n6 = mMLNoteEvent.getTick();
            int n7 = mMLNoteEvent.getTickOffset() + n2;
            int n8 = n7 + n6 - n2;
            if (mMLNoteEvent.getVelocity() >= 0) {
                n3 = this.convertVelocityOnAtt(instClass, n5, mMLNoteEvent.getVelocity());
            }
            try {
                int n9 = instClass.convertNoteMML2Midi(n5);
                ExtendMessage extendMessage2 = new ExtendMessage(144, n, n9, n3);
                track.add(new MidiEvent(extendMessage2, n7));
                ExtendMessage extendMessage3 = new ExtendMessage(128, n, n9, 0);
                track.add(new MidiEvent(extendMessage3, n8));
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                invalidMidiDataException.printStackTrace();
            }
        }
    }

    private int convertVelocityOnAtt(InstClass instClass, int n, int n2) {
        n2 = instClass.getType().convertVelocityMML2Midi(n2);
        if (n2 == 0) {
            return 0;
        }
        double d = instClass.getAttention(n);
        n2 = (int)Math.sqrt(Math.pow(10.0, d / 20.0) * (double)(n2 * n2));
        return n2;
    }

    public List<MidiDevice.Info> getMidiInDevice() {
        ArrayList<MidiDevice.Info> arrayList = new ArrayList<MidiDevice.Info>();
        for (MidiDevice.Info info : MidiSystem.getMidiDeviceInfo()) {
            try {
                MidiDevice midiDevice = MidiSystem.getMidiDevice(info);
                if (midiDevice.getMaxTransmitters() == 0 || midiDevice.getMaxReceivers() != 0) continue;
                arrayList.add(midiDevice.getDeviceInfo());
            }
            catch (MidiUnavailableException midiUnavailableException) {
                midiUnavailableException.printStackTrace();
            }
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        try {
            InstClass.debug = true;
            MabiDLS mabiDLS = new MabiDLS();
            mabiDLS.initializeMIDI();
            for (MidiDevice.Info info : MidiSystem.getMidiDeviceInfo()) {
                System.out.println(info);
            }
            ArrayList arrayList = new ArrayList();
            for (File file : MabiIccoProperties.getInstance().getDlsFile()) {
                arrayList.add(file);
            }
            DLSLoader.noParallel = true;
            mabiDLS.loadingDLSFiles(arrayList, null);
            System.exit(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

