/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco;

import java.awt.Font;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.function.BiConsumer;
import java.util.jar.Manifest;
import javax.swing.ImageIcon;
import jp.fourthline.mmlTools.core.ResourceLoader;

public final class AppResource {
    private static final String APP_TITLE = " * MabiIcco * ";
    private static final String RESOURCE_NAME = "appResource";
    private static ArrayList<Manifest> mf;
    private static final ResourceBundle bundle;
    public static final Font MONO_FONT;
    private static final HashMap<String, ImageIcon> iconMap;

    private AppResource() {
    }

    public static ResourceBundle getResourceBundle() {
        return bundle;
    }

    public static String getVersionText() {
        return AppResource.getManifestValue("MabiIcco-Version");
    }

    public static String getAppTitle() {
        return APP_TITLE;
    }

    public static String getRuntimeVersion() {
        return System.getProperties().get("java.runtime.version").toString();
    }

    public static synchronized String getManifestValue(String string) {
        Object object;
        if (mf == null) {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Enumeration<URL> object2 = classLoader.getResources("META-INF/MANIFEST.MF");
                mf = new ArrayList();
                while (object2.hasMoreElements()) {
                    object = object2.nextElement();
                    mf.add(new Manifest(((URL)object).openStream()));
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return "";
            }
        }
        for (Manifest manifest : mf) {
            object = manifest.getMainAttributes().getValue(string);
            if (object == null) continue;
            return object;
        }
        return "";
    }

    public static String appText(String string) {
        return AppResource.appText(string, true);
    }

    private static String appText(String string, boolean bl) {
        try {
            StringBuilder stringBuilder = new StringBuilder(bundle.getString(string));
            while (bl) {
                int n = stringBuilder.indexOf("%%");
                int n2 = stringBuilder.indexOf("%%", n + 1);
                if (n >= 0 && n + 2 < n2) {
                    String string2 = AppResource.appText(stringBuilder.substring(n + 2, n2), false);
                    stringBuilder.replace(n, n2 + 2, string2);
                    continue;
                }
                bl = false;
            }
            return stringBuilder.toString();
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    public static ImageIcon getImageIcon(String string) {
        ImageIcon imageIcon = iconMap.get(string);
        if (imageIcon == null) {
            URL uRL = AppResource.class.getResource(string);
            if (uRL == null) {
                System.err.println("not found icon: " + string + " > " + uRL);
            } else {
                imageIcon = new ImageIcon(uRL);
                iconMap.put(string, imageIcon);
            }
        }
        return imageIcon;
    }

    public static String getErrFile() {
        return ResourceLoader.getAppPath("err.txt");
    }

    public static void main(String[] stringArray) {
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(object, object2) -> System.out.println(object + ": " + object2)));
    }

    static {
        bundle = ResourceBundle.getBundle(RESOURCE_NAME, new ResourceLoader());
        MONO_FONT = new Font("Monospaced", 0, 12);
        iconMap = new HashMap();
    }
}

