/*
 * Decompiled with CFR 0.152.
 */
package jp.fourthline.mabiicco;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import jp.fourthline.mabiicco.AppResource;
import jp.fourthline.mabiicco.FixFileChooser;
import jp.fourthline.mabiicco.IEditState;
import jp.fourthline.mabiicco.IEditStateObserver;
import jp.fourthline.mabiicco.IFileState;
import jp.fourthline.mabiicco.IFileStateObserver;
import jp.fourthline.mabiicco.Laf;
import jp.fourthline.mabiicco.MMLOptimizeLevel;
import jp.fourthline.mabiicco.MabiIccoProperties;
import jp.fourthline.mabiicco.Utils;
import jp.fourthline.mabiicco.midi.MMLMidiTrack;
import jp.fourthline.mabiicco.midi.MabiDLS;
import jp.fourthline.mabiicco.midi.SoundEnv;
import jp.fourthline.mabiicco.ui.About;
import jp.fourthline.mabiicco.ui.DLSSetupDialog;
import jp.fourthline.mabiicco.ui.MMLErrView;
import jp.fourthline.mabiicco.ui.MMLSeqView;
import jp.fourthline.mabiicco.ui.MainFrame;
import jp.fourthline.mabiicco.ui.PianoRollScaler;
import jp.fourthline.mabiicco.ui.PianoRollView;
import jp.fourthline.mabiicco.ui.PolyphonyMonitor;
import jp.fourthline.mabiicco.ui.WavoutPanel;
import jp.fourthline.mabiicco.ui.color.ScaleColor;
import jp.fourthline.mabiicco.ui.editor.DrumConverter;
import jp.fourthline.mabiicco.ui.editor.EditTool;
import jp.fourthline.mabiicco.ui.editor.MMLTranspose;
import jp.fourthline.mabiicco.ui.editor.MultiTracksVelocityChangeEditor;
import jp.fourthline.mabiicco.ui.editor.MultiTracksViewEditor;
import jp.fourthline.mabiicco.ui.editor.UserViewWidthDialog;
import jp.fourthline.mabiicco.ui.editor.VelocityEditor;
import jp.fourthline.mabiicco.ui.mml.MMLExportPanel;
import jp.fourthline.mabiicco.ui.mml.MMLImportPanel;
import jp.fourthline.mabiicco.ui.mml.MMLScorePropertyPanel;
import jp.fourthline.mabiicco.ui.mml.ParsePropertiesDialog;
import jp.fourthline.mmlTools.MMLScore;
import jp.fourthline.mmlTools.MMLScoreSerializer;
import jp.fourthline.mmlTools.MMLTrack;
import jp.fourthline.mmlTools.core.NanoTime;
import jp.fourthline.mmlTools.parser.IMMLFileParser;
import jp.fourthline.mmlTools.parser.MMLParseException;

public final class ActionDispatcher
implements ActionListener,
IFileStateObserver,
IEditStateObserver {
    private MainFrame mainFrame;
    private MMLSeqView mmlSeqView;
    private IFileState fileState;
    private IEditState editState;
    @Action
    public static final String VIEW_SCALE_UP = "view_scale_up";
    @Action
    public static final String VIEW_SCALE_DOWN = "view_scale_down";
    @Action
    public static final String PLAY = "play";
    @Action
    public static final String STOP = "stop";
    @Action
    public static final String PAUSE = "pause";
    @Action
    public static final String FILE_OPEN = "fileOpen";
    @Action
    public static final String NEW_FILE = "newFile";
    @Action
    public static final String RELOAD_FILE = "reloadFile";
    @Action
    public static final String QUIT = "quit";
    @Action
    public static final String ADD_TRACK = "addTrack";
    @Action
    public static final String REMOVE_TRACK = "removeTrack";
    @Action
    public static final String DUPLICATE_TRACK = "duplicateTrack";
    @Action
    public static final String TRACK_PROPERTY = "trackProperty";
    @Action
    public static final String SET_START_POSITION = "setStartPosition";
    @Action
    public static final String INPUT_FROM_CLIPBOARD = "inputFromClipboard";
    @Action
    public static final String OUTPUT_TO_CLIPBOARD = "outputToClipboard";
    @Action
    public static final String UNDO = "undo";
    @Action
    public static final String REDO = "redo";
    @Action
    public static final String SAVE_FILE = "save_file";
    @Action
    public static final String SAVEAS_FILE = "saveas_file";
    @Action
    public static final String CUT = "cut";
    @Action
    public static final String COPY = "copy";
    @Action
    public static final String PASTE = "paste";
    @Action
    public static final String DELETE = "delete";
    @Action
    public static final String SCORE_PROPERTY = "score_property";
    @Action
    public static final String NEXT_TIME = "next_time";
    @Action
    public static final String PREV_TIME = "prev_time";
    @Action
    public static final String PART_CHANGE = "part_change";
    @Action
    public static final String ADD_MEASURE = "add_measure";
    @Action
    public static final String REMOVE_MEASURE = "remove_measure";
    @Action
    public static final String ADD_BEAT = "add_beat";
    @Action
    public static final String REMOVE_BEAT = "remove_beat";
    @Action
    public static final String NOTE_PROPERTY = "note_property";
    @Action
    public static final String TRANSPOSE = "transpose";
    @Action
    public static final String TRACKS_EDIT = "tracks_edit";
    @Action
    public static final String TRACKS_VIEW = "tracks_view";
    @Action
    public static final String ABOUT = "about";
    @Action
    public static final String MIDI_EXPORT = "midi_export";
    @Action
    public static final String FILE_IMPORT = "file_import";
    @Action
    public static final String SELECT_DLS = "select_dls";
    @Action
    public static final String SELECT_ALL = "select_all";
    @Action
    public static final String SELECT_PREVIOUS_ALL = "select_previous_all";
    @Action
    public static final String SELECT_AFTER_ALL = "select_after_all";
    @Action
    public static final String SELECT_ALL_SAME_PITCH = "select_all_same_pitch";
    @Action
    public static final String MML_IMPORT = "mml_import";
    @Action
    public static final String MML_EXPORT = "mml_export";
    @Action
    public static final String SWITCH_TRACK_NEXT = "switch_track_next";
    @Action
    public static final String SWITCH_TRACK_PREV = "switch_track_prev";
    @Action
    public static final String SWITCH_MMLPART_NEXT = "switch_mmlpart_next";
    @Action
    public static final String SWITCH_MMLPART_PREV = "switch_mmlpart_prev";
    @Action
    public static final String TOGGLE_LOOP = "toggle_loop";
    @Action
    public static final String FILE_OPEN_WITH_HISTORY = "file_open_with_history";
    @Action
    public static final String ALL_CLEAR_TEMPO = "all_clear_tempo";
    @Action
    public static final String MML_GENERATE = "mml_generate";
    @Action
    public static final String WAVOUT = "wavout";
    @Action
    public static final String KEYBOARD_INPUT = "keyboard_input";
    @Action
    public static final String INPUT_EMPTY_CORRECTION = "input_empty_correction";
    @Action
    public static final String REMOVE_RESTS_BETWEEN_NOTES = "remote_rests_between_notes";
    @Action
    public static final String SHOW_RESTART_DIALOG = "show_restart_dialog";
    @Action
    public static final String SET_TEMP_MUTE = "set_temp_mute";
    @Action
    public static final String UNSET_TEMP_MUTE = "unset_temp_mute";
    @Action
    public static final String UNSET_TEMP_MUTE_ALL = "unset_temp_mute_all";
    @Action
    public static final String OCTAVE_UP = "octave_up";
    @Action
    public static final String OCTAVE_DOWN = "octave_down";
    @Action
    public static final String VELOCITY_UP = "velocity_up";
    @Action
    public static final String VELOCITY_DOWN = "velocity_down";
    @Action
    public static final String SET_USER_VIEW_MEASURE = "set_user_view_measure";
    @Action
    public static final String INST_LIST = "inst_list";
    @Action
    public static final String SHORTCUT_INFO = "shortcut_info";
    @Action
    public static final String CONVERT_TUPLET = "convert_tuplet";
    @Action
    public static final String OTHER_MML_EXPORT = "other_mml_export";
    @Action
    public static final String CHANGE_ACTION = "change_action";
    @Action
    public static final String MML_TEXT_EDIT = "mml_text_edit";
    @Action
    public static final String MML_ERR_LIST = "mml_err_list";
    @Action
    public static final String MML_X_IMPORT = "mml_x_import";
    @Action
    public static final String MML_X_EXPORT = "mml_x_export";
    @Action
    public static final String POLYPHONY_MONITOR = "polyphony_monitor";
    @Action
    public static final String MIDI_MABI_DRUM_CONVERT = "midi_mabi_drum_convert";
    @Action
    public static final String SHOW_LICENSES = "show_licenses";
    private final HashMap<String, Consumer<Object>> actionMap = new HashMap();
    private File openedFile = null;
    private final FileFilter mmsFilter = new FileNameExtensionFilter(AppResource.appText("file.mms"), "mms");
    private final FileFilter mmiFilter = new FileNameExtensionFilter(AppResource.appText("file.mmi"), "mmi");
    private final FileFilter mmlFilter = new FileNameExtensionFilter(AppResource.appText("file.mml"), "mml");
    private final FileFilter allFilter = new FileNameExtensionFilter(AppResource.appText("file.all"), "mmi", "mms", "mml", "mid", "txt");
    private final FileFilter midFilter = new FileNameExtensionFilter(AppResource.appText("file.mid"), "mid");
    private final FileFilter wavFilter = new FileNameExtensionFilter(AppResource.appText("file.wav"), "wav");
    private final FileFilter txtFilter = new FileNameExtensionFilter(AppResource.appText("file.txt"), "txt");
    private JFileChooser openFileChooser;
    private JFileChooser saveFileChooser;
    private JFileChooser exportFileChooser;
    private JFileChooser wavoutFileChooser;
    private JFileChooser txtFileChooser;
    private final List<Component> updateUIComponents = new ArrayList<Component>();
    private final MabiIccoProperties appProperties = MabiIccoProperties.getInstance();
    private boolean testMode = false;
    private List<IEditStateObserver> editObservers = new ArrayList<IEditStateObserver>();
    private static ActionDispatcher instance = null;
    private CompletableFuture<Void> initRun = CompletableFuture.runAsync(() -> {
        this.initializeFileChooser();
        this.initializeActionMap();
        MabiDLS.getInstance().addTrackEndNotifier(() -> this.stopAction());
    });

    public static ActionDispatcher getInstance() {
        if (instance == null) {
            instance = new ActionDispatcher();
        }
        return instance;
    }

    public void addUpdateUIComponent(Component component) {
        this.updateUIComponents.add(component);
    }

    private ActionDispatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        ActionDispatcher actionDispatcher = this;
        synchronized (actionDispatcher) {
            if (this.initRun != null) {
                this.initRun.join();
            }
            this.initRun = null;
        }
    }

    public ActionDispatcher setMainFrame(MainFrame mainFrame) {
        if (this.mainFrame != null) {
            this.updateUIComponents.remove(this.mainFrame);
        }
        this.updateUIComponents.add(mainFrame);
        this.mainFrame = mainFrame;
        this.mmlSeqView = mainFrame.getMMLSeqView();
        this.fileState = this.mmlSeqView.getFileState();
        this.editState = this.mmlSeqView.getEditState();
        this.fileState.setFileStateObserver(this);
        this.editState.setEditStateObserver(this);
        return this;
    }

    public void setTestMode(boolean bl) {
        this.testMode = bl;
    }

    private void initializeFileChooser() {
        this.openFileChooser = new FixFileChooser();
        this.saveFileChooser = new FixFileChooser();
        this.exportFileChooser = new FixFileChooser();
        this.wavoutFileChooser = new FixFileChooser();
        this.txtFileChooser = new FixFileChooser();
        this.openFileChooser.addChoosableFileFilter(this.allFilter);
        this.openFileChooser.addChoosableFileFilter(this.mmiFilter);
        this.openFileChooser.addChoosableFileFilter(this.mmsFilter);
        this.openFileChooser.addChoosableFileFilter(this.mmlFilter);
        this.openFileChooser.addChoosableFileFilter(this.midFilter);
        this.openFileChooser.addChoosableFileFilter(this.txtFilter);
        this.saveFileChooser.addChoosableFileFilter(this.mmiFilter);
        this.exportFileChooser.addChoosableFileFilter(this.midFilter);
        this.wavoutFileChooser.addChoosableFileFilter(this.wavFilter);
        this.txtFileChooser.addChoosableFileFilter(this.txtFilter);
    }

    private void initializeActionMap() {
        this.actionMap.put(VIEW_SCALE_UP, object -> this.mmlSeqView.getPianoRollScaler().expandPianoViewWide());
        this.actionMap.put(VIEW_SCALE_DOWN, object -> this.mmlSeqView.getPianoRollScaler().reducePianoViewWide());
        this.actionMap.put(STOP, object -> this.stopAction());
        this.actionMap.put(PAUSE, object -> this.pauseAction());
        this.actionMap.put(FILE_OPEN, object -> this.openMMLFileAction());
        this.actionMap.put(NEW_FILE, object -> this.newMMLFileAction());
        this.actionMap.put(RELOAD_FILE, object -> this.reloadMMLFileAction());
        this.actionMap.put(QUIT, object -> this.quitAction());
        this.actionMap.put(ADD_TRACK, object -> this.mmlSeqView.addMMLTrack(null));
        this.actionMap.put(REMOVE_TRACK, object -> this.mmlSeqView.removeMMLTrack());
        this.actionMap.put(DUPLICATE_TRACK, object -> this.duplicateMMLTrack());
        this.actionMap.put(TRACK_PROPERTY, object -> this.mmlSeqView.editTrackPropertyAction());
        this.actionMap.put(SET_START_POSITION, object -> this.mmlSeqView.setStartPosition());
        this.actionMap.put(PLAY, object -> this.playAction());
        this.actionMap.put(INPUT_FROM_CLIPBOARD, object -> this.mmlSeqView.inputClipBoardAction());
        this.actionMap.put(OUTPUT_TO_CLIPBOARD, object -> this.mmlSeqView.outputClipBoardAction());
        this.actionMap.put(UNDO, object -> this.mmlSeqView.undo());
        this.actionMap.put(REDO, object -> this.mmlSeqView.redo());
        this.actionMap.put(SAVE_FILE, object -> this.saveMMLFile(this.openedFile));
        this.actionMap.put(SAVEAS_FILE, object -> this.saveAsMMLFileAction());
        this.actionMap.put(CUT, object -> this.editState.selectedCut());
        this.actionMap.put(COPY, object -> this.editState.selectedCopy());
        this.actionMap.put(PASTE, object -> this.editPasteAction());
        this.actionMap.put(DELETE, object -> this.editState.selectedDelete());
        this.actionMap.put(SCORE_PROPERTY, object -> this.scorePropertyAction());
        this.actionMap.put(NEXT_TIME, object -> this.mmlSeqView.nextStepTimeTo(true));
        this.actionMap.put(PREV_TIME, object -> this.mmlSeqView.nextStepTimeTo(false));
        this.actionMap.put(PART_CHANGE, object -> this.mmlSeqView.partChange());
        this.actionMap.put(ADD_MEASURE, object -> this.mmlSeqView.addTicks(true));
        this.actionMap.put(REMOVE_MEASURE, object -> this.mmlSeqView.removeTicks(true));
        this.actionMap.put(ADD_BEAT, object -> this.mmlSeqView.addTicks(false));
        this.actionMap.put(REMOVE_BEAT, object -> this.mmlSeqView.removeTicks(false));
        this.actionMap.put(NOTE_PROPERTY, object -> this.editState.noteProperty());
        this.actionMap.put(TRANSPOSE, object -> new MMLTranspose(this.mainFrame, this.mmlSeqView).showDialog());
        this.actionMap.put(TRACKS_EDIT, object -> new MultiTracksVelocityChangeEditor(this.mainFrame, this.mmlSeqView).showDialog());
        this.actionMap.put(TRACKS_VIEW, object -> new MultiTracksViewEditor(this.mainFrame, this.mmlSeqView).showDialog());
        this.actionMap.put(ABOUT, object -> new About().show(this.mainFrame));
        this.actionMap.put(SHOW_LICENSES, object -> new About().showLicenses(this.mainFrame));
        this.actionMap.put(MIDI_EXPORT, object -> this.midiExportAction());
        this.actionMap.put(FILE_IMPORT, object -> this.fileImportAction());
        this.actionMap.put(SELECT_DLS, object -> this.selectDLSFileAction());
        this.actionMap.put(SELECT_ALL, object -> this.selectAction(() -> this.editState.selectAll()));
        this.actionMap.put(SELECT_PREVIOUS_ALL, object -> this.selectAction(() -> this.editState.selectPreviousAll()));
        this.actionMap.put(SELECT_AFTER_ALL, object -> this.selectAction(() -> this.editState.selectAfterAll()));
        this.actionMap.put(SELECT_ALL_SAME_PITCH, object -> this.selectAction(() -> this.editState.selectAllSamePitch()));
        this.actionMap.put(MML_IMPORT, object -> this.mmlSeqView.mmlImport());
        this.actionMap.put(MML_EXPORT, object -> this.mmlSeqView.mmlExport());
        this.actionMap.put(SWITCH_TRACK_NEXT, object -> this.mmlSeqView.switchTrack(true));
        this.actionMap.put(SWITCH_TRACK_PREV, object -> this.mmlSeqView.switchTrack(false));
        this.actionMap.put(SWITCH_MMLPART_NEXT, object -> this.mmlSeqView.switchMMLPart(true));
        this.actionMap.put(SWITCH_MMLPART_PREV, object -> this.mmlSeqView.switchMMLPart(false));
        this.actionMap.put(TOGGLE_LOOP, object -> this.toggleLoop());
        this.actionMap.put(FILE_OPEN_WITH_HISTORY, object -> this.fileOpenWithHistory(object));
        this.actionMap.put(ALL_CLEAR_TEMPO, object -> this.allClearTempo());
        this.actionMap.put(MML_GENERATE, object -> this.mmlSeqView.updateActivePart(true));
        this.actionMap.put(WAVOUT, object -> this.startWavOutAction());
        this.actionMap.put(KEYBOARD_INPUT, object -> this.mmlSeqView.showKeyboardInput());
        this.actionMap.put(INPUT_EMPTY_CORRECTION, object -> this.inputEmptyCorrection());
        this.actionMap.put(REMOVE_RESTS_BETWEEN_NOTES, object -> this.editState.removeRestsBetweenNotes());
        this.actionMap.put(SHOW_RESTART_DIALOG, object -> this.showAppRestartDialog());
        this.actionMap.put(SET_TEMP_MUTE, object -> this.editState.setTempMute(true));
        this.actionMap.put(UNSET_TEMP_MUTE, object -> this.editState.setTempMute(false));
        this.actionMap.put(UNSET_TEMP_MUTE_ALL, object -> this.editState.setTempMuteAll());
        this.actionMap.put(OCTAVE_UP, object -> this.editState.octaveUp());
        this.actionMap.put(OCTAVE_DOWN, object -> this.editState.octaveDown());
        this.actionMap.put(VELOCITY_UP, object -> this.editState.notesModifyVelocity(null, true));
        this.actionMap.put(VELOCITY_DOWN, object -> this.editState.notesModifyVelocity(null, false));
        this.actionMap.put(SET_USER_VIEW_MEASURE, object -> new UserViewWidthDialog(this.mainFrame, this.mmlSeqView).showDialog());
        this.actionMap.put(INST_LIST, object -> new About().showInstList(this.mainFrame));
        this.actionMap.put(SHORTCUT_INFO, object -> new About().showShortcutInfo(this.mainFrame, this.mainFrame.getShortcutMap()));
        this.actionMap.put(CONVERT_TUPLET, object -> this.editState.convertTuplet());
        this.actionMap.put(OTHER_MML_EXPORT, object -> this.otherMmlExportAction());
        this.actionMap.put(CHANGE_ACTION, object -> this.changeAction(object));
        this.actionMap.put(MML_TEXT_EDIT, object -> this.mmlSeqView.mmlTextEditor());
        this.actionMap.put(MML_ERR_LIST, object -> new MMLErrView(this.mmlSeqView.getMMLScore()).showMMLErrList(this.mainFrame));
        this.actionMap.put(MML_X_IMPORT, object -> this.mmlSeqView.mml_xImportAction());
        this.actionMap.put(MML_X_EXPORT, object -> this.mmlSeqView.mml_xExportAction());
        this.actionMap.put(POLYPHONY_MONITOR, object -> PolyphonyMonitor.getInstance().show(this.mainFrame));
        this.actionMap.put(MIDI_MABI_DRUM_CONVERT, object -> DrumConverter.getInstance().showConvertMap(this.mainFrame, this.mmlSeqView));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.doAction(actionEvent.getSource(), actionEvent.getActionCommand());
    }

    public void doAction(Object object, String string) {
        Consumer<Object> consumer = this.actionMap.get(string);
        if (consumer != null) {
            consumer.accept(object);
        } else {
            System.err.println("not found Action: " + string);
        }
    }

    private void fileOpenWithHistory(Object object) {
        if (object instanceof IntSupplier) {
            int n = ((IntSupplier)object).getAsInt();
            File file = this.appProperties.getFileHistory()[n];
            if (file == null || !file.exists()) {
                JOptionPane.showMessageDialog(this.mainFrame, AppResource.appText("error.nofile"), AppResource.appText("error.read"), 2);
            } else {
                this.checkAndOpenMMLFile(file);
            }
        }
    }

    public void checkAndOpenMMLFile(File file) {
        if (this.checkCloseModifiedFileState()) {
            this.openMMLFile(file);
        }
    }

    private void openMMLFile(File file) {
        FileLoader fileLoader = new FileLoader(this.mainFrame, file).prepare();
        NanoTime nanoTime = NanoTime.start();
        MMLScore mMLScore = fileLoader.parse();
        if (mMLScore != null && mMLScore.getTrackCount() > 0) {
            MabiDLS.getInstance().all();
            this.mmlSeqView.setMMLScore(mMLScore);
            this.openedFile = file;
            this.notifyUpdateFileState();
            this.appProperties.setRecentFile(file.getPath());
            this.appProperties.setFileHistory(file);
            this.mainFrame.updateFileHistoryMenu();
        }
        this.showTime("open", nanoTime);
    }

    private void reloadMMLFileAction() {
        int n;
        if (MabiDLS.getInstance().getSequencer().isRunning()) {
            return;
        }
        if (this.openedFile != null && this.fileState.isModified() && (n = JOptionPane.showConfirmDialog(this.mainFrame, AppResource.appText("message.throw"), AppResource.getAppTitle(), 0, 3)) == 0) {
            this.openMMLFile(this.openedFile);
        }
    }

    private void quitAction() {
        if (this.checkCloseModifiedFileState()) {
            System.exit(0);
        }
    }

    private boolean saveMMLFile(File file) {
        try {
            if (!file.exists()) {
                if (!Utils.isValidFile(file)) {
                    JOptionPane.showMessageDialog(this.mainFrame, "invalid name: " + file.getName(), "ERROR", 0);
                    return false;
                }
                Files.createFile(file.toPath(), new FileAttribute[0]);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            new MMLScoreSerializer(this.mmlSeqView.getMMLScore()).writeToOutputStream(fileOutputStream);
            this.mainFrame.setTitleAndFileName(file.getName());
            this.fileState.setOriginalBase();
            this.notifyUpdateFileState();
            this.appProperties.setRecentFile(file.getPath());
            this.appProperties.setFileHistory(file);
            this.mainFrame.updateFileHistoryMenu();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.mainFrame, AppResource.appText("fail.saveFile"), "ERROR", 0);
            return false;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.mainFrame, AppResource.appText("fail.saveFile") + "\n" + exception.getLocalizedMessage(), "ERROR", 0);
            return false;
        }
        return true;
    }

    private void newMMLFileAction() {
        if (this.checkCloseModifiedFileState()) {
            this.openedFile = null;
            this.mmlSeqView.initializeMMLTrack();
            this.mmlSeqView.setStartPosition();
            this.notifyUpdateFileState();
            MabiDLS.getInstance().all();
        }
    }

    private void openMMLFileAction() {
        if (MabiDLS.getInstance().getSequencer().isRunning()) {
            return;
        }
        if (this.checkCloseModifiedFileState()) {
            SwingUtilities.invokeLater(() -> {
                File file = this.fileOpenDialog();
                if (file != null) {
                    this.openMMLFile(file);
                }
            });
        }
    }

    private File fileOpenDialog() {
        String string = this.appProperties.getRecentFile();
        this.openFileChooser.setFileFilter(this.allFilter);
        this.openFileChooser.setAcceptAllFileFilterUsed(false);
        this.openFileChooser.setSelectedFile(null);
        this.openFileChooser.setCurrentDirectory(new File(string).getParentFile());
        int n = this.openFileChooser.showOpenDialog(this.mainFrame);
        if (n == 0) {
            return this.openFileChooser.getSelectedFile();
        }
        return null;
    }

    private void saveAsMMLFileAction() {
        SwingUtilities.invokeLater(() -> {
            this.showDialogSaveFile();
            this.notifyUpdateFileState();
        });
    }

    private File showSaveDialog(JFileChooser jFileChooser, String string) {
        String string2 = this.appProperties.getRecentFile();
        if (this.openedFile != null) {
            jFileChooser.setSelectedFile(this.openedFile);
        } else {
            jFileChooser.setSelectedFile(null);
            jFileChooser.setCurrentDirectory(new File(string2).getParentFile());
        }
        jFileChooser.setAcceptAllFileFilterUsed(false);
        int n = jFileChooser.showSaveDialog(this.mainFrame);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            if (!Utils.isValidFile(file)) {
                JOptionPane.showMessageDialog(this.mainFrame, "invalid name: " + file.getName(), "ERROR", 0);
                return null;
            }
            if (string != null && !file.toString().endsWith("." + string)) {
                file = new File(file + "." + string);
            }
            n = 0;
            if (file.exists()) {
                n = JOptionPane.showConfirmDialog(this.mainFrame, AppResource.appText("message.override") + "\n" + file.getName(), AppResource.getAppTitle(), 0, 3);
            }
            if (n == 0) {
                return file;
            }
        }
        return null;
    }

    private boolean showDialogSaveFile() {
        this.saveFileChooser.setFileFilter(this.mmiFilter);
        File file = this.showSaveDialog(this.saveFileChooser, "mmi");
        if (file != null && this.saveMMLFile(file)) {
            this.openedFile = file;
            return true;
        }
        return false;
    }

    private void midiExportAction() {
        File file = this.showSaveDialog(this.exportFileChooser, "mid");
        if (file != null) {
            try {
                MidiSystem.write(MabiDLS.getInstance().createSequenceForMidi(this.mmlSeqView.getMMLScore()), 1, file);
            }
            catch (IOException | InvalidMidiDataException exception) {
                JOptionPane.showMessageDialog(this.mainFrame, exception.getLocalizedMessage(), "ERROR", 0);
            }
        }
    }

    private void otherMmlExportAction() {
        MMLExportPanel mMLExportPanel = new MMLExportPanel(this.mainFrame, this.mmlSeqView.getMMLScore(), () -> this.showSaveDialog(this.txtFileChooser, "txt"));
        mMLExportPanel.showDialog();
    }

    private void startWavOutAction() {
        File file = this.showSaveDialog(this.wavoutFileChooser, "wav");
        if (file != null) {
            new WavoutPanel(this.mainFrame, this.mmlSeqView, file).showDialog();
        }
    }

    private void fileImportAction() {
        File file = this.fileOpenDialog();
        this.fileImport(file);
    }

    public void fileImport(File file) {
        if (file != null) {
            FileLoader fileLoader = new FileLoader(this.mainFrame, file).prepare();
            NanoTime nanoTime = NanoTime.start();
            MMLScore mMLScore = fileLoader.parse();
            this.showTime("import", nanoTime);
            if (mMLScore != null) {
                this.appProperties.setRecentFile(file.getPath());
                boolean bl = this.openedFile == null && !this.fileState.isModified();
                new MMLImportPanel(this.mainFrame, mMLScore, this.mmlSeqView, bl).showDialog();
            }
        }
    }

    private boolean checkCloseModifiedFileState() {
        if (!this.fileState.isModified()) {
            return true;
        }
        int n = JOptionPane.showConfirmDialog(this.mainFrame, AppResource.appText("message.modifiedClose"), AppResource.getAppTitle(), 1, 3);
        if (n == 2) {
            return false;
        }
        if (n == 1) {
            return true;
        }
        if (this.openedFile == null) {
            return this.showDialogSaveFile();
        }
        if (this.isSupportedSaveFile()) {
            return this.saveMMLFile(this.openedFile);
        }
        return this.showDialogSaveFile();
    }

    private boolean isSupportedSaveFile() {
        if (this.openedFile != null) {
            return this.openedFile.getName().toLowerCase().endsWith(".mmi");
        }
        return false;
    }

    private void scorePropertyAction() {
        MMLScorePropertyPanel mMLScorePropertyPanel = new MMLScorePropertyPanel();
        mMLScorePropertyPanel.showDialog(this.mainFrame, this.mmlSeqView.getMMLScore(), this.mmlSeqView.getFileState());
        this.mmlSeqView.repaint();
    }

    private void editPasteAction() {
        long l = this.mmlSeqView.getEditSequencePosition();
        this.editState.paste(l);
    }

    private void stopAction() {
        NanoTime nanoTime = NanoTime.start();
        MabiDLS.getInstance().getSequencer().stop();
        this.showTime(STOP, nanoTime);
        this.mainFrame.enableNoplayItems();
    }

    private void pauseAction() {
        this.stopAction();
        this.mmlSeqView.pauseTickPosition();
    }

    private void playAction() {
        if (MabiDLS.getInstance().getSequencer().isRunning()) {
            this.pauseAction();
        } else {
            this.mmlSeqView.startSequence();
            this.mainFrame.disableNoplayItems();
        }
    }

    private void selectAction(Runnable runnable) {
        runnable.run();
        this.mmlSeqView.repaint();
        this.notifyUpdateEditState();
    }

    @Override
    public void notifyUpdateFileState() {
        this.mainFrame.setCanSaveFile(false);
        this.mainFrame.setTitleAndFileName(null);
        this.mainFrame.setCanReloadFile(false);
        if (this.openedFile != null) {
            if (this.fileState.isModified()) {
                if (this.isSupportedSaveFile()) {
                    this.mainFrame.setCanSaveFile(true);
                }
                this.mainFrame.setTitleAndFileName(this.openedFile.getName() + " " + AppResource.appText("file.modified"));
                this.mainFrame.setCanReloadFile(true);
            } else {
                this.mainFrame.setTitleAndFileName(this.openedFile.getName());
            }
        }
        this.mainFrame.setCanUndo(this.fileState.canUndo());
        this.mainFrame.setCanRedo(this.fileState.canRedo());
    }

    public void addEditObserber(IEditStateObserver iEditStateObserver) {
        this.editObservers.add(iEditStateObserver);
    }

    @Override
    public void notifyUpdateEditState() {
        this.mainFrame.setSelectedEdit(this.editState.hasSelectedNote());
        this.mainFrame.setPasteEnable(this.editState.canPaste());
        this.mainFrame.setRemoveRestsBetweenNotesEnable(this.editState.hasSelectedMultipleConsecutiveNotes());
        MMLTrack mMLTrack = this.mmlSeqView.getActiveTrack();
        this.mainFrame.setXExport(mMLTrack != null && !mMLTrack.mmlRank().canCompose());
        this.editObservers.forEach(iEditStateObserver -> iEditStateObserver.notifyUpdateEditState());
    }

    private void toggleLoop() {
        MabiDLS mabiDLS;
        mabiDLS.setLoop(!(mabiDLS = MabiDLS.getInstance()).isLoop());
        this.mainFrame.updateLoop(mabiDLS.isLoop());
    }

    private void allClearTempo() {
        this.mmlSeqView.getMMLScore().getTempoEventList().clear();
        this.mmlSeqView.updateActivePart(true);
    }

    public boolean recoveryCheck() {
        File file = new File(AppResource.appText("recover.filename"));
        if (file.exists()) {
            int n = JOptionPane.showConfirmDialog(this.mainFrame, AppResource.appText("recover.message") + "\n" + file.getName(), AppResource.appText("recover.title"), 0);
            if (n != 0) {
                File file2 = new File(file.getAbsolutePath() + ".bak");
                file2.delete();
                file.renameTo(file2);
                return false;
            }
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
                String string = bufferedReader.readLine();
                String string2 = bufferedReader.readLine();
                bufferedReader.close();
                file.delete();
                boolean bl = this.mmlSeqView.recovery(string2);
                if (!bl) {
                    JOptionPane.showMessageDialog(this.mainFrame, "recover.fail", "recover.title", 2);
                }
                if (bl && string.length() > 0) {
                    this.openedFile = new File(string);
                }
                this.notifyUpdateFileState();
                return bl;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public void writeRecoveryData() {
        String string = "";
        if (this.openedFile != null) {
            string = this.openedFile.getAbsolutePath();
        }
        String string2 = this.mmlSeqView.getRecoveryData();
        try {
            File file = new File(AppResource.appText("recover.filename"));
            PrintStream printStream = new PrintStream((OutputStream)new FileOutputStream(file), false, StandardCharsets.UTF_8);
            printStream.println(string);
            printStream.println(string2);
            printStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void showTime(String string, long l) {
        if (this.mainFrame != null) {
            String string2 = string + " " + l + "ms";
            this.mainFrame.setStatusText(string2);
        }
    }

    public void showTime(String string, NanoTime nanoTime) {
        this.showTime(string, nanoTime.ms());
    }

    private void inputEmptyCorrection() {
        String string = JOptionPane.showInputDialog(this.mainFrame, AppResource.appText("mml.emptyCorrection"), this.appProperties.mmlEmptyCorrection.get());
        if (string != null) {
            this.appProperties.mmlEmptyCorrection.set(string);
        }
    }

    private void duplicateMMLTrack() {
        MMLTrack mMLTrack = this.mmlSeqView.getSelectedTrack().clone();
        this.mmlSeqView.addMMLTrack(mMLTrack);
    }

    private void showAppRestartDialog() {
        if (!this.testMode) {
            JOptionPane.showMessageDialog(this.mainFrame, AppResource.appText("message.appRestart"), AppResource.getAppTitle(), 1);
        }
    }

    private void selectDLSFileAction() {
        DLSSetupDialog dLSSetupDialog = new DLSSetupDialog(this.mainFrame);
        if (dLSSetupDialog.showDialog()) {
            this.showAppRestartDialog();
        }
    }

    private void changeAction(Object object) {
        if (object instanceof Supplier) {
            Object t = ((Supplier)object).get();
            if (t instanceof PianoRollView.NoteHeight) {
                PianoRollView.NoteHeight noteHeight = (PianoRollView.NoteHeight)t;
                this.mmlSeqView.setPianoRollHeightScale(noteHeight);
                this.appProperties.pianoRollNoteHeight.set((Object)noteHeight);
            } else if (t instanceof ScaleColor) {
                ScaleColor scaleColor = (ScaleColor)t;
                this.mmlSeqView.setScaleColor(scaleColor);
                this.appProperties.scaleColor.set((Object)scaleColor);
            } else if (t instanceof SoundEnv) {
                SoundEnv soundEnv = (SoundEnv)t;
                this.appProperties.soundEnv.set((Object)soundEnv);
                this.appProperties.useDefaultSoundBank.set(!soundEnv.useDLS());
                this.showAppRestartDialog();
            } else if (t instanceof MMLMidiTrack.OverlapMode) {
                MMLMidiTrack.OverlapMode overlapMode = (MMLMidiTrack.OverlapMode)t;
                this.appProperties.overlapMode.set(overlapMode);
                this.mmlSeqView.repaint();
            } else if (t instanceof PianoRollScaler.MouseScrollWidth) {
                PianoRollScaler.MouseScrollWidth mouseScrollWidth = (PianoRollScaler.MouseScrollWidth)t;
                this.appProperties.mouseScrollWidth.set((Object)mouseScrollWidth);
            } else if (t instanceof Laf) {
                Laf laf = (Laf)t;
                if ((laf = laf.update()) != null) {
                    this.appProperties.laf.set((Object)laf);
                    this.updateUIComponents.forEach(component -> SwingUtilities.updateComponentTreeUI(component));
                    this.initializeFileChooser();
                    this.mainFrame.repaint();
                }
            } else if (t instanceof VelocityEditor.VelocityWidth) {
                VelocityEditor.VelocityWidth velocityWidth = (VelocityEditor.VelocityWidth)t;
                this.appProperties.velocityWidth.set((Object)velocityWidth);
                this.mainFrame.repaint();
            } else if (t instanceof MMLOptimizeLevel) {
                MMLOptimizeLevel mMLOptimizeLevel = (MMLOptimizeLevel)t;
                this.appProperties.mmlOptimizeLevel.set((Object)mMLOptimizeLevel);
                this.doAction(this, MML_GENERATE);
            } else if (t instanceof EditTool) {
                EditTool editTool = (EditTool)t;
                this.editState.changeEditTool(editTool);
            } else if (t instanceof MMLSeqView.ScrollFollowMode) {
                MMLSeqView.ScrollFollowMode scrollFollowMode = (MMLSeqView.ScrollFollowMode)t;
                this.appProperties.scrollFollowMode.set((Object)scrollFollowMode);
            } else {
                System.err.println("changeAction invalid param " + t.getClass().toString());
            }
        }
    }

    private static class FileLoader {
        private final Frame parent;
        private final File file;
        private final IMMLFileParser parser;
        private boolean prepare = false;
        private boolean done = false;
        private MMLScore score = null;

        private FileLoader(Frame frame, File file) {
            this.file = file;
            this.parent = frame;
            this.parser = IMMLFileParser.getParser(file);
        }

        private FileLoader prepare() {
            if (this.prepare) {
                return this;
            }
            this.prepare = true;
            if (!new ParsePropertiesDialog(this.parent, this.parser).showDialog()) {
                this.done = true;
            }
            return this;
        }

        private MMLScore parse() {
            if (!this.done) {
                try (FileInputStream fileInputStream = new FileInputStream(this.file);){
                    this.score = this.parser.parse(fileInputStream);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    JOptionPane.showMessageDialog(this.parent, AppResource.appText("error.nofile"), AppResource.appText("error.read"), 2);
                }
                catch (MMLParseException mMLParseException) {
                    JOptionPane.showMessageDialog(this.parent, AppResource.appText(mMLParseException.getMessage()), AppResource.appText("error.read"), 2);
                }
                catch (Throwable throwable) {
                    JOptionPane.showMessageDialog(this.parent, throwable.getClass().getCanonicalName(), AppResource.appText("error.read"), 2);
                }
                if (this.score != null) {
                    this.score = this.score.toGeneratedScore((Boolean)MabiIccoProperties.getInstance().reGenerateWithOpen.get());
                }
                this.done = true;
            }
            return this.score;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Action {
    }
}

